/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g.io;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.tools.JAMSTools;
import java.util.ArrayList;
import org.unijena.j2k.J2KFunctions;

public class StandardEntityReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity parameter file name")
    public Attribute.String entityFileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="entity collection")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Name of identifier", defaultValue="ID")
    public Attribute.String identName;

    public void init() {
        ArrayList<Attribute.Entity> collection = J2KFunctions.readParas(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.entityFileName.getValue()), this.getModel());
        for (Attribute.Entity e : collection) {
            try {
                e.setId((long)e.getDouble(this.identName.getValue()));
            }
            catch (Attribute.Entity.NoSuchAttributeException nsae) {
                this.getModel().getRuntime().sendErrorMsg("Couldn't find attribute \"" + this.identName + "\" while reading J2K HRU parameter file (" + this.entityFileName.getValue() + ")!");
            }
        }
        this.entities.setEntities(collection);
        int nEnt = this.entities.getEntityArray().length;
        this.getModel().getRuntime().println("Entities read and created successfull! (" + nEnt + ")", 1);
    }
}

