/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="TwoCompGroundwater", author="Peter Krause", description="Groundwater module with two components (matrix and fissuresor clefts). The incoming water is distributed among the components witha parameter alpha (0;1). The two components are represented by linearflow cascades with the two parmeters n1,2 (number of storages) and k1,2 (recession coefficients) which hold the water back for some time to simulate translation and retention. The two components are aggregated at the end to provide the outflow of the module.")
public class TwoCompGroundwater
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="groundwater recharge from antecedent module")
    public Attribute.Double gwRecharge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="number of storages of cascade 1")
    public Attribute.Integer n1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="recision coefficient of cascade 1")
    public Attribute.Double k1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="groundwater storages of cascade 1")
    public Attribute.DoubleArray gwStor1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total groundwater storage content of cascade 1")
    public Attribute.Double gwStorCont1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="outflow from cascade 1")
    public Attribute.Double q1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="number of storages of cascade 2")
    public Attribute.Integer n2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="recision coefficient k2")
    public Attribute.Double k2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="groundwater storages of cascade 2")
    public Attribute.DoubleArray gwStor2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total groundwater storage content of cascade 2")
    public Attribute.Double gwStorCont2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="outflow from cascade 2")
    public Attribute.Double q2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="aggregated outflow from both cascades")
    public Attribute.Double basQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="distribution coefficient alpha")
    public Attribute.Double alpha;

    public void init() {
        double[] stor1 = new double[this.n1.getValue()];
        for (int i = 0; i < this.n1.getValue(); ++i) {
            stor1[i] = 0.0;
        }
        this.gwStor1.setValue(stor1);
        double[] stor2 = new double[this.n2.getValue()];
        for (int i = 0; i < this.n2.getValue(); ++i) {
            stor2[i] = 0.0;
        }
        this.gwStor2.setValue(stor2);
    }

    public void run() {
        double inflow = this.gwRecharge.getValue();
        double inC1 = this.alpha.getValue() * inflow;
        double inC2 = (1.0 - this.alpha.getValue()) * inflow;
        double[] stor1 = this.gwStor1.getValue();
        double[] out1 = new double[stor1.length];
        stor1[0] = stor1[0] + inC1;
        for (int i = 0; i < this.n1.getValue(); ++i) {
            out1[i] = 1.0 / this.k1.getValue() * stor1[i];
            stor1[i] = stor1[i] - out1[i];
            if (i >= this.n1.getValue() - 1) continue;
            stor1[i + 1] = stor1[i + 1] + out1[i];
        }
        this.q1.setValue(out1[this.n1.getValue() - 1]);
        this.gwStor1.setValue(stor1);
        double[] stor2 = this.gwStor2.getValue();
        double[] out2 = new double[stor2.length];
        stor2[0] = stor2[0] + inC2;
        for (int i = 0; i < this.n2.getValue(); ++i) {
            out2[i] = 1.0 / this.k2.getValue() * stor2[i];
            stor2[i] = stor2[i] - out2[i];
            if (i >= this.n2.getValue() - 1) continue;
            stor2[i + 1] = stor2[i + 1] + out2[i];
        }
        this.q2.setValue(out2[this.n2.getValue() - 1]);
        this.gwStor2.setValue(stor2);
        double cont1 = 0.0;
        for (int i = 0; i < this.n1.getValue(); ++i) {
            cont1 += stor1[i];
        }
        this.gwStorCont1.setValue(cont1);
        double cont2 = 0.0;
        for (int i = 0; i < this.n2.getValue(); ++i) {
            cont2 += stor2[i];
        }
        this.gwStorCont2.setValue(cont2);
        this.basQ.setValue(this.q1.getValue() + this.q2.getValue());
    }

    public void cleanup() {
    }
}

