/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="SoilWaterBalance", author="Peter Krause", description="Calculates a simplified soil water balance for each HRU")
public class SoilWaterBalance
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute slope")
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum MPS")
    public Attribute.Double maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU state var actual MPS")
    public Attribute.Double actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="HRU state var relative saturation of MPS")
    public Attribute.Double satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="direct runoff")
    public Attribute.Double dirQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="groundwater recharge")
    public Attribute.Double gwRecharge;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="total runoff")
    public Attribute.Double totQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="potential ET")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actual ET")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="precipitation")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow melt")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="lateral-vertical distribution coefficient")
    public Attribute.Double latVertDist;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="ET reduction factor")
    public Attribute.Double linETRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU attribute maximum percolation")
    public Attribute.Double maxPerc;

    public void init() {
    }

    public void run() {
        double actMPS = this.actMPS.getValue();
        double inflow = this.precip.getValue() + this.snowMelt.getValue();
        double maxMPS = this.maxMPS.getValue();
        double actET = this.actET.getValue();
        double potET = this.potET.getValue();
        double deltaET = potET - actET;
        if (inflow >= deltaET) {
            actET = potET;
            inflow -= deltaET;
            deltaET = 0.0;
        } else {
            actET += inflow;
            inflow = 0.0;
            deltaET = potET - actET;
        }
        double linRed = this.linETRed.getValue();
        double reduceET = 1.0;
        if (actMPS < linRed * maxMPS) {
            reduceET = actMPS / (linRed * maxMPS);
        }
        if (actMPS >= (deltaET *= reduceET)) {
            actET += deltaET;
            actMPS -= deltaET;
            deltaET = 0.0;
        } else {
            actET += actMPS;
            actMPS = 0.0;
        }
        double deltaMPS = maxMPS - actMPS;
        if (inflow <= deltaMPS) {
            actMPS += inflow;
            inflow = 0.0;
        } else {
            actMPS = maxMPS;
            inflow -= deltaMPS;
        }
        deltaMPS = maxMPS - actMPS;
        if (inflow <= deltaMPS) {
            actMPS += inflow;
            inflow = 0.0;
        } else {
            actMPS = maxMPS;
            inflow -= deltaMPS;
        }
        double dQ = 0.0;
        double gR = 0.0;
        double slope_weight = Math.tan(this.slope.getValue() * (Math.PI / 180)) * this.latVertDist.getValue();
        if (slope_weight > 1.0) {
            slope_weight = 1.0;
        }
        dQ = slope_weight * inflow;
        gR = (1.0 - slope_weight) * inflow;
        inflow = 0.0;
        if (gR > this.maxPerc.getValue()) {
            double delta = gR - this.maxPerc.getValue();
            dQ += delta;
            gR = this.maxPerc.getValue();
        }
        this.actET.setValue(actET);
        this.actMPS.setValue(actMPS);
        this.satMPS.setValue(actMPS / maxMPS);
        this.gwRecharge.setValue(gR);
        this.dirQ.setValue(dQ);
        this.totQ.setValue(dQ + gR);
    }

    public void cleanup() {
    }
}

