/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class FlowConverter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="catchment area")
    public Attribute.Double cArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="input")
    public Attribute.Double inQ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="output in cms")
    public Attribute.Double outQcbm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="output in mm")
    public Attribute.Double outQmm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="output in litres")
    public Attribute.Double outQl;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="temporal resolution [h;d;m]")
    public Attribute.String tempRes;

    public void init() {
    }

    public void run() {
        if (this.tempRes.getValue().equalsIgnoreCase("h")) {
            this.outQcbm.setValue(this.inQ.getValue() / 3600000.0);
            this.outQl.setValue(this.inQ.getValue() / 3600.0);
            this.outQmm.setValue(this.inQ.getValue() / this.cArea.getValue());
        } else if (this.tempRes.getValue().equalsIgnoreCase("d")) {
            this.outQcbm.setValue(this.inQ.getValue() / 8.64E7);
            this.outQl.setValue(this.inQ.getValue() / 86400.0);
            this.outQmm.setValue(this.inQ.getValue() / this.cArea.getValue());
        } else if (this.tempRes.getValue().equalsIgnoreCase("m")) {
            this.outQcbm.setValue(this.inQ.getValue() / 2.592E9);
            this.outQl.setValue(this.inQ.getValue() / 2592000.0);
            this.outQmm.setValue(this.inQ.getValue() / this.cArea.getValue());
        }
    }

    public void cleanup() {
    }
}

