/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2000g;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class CapillarRising
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="groundwater storage", unit="L")
    public Attribute.Double gwStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maxMPS", unit="L")
    public Attribute.Double maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="actMPS", unit="L")
    public Attribute.Double actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="satMPS", unit="-")
    public Attribute.Double satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="gwCapRise", defaultValue="1.0", unit="-")
    public Attribute.Double gwCapRise;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="gwCapRiseAdaptation", unit="-")
    public Attribute.Double gwCapRiseAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="current CapRise", unit="-")
    public Attribute.Double actCapRise;

    public void run() {
        double actMPS = this.actMPS.getValue();
        double maxMPS = this.maxMPS.getValue();
        if (maxMPS == 0.0) {
            this.getModel().getRuntime().println("Olala there is a HRU with zero Field Capacity .. ");
            return;
        }
        double satMPS = actMPS / maxMPS;
        double gwStorage = this.gwStorage.getValue();
        double deltaMPS = maxMPS - actMPS;
        double alpha = this.gwCapRise.getValue() * this.gwCapRiseAdaptation.getValue();
        double inMPS = 0.0;
        inMPS = satMPS != 0.0 ? deltaMPS * (1.0 - satMPS) * alpha : deltaMPS * alpha;
        if (gwStorage < inMPS) {
            inMPS = gwStorage;
        }
        this.gwStorage.setValue(gwStorage -= inMPS);
        this.actMPS.setValue(actMPS += inMPS);
        this.satMPS.setValue(actMPS / maxMPS);
        this.actCapRise.setValue(inMPS);
    }
}

