/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.statistics;

public class LatinHypercube {
    public static void main(String[] args) {
        double[] uB = new double[]{1.0, 10.0};
        double[] lB = new double[]{0.0, 0.0};
        int nPars = lB.length;
        int res = 100;
        double[] rL = LatinHypercube.randomLHS(lB, uB, res);
        double[] iL = LatinHypercube.improvedLHS(lB, uB, res, 2);
        int counter = 0;
        for (int r = 0; r < res; ++r) {
            for (int i = 0; i < nPars; ++i) {
                System.out.print(iL[i * res + r] + ", ");
                ++counter;
            }
            System.out.println("");
        }
    }

    static double[] randomLHS(double[] lowBounds, double[] uppBounds, int resolution) {
        int outCounter = 0;
        int nPars = lowBounds.length;
        double[] randLHS = new double[nPars * resolution];
        for (int i = 0; i < nPars; ++i) {
            int r;
            double range = uppBounds[i] - lowBounds[i];
            double step = range / (double)resolution;
            double start = lowBounds[i];
            double[] vals = new double[resolution];
            for (r = 0; r < resolution; ++r) {
                double end = start + step;
                vals[r] = start + Math.random() * step;
                start = end;
            }
            LatinHypercube.shuffle(vals);
            for (r = 0; r < resolution; ++r) {
                randLHS[outCounter] = vals[r];
                ++outCounter;
            }
        }
        return randLHS;
    }

    static double sumInvDistance(int[] matrix, int nr, int nc) {
        double totalInvDistance = 0.0;
        for (int i = 0; i < nr - 1; ++i) {
            for (int j = i + 1; j < nr; ++j) {
                int oneDistance = 0;
                for (int k = 0; k < nc; ++k) {
                    oneDistance += (matrix[i * nc + k] - matrix[j * nc + k]) * (matrix[i * nc + k] - matrix[j * nc + k]);
                }
                totalInvDistance += 1.0 / Math.sqrt(oneDistance);
            }
        }
        return totalInvDistance;
    }

    public static int[] optimumLHS(double[] lowBounds, double[] uppBounds, int nPoints, int maxsweeps, double eps) {
        int j = 0;
        int nPars = lowBounds.length;
        int[] pOld = new int[nPoints * nPars];
        int[] pNew = new int[nPoints * nPars];
        int bc = (int)LatinHypercube.binomialCoefficient(nPoints, nPars) + 1;
        int[] J1 = new int[bc];
        int[] J2 = new int[bc];
        int[] J3 = new int[bc];
        for (int i = 0; i < pOld.length; ++i) {
            pOld[i] = i + 1;
        }
        double gOld = LatinHypercube.sumInvDistance(pOld, nPoints, nPars);
        System.out.println("Beginning Optimality Criterion: " + gOld);
        boolean test = false;
        int iter = 0;
        block1: while (!test && iter != maxsweeps) {
            ++iter;
            for (j = 0; j < nPars; ++j) {
                int k;
                int r = 0;
                for (int i = 0; i < nPoints - 1; ++i) {
                    k = i + 1;
                    while (k < nPoints) {
                        for (int row = 0; row < nPoints; ++row) {
                            for (int col = 0; col < nPars; ++col) {
                                pNew[row * nPars + col] = pOld[row * nPars + col];
                            }
                        }
                        pNew[i * nPars + j] = pOld[k * nPars + j];
                        pNew[k * nPars + j] = pOld[i * nPars + j];
                        J1[r] = (int)LatinHypercube.sumInvDistance(pNew, nPoints, nPars);
                        J2[r] = i;
                        J3[r] = k++;
                        ++r;
                    }
                }
                J1[r] = (int)gOld;
                J2[r] = 0;
                J3[r] = 0;
                int posit = 0;
                for (k = 0; k < bc; ++k) {
                    if (J1[k] >= J1[posit]) continue;
                    posit = k;
                }
                if ((double)J1[posit] < gOld) {
                    int col;
                    int row;
                    for (row = 0; row < nPoints; ++row) {
                        for (col = 0; col < nPars; ++col) {
                            pNew[row * nPars + col] = pOld[row * nPars + col];
                        }
                    }
                    pNew[J2[posit] * nPars + j] = pOld[J3[posit] * nPars + j];
                    pNew[J3[posit] * nPars + j] = pOld[J2[posit] * nPars + j];
                    for (row = 0; row < nPoints; ++row) {
                        for (col = 0; col < nPars; ++col) {
                            pOld[row * nPars + col] = pNew[row * nPars + col];
                        }
                    }
                    double deltag1 = 0.0;
                    if (j > 0) {
                        double deltag = Math.abs((double)J1[posit] - gOld);
                        if (deltag < eps * deltag1) {
                            test = true;
                            System.out.println("Algorithm stopped when the change in the inverse distance measure was smaller than " + eps * deltag1);
                        }
                    } else {
                        deltag1 = Math.abs((double)J1[posit] - gOld);
                    }
                    gOld = J1[posit];
                } else if ((double)J1[posit] == gOld) {
                    test = true;
                    System.out.println("Algorithm stopped when changes did not impove design optimality");
                } else if ((double)J1[posit] > gOld) {
                    System.out.println("Unexpected Result: Algorithm produced a less optimal design");
                    test = true;
                }
                if (test) continue block1;
            }
        }
        if (iter == maxsweeps) {
            System.out.println("full sweeps completed: " + maxsweeps);
        } else {
            System.out.println("Algorithm used" + (iter - 1) + " sweep(s) and " + j + " extra column(s)");
        }
        System.out.println("Final Optimality Criterion: " + gOld);
        test = true;
        for (int col = 0; col < nPars; ++col) {
            int total = 0;
            for (int row = 0; row < nPoints; ++row) {
                total += pOld[row * nPars + col];
            }
            if (total == nPoints * (nPoints + 1) / 2) continue;
            test = false;
        }
        if (!test) {
            System.out.println("Invalid Hypercube");
        }
        for (int row = 0; row < nPoints; ++row) {
            for (int col = 0; col < nPars; ++col) {
                System.out.print(pOld[row * nPars + col] + ", ");
            }
            System.out.println("");
        }
        return pOld;
    }

    public static double[] improvedLHS(double[] lowBounds, double[] uppBounds, int nPoints, int duplication) {
        int col;
        int row;
        int nPars = lowBounds.length;
        int[] avail = new int[nPars * nPoints];
        int[] intResult = new int[nPars * nPoints];
        double[] lhsResult = new double[nPars * nPoints];
        int[] list1 = new int[duplication * (nPoints - 1)];
        int[] point1 = new int[nPars * duplication * (nPoints - 1)];
        int[] vec = new int[nPars];
        double OPT = (double)nPoints / Math.pow(nPoints, 1.0 / (double)nPars);
        double OPT2 = OPT * OPT;
        int len = duplication * (nPoints - 1);
        boolean test = true;
        for (row = 0; row < nPars; ++row) {
            for (col = 0; col < nPoints; ++col) {
                avail[row * nPoints + col] = col + 1;
            }
        }
        for (row = 0; row < nPars; ++row) {
            intResult[row * nPoints + (nPoints - 1)] = (int)Math.floor(Math.random() * (double)nPoints + 1.0);
        }
        for (row = 0; row < nPars; ++row) {
            avail[row * nPoints + (intResult[row * nPoints + (nPoints - 1)] - 1)] = nPoints;
        }
        for (int count = nPoints - 1; count > 0; --count) {
            int j;
            for (row = 0; row < nPars; ++row) {
                for (col = 0; col < duplication; ++col) {
                    for (j = 0; j < count; ++j) {
                        list1[j + count * col] = avail[row * nPoints + j];
                    }
                }
                for (col = count * duplication; col > 0; --col) {
                    int point_index = (int)Math.floor(Math.random() * (double)col + 1.0);
                    point1[row * len + (col - 1)] = list1[point_index];
                    list1[point_index] = list1[col - 1];
                }
            }
            double min_all = 1.0E100;
            int best = 0;
            for (col = 0; col < duplication * count - 1; ++col) {
                int min_candidate = 10000000;
                for (j = count; j < nPoints; ++j) {
                    int distSquared = 0;
                    for (int k = 0; k < nPars; ++k) {
                        vec[k] = point1[k * len + col] - intResult[k * nPoints + j];
                        distSquared += vec[k] * vec[k];
                    }
                    if (min_candidate <= distSquared) continue;
                    min_candidate = distSquared;
                }
                if (!(Math.abs((double)min_candidate - OPT2) < min_all)) continue;
                min_all = Math.abs((double)min_candidate - OPT2);
                best = col;
            }
            for (row = 0; row < nPars; ++row) {
                intResult[row * nPoints + (count - 1)] = point1[row * len + best];
            }
            for (row = 0; row < nPars; ++row) {
                for (col = 0; col < nPoints; ++col) {
                    if (avail[row * nPoints + col] != intResult[row * nPoints + (count - 1)]) continue;
                    avail[row * nPoints + col] = avail[row * nPoints + (count - 1)];
                }
            }
        }
        for (row = 0; row < nPars; ++row) {
            intResult[row * nPoints + 0] = avail[row * nPoints + 0];
        }
        for (row = 0; row < nPars; ++row) {
            int total = 0;
            for (col = 0; col < nPoints; ++col) {
                total += intResult[row * nPoints + col];
            }
            if (total == nPoints * (nPoints + 1) / 2) continue;
            test = false;
        }
        if (!test) {
            System.out.println("Invalid Hypercube");
        }
        for (row = 0; row < nPars; ++row) {
            for (col = 0; col < nPoints; ++col) {
                double lhsVal = ((double)(intResult[row * nPoints + col] - 1) + Math.random()) / (double)nPoints;
                lhsResult[row * nPoints + col] = lowBounds[row] + (uppBounds[row] - lowBounds[row]) * lhsVal;
            }
        }
        return lhsResult;
    }

    public static void shuffle(double[] valArray) {
        for (int i = 0; i < valArray.length; ++i) {
            int pos = i + (int)(Math.random() * (double)(valArray.length - i));
            double swap = valArray[i];
            valArray[i] = valArray[pos];
            valArray[pos] = swap;
        }
    }

    public static long binomialCoefficient(int n, int r) {
        long t = 1L;
        int m = n - r;
        if (r < m) {
            r = m;
        }
        int i = n;
        int j = 1;
        while (i > r) {
            t = t * (long)i / (long)j;
            --i;
            ++j;
        }
        return t;
    }
}

