/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.soilWater;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KContourBanks_layerinterface", author="Manfred Fink", description="Interface for the layered soilwater modul before the calculation of the contour banks")
public class J2KContourBanks_layer_calc_depth
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="An- bzw. Ausschalten des Moduls")
    public Attribute.Boolean cbModulAktiv;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current hru entity")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="actual LPS water content", unit="l")
    public Attribute.DoubleArray actLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum LPS water content", unit="l")
    public Attribute.DoubleArray maxLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="interflow reaching the HRU in every layer", unit="L", lowerBound=0.0, upperBound=1.0E8)
    public Attribute.DoubleArray RD2_in;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description=" number of soil layers", unit="-", lowerBound=0.0, upperBound=100.0)
    public Attribute.Double Layer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="depth of soil layer", unit="cm", lowerBound=0.0, upperBound=10000.0)
    public Attribute.DoubleArray layerdepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="depth of soil layers cutted by the trench", unit="cm", lowerBound=0.0, upperBound=10000.0)
    public Attribute.Double sumlayer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="number of the deepest soil layers cutted by the trench", unit="-", lowerBound=0.0, upperBound=100.0)
    public Attribute.Double layermax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="interflow reaching the HRU in the layers affected by the trench", unit="l", lowerBound=0.0, upperBound=1.0E8)
    public Attribute.Double RD2_insum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="average soil saturation of the layers affected by the trench", unit="l", lowerBound=0.0, upperBound=1.0E8)
    public Attribute.Double avgsatsoil;
    boolean modulCBaktiv;

    public void init() {
        double runsumlayer = 0.0;
        int i = 0;
        int runlayermax = 0;
        Attribute.Entity actHRU = this.hrus.getCurrent();
        double tiefeGraben_vorn = actHRU.getDouble("cbGrabentiefe_vorn") * 100.0;
        while ((double)i < this.Layer.getValue()) {
            if (runsumlayer < tiefeGraben_vorn) {
                runsumlayer += this.layerdepth.getValue()[i];
                runlayermax = i;
            }
            ++i;
        }
        this.sumlayer.setValue(runsumlayer);
        this.layermax.setValue((double)runlayermax);
    }

    public void run() {
        int i = 0;
        double sumactLPS = 0.0;
        double summaxLPS = 0.0;
        double sumRD2_in = 0.0;
        while ((double)i <= this.layermax.getValue()) {
            sumactLPS += this.actLPS.getValue()[i];
            summaxLPS += this.maxLPS.getValue()[i];
            sumRD2_in += this.RD2_in.getValue()[i];
        }
        this.avgsatsoil.setValue(sumactLPS / summaxLPS);
        this.RD2_insum.setValue(sumRD2_in);
    }
}

