/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.awt.Point;
import java.util.HashMap;
import org.unijena.j2k.routing.PolygonRasterMap;

@JAMSComponentDescription(title="J2KRasterRouting", author="Christin Michel", description="Wandelt Rasterebene wieder in HRU-Aufl?sung um")
public class RasterToReach
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Entity information;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Entity fuellstand;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage")
    public Attribute.Double reachID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD1 storage")
    public Attribute.Double actRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD2 storage")
    public Attribute.Double actRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG1 storage")
    public Attribute.Double actRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage")
    public Attribute.Double actRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD1 storage")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RD2 storage")
    public Attribute.Double inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG1 storage")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Reach statevar RG2 storage", defaultValue="0")
    public Attribute.Double totalToReach;
    double value = 0.0;

    public double Raster_to_Reach(PolygonRasterMap map, double[][] fuellstand_raster, int aufloesung) {
        map.storage = 0.0;
        for (Point p : map.rasterIDs) {
            map.storage += fuellstand_raster[p.x][p.y];
            this.value += fuellstand_raster[p.x][p.y];
            fuellstand_raster[p.x][p.y] = 0.0;
        }
        return map.storage;
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double ID = this.reachID.getValue();
        this.value = this.totalToReach.getValue();
        double[][] RD1raster = null;
        double[][] RD2raster = null;
        double[][] RG1raster = null;
        double[][] RG2raster = null;
        double inRD1 = this.inRD1.getValue();
        double inRD2 = this.inRD2.getValue();
        double inRG1 = this.inRG1.getValue();
        double inRG2 = this.inRG2.getValue();
        HashMap actReachList = new HashMap();
        try {
            actReachList = (HashMap)this.information.getObject("reachlist");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            RD1raster = (double[][])this.fuellstand.getObject("RD1_raster");
            RD2raster = (double[][])this.fuellstand.getObject("RD2_raster");
            RG1raster = (double[][])this.fuellstand.getObject("RG1_raster");
            RG2raster = (double[][])this.fuellstand.getObject("RG2_raster");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        PolygonRasterMap map = (PolygonRasterMap)actReachList.get((int)ID);
        this.totalToReach.setValue(this.value);
        this.inRD1.setValue(inRD1 += this.Raster_to_Reach(map, RD1raster, 1));
        this.inRD2.setValue(inRD2 += this.Raster_to_Reach(map, RD2raster, 1));
        this.inRG1.setValue(inRG1 += this.Raster_to_Reach(map, RG1raster, 1));
        this.inRG2.setValue(inRG2 += this.Raster_to_Reach(map, RG2raster, 1));
    }
}

