/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.awt.Point;

@JAMSComponentDescription(title="J2KRasterRouting", author="Christin Michel", description="")
public class RasterRouting
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Entity information;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="")
    public Attribute.Entity fuellstand;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Catchment outlet RG2 storage")
    public Attribute.Double catchmentSimRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Reach statevar simulated Runoff")
    public Attribute.Double simRunoff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach statevar simulated Runoff")
    public Attribute.Double RD1_RR_Koeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach statevar simulated Runoff")
    public Attribute.Double RD2_RR_Koeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach statevar simulated Runoff")
    public Attribute.Double RG1_RR_Koeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach statevar simulated Runoff")
    public Attribute.Double RG2_RR_Koeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="spatial grid resolution")
    public Attribute.Double gridresolution;
    double max = 0.0;

    public void RasterRouting(double anteil, Point[][] routing, int[][] dgm_sort, int[][] fliessrichtung, double[][] fuellstand, int[][] flgew1, double aufloesung) {
        for (int lauf = 0; lauf < dgm_sort[0].length; ++lauf) {
            int zeile = dgm_sort[1][lauf];
            int spalte = dgm_sort[2][lauf];
            if ((int)fuellstand[zeile][spalte] <= 0 || fliessrichtung[zeile][spalte] <= 0) continue;
            Point p = routing[zeile][spalte];
            if (flgew1[zeile][spalte] != -1) continue;
            double tmp = fuellstand[zeile][spalte] * anteil;
            double[] dArray = fuellstand[zeile];
            int n = spalte;
            dArray[n] = dArray[n] - tmp;
            double[] dArray2 = fuellstand[p.x];
            int n2 = p.y;
            dArray2[n2] = dArray2[n2] + tmp;
        }
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        double[][] RD1raster = null;
        double[][] RD2raster = null;
        double[][] RG1raster = null;
        double[][] RG2raster = null;
        int[][] actfliessrichtung = null;
        int[][] actflgew1 = null;
        int[][] actdgm_sort = null;
        double aufloesung = this.gridresolution.getValue();
        try {
            RD1raster = (double[][])this.fuellstand.getObject("RD1_raster");
            RD2raster = (double[][])this.fuellstand.getObject("RD2_raster");
            RG1raster = (double[][])this.fuellstand.getObject("RG1_raster");
            RG2raster = (double[][])this.fuellstand.getObject("RG2_raster");
            actfliessrichtung = (int[][])this.information.getObject("fliessrichtung");
            actdgm_sort = (int[][])this.information.getObject("dgm_sort");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        Point[][] actroutingRD1 = null;
        Point[][] actroutingRD2 = null;
        Point[][] actroutingRG1 = null;
        Point[][] actroutingRG2 = null;
        try {
            actroutingRD1 = (Point[][])this.information.getObject("routingRD1");
            actroutingRD2 = (Point[][])this.information.getObject("routingRD2");
            actroutingRG1 = (Point[][])this.information.getObject("routingRG1");
            actroutingRG2 = (Point[][])this.information.getObject("routingRG2");
            actflgew1 = (int[][])this.information.getObject("flgew1");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        double RD1_Koeff = this.RD1_RR_Koeff.getValue();
        double RD2_Koeff = this.RD2_RR_Koeff.getValue();
        double RG1_Koeff = this.RG1_RR_Koeff.getValue();
        double RG2_Koeff = this.RG2_RR_Koeff.getValue();
        this.RasterRouting(RD1_Koeff, actroutingRD1, actdgm_sort, actfliessrichtung, RD1raster, actflgew1, aufloesung);
        this.RasterRouting(RD2_Koeff, actroutingRD2, actdgm_sort, actfliessrichtung, RD2raster, actflgew1, aufloesung);
        this.RasterRouting(RG1_Koeff, actroutingRG1, actdgm_sort, actfliessrichtung, RG1raster, actflgew1, aufloesung);
        this.RasterRouting(RG2_Koeff, actroutingRG2, actdgm_sort, actfliessrichtung, RG2raster, actflgew1, aufloesung);
        this.fuellstand.setObject("RD1_raster", (Object)RD1raster);
        this.fuellstand.setObject("RD2_raster", (Object)RD2raster);
        this.fuellstand.setObject("RG1_raster", (Object)RG1raster);
        this.fuellstand.setObject("RG2_raster", (Object)RG2raster);
    }
}

