/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

@JAMSComponentDescription(title="Title", author="Author", description="Description")
public class CalcDailySolarRadiation_1
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable sunshine hours [h/d]")
    public Attribute.Double sunh;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Maximum sunshine duration in h")
    public Attribute.Double sunhmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable slope aspect correction factor")
    public Attribute.Double actSlAsCf;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute latitude [deg]")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily extraterrestic radiation [MJ/m\u00b2d]")
    public Attribute.Double actExtRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="daily solar radiation [MJ/m\u00b2d]")
    public Attribute.Double solRad;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Angstrom factor a")
    public Attribute.Double angstrom_a;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Angstrom factor b")
    public Attribute.Double angstrom_b;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Use caching of regionalised data?")
    public Attribute.Boolean dataCaching;
    private File cacheFile;
    private boolean useCache = false;
    private transient ObjectOutputStream writer;
    private transient ObjectInputStream reader;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void init() throws Attribute.Entity.NoSuchAttributeException, IOException {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        int julDay = this.time.get(6);
        int month = this.time.get(2);
        double SAC = this.actSlAsCf.getValue();
        double lati = this.latitude.getValue();
        double sunsh = this.sunh.getValue();
        double extraterrRadiation = this.actExtRad.getValue();
        double declination = 0.0;
        if (this.tempRes == null) {
            declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
        } else if (this.tempRes.getValue().equals("d")) {
            declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
        } else if (this.tempRes.getValue().equals("m")) {
            declination = SolarRadiationCalculationMethods.calc_SunDeclination(this.monthMean[month]);
        }
        double latRad = MathematicalCalculations.deg2rad(lati);
        double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
        double maximumSunshine = DailySolarRadiationCalculationMethods.calc_maximumSunshineHours(sunsetHourAngle);
        this.sunhmax.setValue(maximumSunshine);
        double solarRadiation = SolarRadiationCalculationMethods.calc_SolarRadiation(sunsh, maximumSunshine, extraterrRadiation, this.angstrom_a.getValue(), this.angstrom_b.getValue());
        this.solRad.setValue(solarRadiation *= SAC);
    }

    public void cleanup() throws IOException {
    }
}

