/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.io;

import jams.data.Attribute;
import jams.data.EntityEnumerator;
import jams.io.GenericDataWriter;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import jams.runtime.RuntimeException;
import jams.tools.JAMSTools;

public class SelectiveEntityWriter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="EntitySet")
    public Attribute.EntityCollection entitySet;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file header descriptions")
    public Attribute.String header;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output file attribute names")
    public Attribute.String attributeName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output entities")
    public Attribute.IntegerArray eIDs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="per area")
    public Attribute.Boolean perArea;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Output data precision")
    public Attribute.Integer precision;
    private GenericDataWriter writer;
    private String[] attrs;
    private boolean headerWritten;

    public void init() {
        this.writer = new GenericDataWriter(JAMSTools.CreateAbsoluteFileName((String)this.getModel().getWorkspaceDirectory().getPath(), (String)this.fileName.getValue()));
        this.writer.addComment("J2K model output" + this.header.getValue());
        this.writer.addComment("");
    }

    public void run() {
        int[] entSet = this.eIDs.getValue();
        int numEntities = entSet.length;
        EntityEnumerator ee = this.entitySet.getEntityEnumerator();
        if (!this.headerWritten) {
            this.writer.addColumn("date/time");
            ee.reset();
            boolean cont = true;
            while (cont) {
                boolean output = false;
                int curID = (int)this.entitySet.getCurrent().getDouble("ID");
                for (int e = 0; e < numEntities; ++e) {
                    if (this.eIDs.getValue()[e] != curID) continue;
                    output = true;
                }
                if (output) {
                    Object ob = this.entitySet.getCurrent().getObject(this.attributeName.getValue());
                    int length = 0;
                    length = ob.getClass().getName().contains("DoubleArray") ? ((Attribute.DoubleArray)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue().length : 0;
                    for (int i = 0; i < length; ++i) {
                        this.writer.addColumn("HRU_" + (int)this.entitySet.getCurrent().getDouble("ID") + "[" + i + "]");
                    }
                    if (length == 0) {
                        this.writer.addColumn("HRU_" + (int)this.entitySet.getCurrent().getDouble("ID"));
                    }
                }
                if (ee.hasNext()) {
                    ee.next();
                    cont = true;
                    continue;
                }
                cont = false;
            }
            this.writer.writeHeader();
            this.headerWritten = true;
        }
        this.writer.addData((Object)this.time);
        ee.reset();
        int setCounter = 0;
        boolean cont = true;
        while (cont) {
            boolean output = false;
            int curID = (int)this.entitySet.getCurrent().getDouble("ID");
            for (int e = 0; e < numEntities; ++e) {
                if (this.eIDs.getValue()[e] != curID) continue;
                output = true;
            }
            if (output) {
                double val;
                Object ob;
                double area = 1.0;
                if (this.perArea.getValue()) {
                    area = ((Attribute.Double)this.entitySet.getCurrent().getObject("area")).getValue();
                }
                if ((ob = this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getClass().getName().contains("DoubleArray")) {
                    double[] da = ((Attribute.DoubleArray)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue();
                    for (int i = 0; i < da.length; ++i) {
                        val = da[i] / area;
                        this.writer.addData(val, this.precision.getValue());
                    }
                } else {
                    double da = ((Attribute.Double)this.entitySet.getCurrent().getObject(this.attributeName.getValue())).getValue();
                    val = da / area;
                    this.writer.addData(val, this.precision.getValue());
                }
                if (setCounter < numEntities - 1) {
                    ++setCounter;
                }
            }
            if (ee.hasNext() && setCounter < numEntities) {
                ee.next();
                cont = true;
                continue;
            }
            cont = false;
        }
        try {
            this.writer.writeData();
        }
        catch (RuntimeException jre) {
            this.getModel().getRuntime().handle((Throwable)jre);
        }
    }

    public void cleanup() {
        this.writer.close();
    }
}

