/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="PrecipCorrection", author="Peter Krause", description="A simple method to increase or decrease precipitation by certain % factor + now precipitation can be corrected by monthssuch as increase in monsoon season only")
public class PrecipCorrectionSimple
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the precip values")
    public Attribute.DoubleArray inputValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Start of the month for correctionMonth, 1+startmont (july=6)", defaultValue="1.0")
    public Attribute.Double startMonth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="End of the month for correctionMonth, 1+startmont (Oct=9)", defaultValue="1.0")
    public Attribute.Double endMonth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="the precip values")
    public Attribute.DoubleArray outputValues;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Correction Factor for specific months", defaultValue="1.0")
    public Attribute.Double correctionMonth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Correction Factor for the whole year", defaultValue="1.0")
    public Attribute.Double correctionYear;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;

    public void run() {
        int nowmonth = this.time.get(2);
        double[] inputValues = this.inputValues.getValue();
        double[] outputValues = new double[inputValues.length];
        for (int i = 0; i < inputValues.length; ++i) {
            outputValues[i] = this.correctionMonth.getValue() == 1.0 ? inputValues[i] * this.correctionYear.getValue() : ((double)nowmonth >= this.startMonth.getValue() && (double)nowmonth <= this.endMonth.getValue() ? inputValues[i] * this.correctionMonth.getValue() : inputValues[i]);
        }
        this.outputValues.setValue(outputValues);
    }
}

