/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="LanduseSceno_generator", author="Manfred Fink", description="allows the redistributon of land use ID according to a proportion variable", version="1.0_0", date="2017-03-16")
public class LanduseSceno_generator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of hru objects")
    public Attribute.EntityCollection hrus;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current spatial entity")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Proportion of settlement (rual) between 0 and 100%", defaultValue="1.5", lowerBound=0.0, upperBound=100.0)
    public Attribute.Double class1prop;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Proportion of arable land between 0 and 100%", defaultValue="63", lowerBound=0.0, upperBound=100.0)
    public Attribute.Double class2prop;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Proportion of grass land between 0 and 100%", defaultValue="12", lowerBound=0.0, upperBound=100.0)
    public Attribute.Double class3prop;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Proportion of deciduos forrest between 0 and 100%", defaultValue="5", lowerBound=0.0, upperBound=100.0)
    public Attribute.Double class4prop;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Proportion of coinferous forrest between 0 and 100%", defaultValue="18", lowerBound=0.0, upperBound=100.0)
    public Attribute.Double class5prop;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Proportion of settlement (urban) between 0 and 100%", defaultValue="0.5", lowerBound=0.0, upperBound=100.0)
    public Attribute.Double class6prop;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="List of Landuse IDs (ordered)", defaultValue="1,3,9,5,6,2")
    public Attribute.IntegerArray Land_use_IDs;
    int[] IDs = new int[]{1, 3, 9, 5, 6, 2};
    double[] default_LUIDvals = new double[]{0.0, 0.0156, 0.658, 0.7644, 0.814, 0.995, 1.0};

    public void init() {
        double class1prop = this.class1prop.getValue();
        double class2prop = this.class2prop.getValue();
        double class3prop = this.class3prop.getValue();
        double class4prop = this.class4prop.getValue();
        double class5prop = this.class5prop.getValue();
        double class6prop = this.class6prop.getValue();
        double[] props_percent = new double[]{class1prop, class2prop, class3prop, class4prop, class5prop, class6prop};
        double sumprop = class1prop + class2prop + class3prop + class4prop + class5prop + class6prop;
        double tempprop = 0.0;
        for (int j = 0; j <= props_percent.length; ++j) {
            this.default_LUIDvals[j] = j == 0 ? 0.0 : (j < props_percent.length ? (tempprop += props_percent[j - 1]) / sumprop : 1.0);
        }
        this.IDs = this.Land_use_IDs.getValue();
        int count = this.IDs.length;
        for (Attribute.Entity e : this.hrus.getEntities()) {
            double newlandID = 0.0;
            double proportion = e.getDouble("proportion");
            for (int i = 0; i < count; ++i) {
                if (!(proportion > this.default_LUIDvals[i]) || !(proportion <= this.default_LUIDvals[i + 1])) continue;
                newlandID = this.IDs[i];
            }
            e.setDouble("landuseID", newlandID);
        }
    }

    public void run() {
    }

    public void cleanup() {
    }
}

