/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InErrorContext", author="Peter Krause", description="Context component which helps in estimating the performanceThe component lets the model run for a specified number of times.")
public class MultiRunPerformance
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number of model evaluations")
    public Attribute.Integer modelRuns;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Flag for dis/enabling this sampler")
    public Attribute.Boolean enable;
    int currentCount;
    int runCounter = 0;

    public void init() {
    }

    public void run() {
        if (this.runEnumerator == null) {
            this.runEnumerator = this.getChildrenEnumerator();
        }
        if (!this.enable.getValue()) {
            this.singleRun();
        } else {
            while (this.hasNext()) {
                this.singleRun();
                ++this.runCounter;
                System.out.println("run: " + this.runCounter);
            }
            this.runEnumerator.reset();
            while (this.runEnumerator.hasNext() && this.doRun) {
                Component component = this.runEnumerator.next();
            }
        }
    }

    public void cleanup() {
    }

    private void singleRun() {
        Component comp;
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            ++this.currentCount;
            try {
                comp.init();
            }
            catch (Exception exception) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.initAll();
            }
            catch (Exception exception) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.run();
            }
            catch (Exception exception) {}
        }
        this.runEnumerator.reset();
        while (this.runEnumerator.hasNext() && this.doRun) {
            comp = this.runEnumerator.next();
            try {
                comp.cleanup();
            }
            catch (Exception exception) {}
        }
    }

    private boolean hasNext() {
        return this.currentCount < this.modelRuns.getValue();
    }
}

