/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui.tree;

import jams.JAMS;
import jams.JAMSException;
import jams.gui.tools.GUIHelper;
import jams.meta.ComponentCollection;
import jams.meta.ComponentDescriptor;
import jams.meta.ModelDescriptor;
import jams.meta.ModelIO;
import jams.meta.ModelNode;
import jams.meta.NodeFactory;
import jamsui.juice.JUICE;
import jamsui.juice.gui.ComponentInfoDlg;
import jamsui.juice.gui.ModelView;
import jamsui.juice.gui.tree.DefaultTreeTransferHandler;
import jamsui.juice.gui.tree.JAMSNode;
import jamsui.juice.gui.tree.JAMSTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;

public class ModelTree
extends JAMSTree {
    private ModelView view;
    private JPopupMenu popup;
    private boolean smartExpand = true;
    private ModelIO modelIO;

    public ModelTree(ModelView view, Document modelDoc) {
        super((ComponentCollection)view.getModelDescriptor());
        this.setEditable(true);
        new DefaultTreeTransferHandler(this, 3);
        this.getSelectionModel().setSelectionMode(4);
        this.view = view;
        this.modelIO = new ModelIO(new NodeFactory(){

            public ModelNode createNode(ComponentDescriptor cd) {
                JAMSNode node = new JAMSNode(cd, ModelTree.this);
                return node;
            }
        });
        this.updateModelTree(modelDoc);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ModelTree.this.displayComponentInfo();
            }
        });
        JMenuItem toggleEnabledItem = new JMenuItem(JAMS.i18n((String)"Toggle_enable"));
        toggleEnabledItem.setAccelerator(KeyStroke.getKeyStroke('E'));
        toggleEnabledItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelTree.this.toggleEnable();
            }
        });
        JMenuItem showMetadataItem = new JMenuItem(JAMS.i18n((String)"Show_Metadata..."));
        showMetadataItem.setAccelerator(KeyStroke.getKeyStroke('M'));
        showMetadataItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelTree.this.showMetaData();
            }
        });
        JMenuItem deleteItem = new JMenuItem(JAMS.i18n((String)"Delete"));
        deleteItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelTree.this.deleteNode();
            }
        });
        JMenuItem moveUpItem = new JMenuItem(JAMS.i18n((String)"Move_up"));
        moveUpItem.setAccelerator(KeyStroke.getKeyStroke('-'));
        moveUpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelTree.this.moveUpNode();
            }
        });
        JMenuItem moveDownItem = new JMenuItem(JAMS.i18n((String)"Move_down"));
        moveDownItem.setAccelerator(KeyStroke.getKeyStroke('+'));
        moveDownItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModelTree.this.moveDownNode();
            }
        });
        this.popup = new JPopupMenu();
        this.popup.add(toggleEnabledItem);
        this.popup.add(showMetadataItem);
        this.popup.add(deleteItem);
        this.popup.add(moveUpItem);
        this.popup.add(moveDownItem);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    if (!evt.isControlDown() && !evt.isShiftDown()) {
                        ModelTree.this.setSelectionPath(null);
                    }
                    ModelTree.this.showPopup(evt);
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case '\u007f': {
                        ModelTree.this.deleteNode();
                        break;
                    }
                    case '-': {
                        ModelTree.this.moveUpNode();
                        break;
                    }
                    case '+': {
                        ModelTree.this.moveDownNode();
                        break;
                    }
                    case 'E': {
                        ModelTree.this.toggleEnable();
                    }
                }
            }
        });
    }

    private void deleteNode() {
        if (this.getSelectionPaths() == null) {
            return;
        }
        for (TreePath path : this.getSelectionPaths()) {
            JAMSNode node = (JAMSNode)((Object)path.getLastPathComponent());
            int result = GUIHelper.showYesNoDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"Really_delete_component_") + node.getUserObject().toString() + JAMS.i18n((String)"Really_delete_component_2")), (String)JAMS.i18n((String)"Deleting_component"));
            if (result != 0) continue;
            ComponentDescriptor cd = (ComponentDescriptor)node.getUserObject();
            node.remove();
            this.updateUI();
        }
        this.setSelectionPath(null);
    }

    private void toggleEnable() {
        if (this.getSelectionPaths() == null) {
            return;
        }
        for (TreePath path : this.getSelectionPaths()) {
            ComponentDescriptor cd;
            JAMSNode node = (JAMSNode)((Object)path.getLastPathComponent());
            cd.setEnabled(!(cd = (ComponentDescriptor)node.getUserObject()).isEnabled());
            this.updateUI();
        }
    }

    private void showMetaData() {
        if (this.getSelectionPaths() == null) {
            return;
        }
        for (TreePath path : this.getSelectionPaths()) {
            JAMSNode node = (JAMSNode)((Object)path.getLastPathComponent());
            ComponentDescriptor cd = (ComponentDescriptor)node.getUserObject();
            ComponentInfoDlg.displayMetadataDlg((JFrame)this.getTopLevelAncestor(), cd.getClazz());
        }
    }

    private void moveUpNode() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return;
        }
        int[] index = new int[paths.length];
        int i = 0;
        for (TreePath path : paths) {
            JAMSNode node = (JAMSNode)((Object)path.getLastPathComponent());
            JAMSNode parent = (JAMSNode)((Object)node.getParent());
            index[i] = parent.getIndex((TreeNode)((Object)node));
            ++i;
        }
        i = index.length - 1;
        for (int k = paths.length - 1; k >= 0; --k) {
            JAMSNode node = (JAMSNode)((Object)paths[k].getLastPathComponent());
            JAMSNode parent = (JAMSNode)((Object)node.getParent());
            int n = i;
            index[n] = index[n] - 1;
            for (int j = i - 1; j >= 0 && index[j] == index[i]; --j) {
                int n2 = i;
                index[n2] = index[n2] - 1;
            }
            if (index[i] >= 0) {
                parent.insert((MutableTreeNode)((Object)node), index[i]);
            }
            --i;
        }
        this.updateUI();
    }

    private void moveDownNode() {
        JAMSNode parent;
        JAMSNode node;
        TreePath[] paths = this.getSelectionPaths();
        int[] index = new int[paths.length];
        int i = 0;
        for (TreePath path : paths) {
            node = (JAMSNode)((Object)path.getLastPathComponent());
            parent = (JAMSNode)((Object)node.getParent());
            if (parent != null) {
                index[i] = parent.getIndex((TreeNode)((Object)node));
            }
            ++i;
        }
        i = -1;
        for (TreePath path : paths) {
            ++i;
            node = (JAMSNode)((Object)path.getLastPathComponent());
            parent = (JAMSNode)((Object)node.getParent());
            if (parent == null) continue;
            int n = i;
            index[n] = index[n] + 1;
            for (int j = i + 1; j < index.length && index[j] == index[i]; ++j) {
                int n2 = i;
                index[n2] = index[n2] + 1;
            }
            if (index[i] >= parent.getChildCount()) continue;
            parent.insert((MutableTreeNode)((Object)node), index[i]);
        }
        this.updateUI();
    }

    private void showPopup(MouseEvent evt) {
        TreePath p = this.getClosestPathForLocation(evt.getX(), evt.getY());
        this.addSelectionPath(p);
        JAMSNode node = (JAMSNode)((Object)this.getLastSelectedPathComponent());
        if (node.getType() == 2) {
            // empty if block
        }
        if (node != null) {
            try {
                Class clazz = ((ComponentDescriptor)node.getUserObject()).getClazz();
                if (clazz != null) {
                    this.popup.show(this, evt.getX(), evt.getY());
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void displayComponentInfo() {
        JAMSNode node = (JAMSNode)((Object)this.getLastSelectedPathComponent());
        if (node != null) {
            this.view.getCompEditPanel().setComponentDescriptor((ComponentDescriptor)node.getUserObject());
        }
    }

    public final void updateModelTree(Document modelDoc) {
        ModelDescriptor md;
        ModelNode rootNode = null;
        if (modelDoc == null) {
            try {
                md = this.modelIO.createModel();
                this.view.setModelDescriptor(md);
                this.setComponentCollection((ComponentCollection)md);
                rootNode = md.getRootNode();
            }
            catch (JAMSException ex) {
                GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)ex.getMessage(), (String)ex.getHeader());
            }
        } else {
            try {
                md = this.modelIO.loadModelDescriptor(modelDoc, JUICE.getLoader(), true);
                this.view.setModelDescriptor(md);
                this.setComponentCollection((ComponentCollection)md);
                rootNode = md.getRootNode();
            }
            catch (JAMSException ex) {
                GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)ex.getMessage(), (String)ex.getHeader());
            }
        }
        this.view.getModelEditPanel().updatePanel();
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)rootNode);
        this.setModel(model);
        this.setSelectionRow(0);
        this.displayComponentInfo();
        this.expandAll();
        this.smartExpand = false;
    }

    public Document getModelDocument(ModelDescriptor md) {
        return this.modelIO.getModelDocument(md);
    }

    public ModelView getView() {
        return this.view;
    }

    @Override
    protected void setExpandedState(TreePath path, boolean state) {
        ComponentDescriptor cd;
        JAMSNode node;
        if (this.smartExpand && (node = (JAMSNode)((Object)path.getLastPathComponent())).getType() == 1 && (cd = (ComponentDescriptor)node.getUserObject()).getClazz().getName().equals("jams.components.core.Context")) {
            return;
        }
        super.setExpandedState(path, state);
    }

    class ModelLoadException
    extends Exception {
        private String className;
        private String componentName;

        public ModelLoadException(String className, String componentName) {
            this.className = className;
            this.componentName = componentName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getComponentName() {
            return this.componentName;
        }
    }
}

