/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui.tree;

import jams.JAMSException;
import jams.JAMSLogging;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextDescriptor;
import jams.model.JAMSContext;
import jamsui.juice.JUICE;
import jamsui.juice.gui.ContextReplaceDlg;
import jamsui.juice.gui.tree.AbstractTreeTransferHandler;
import jamsui.juice.gui.tree.JAMSNode;
import jamsui.juice.gui.tree.JAMSTree;
import jamsui.juice.gui.tree.ModelTree;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultTreeTransferHandler
extends AbstractTreeTransferHandler {
    private ContextReplaceDlg dlg = new ContextReplaceDlg(JUICE.getJuiceFrame());

    public DefaultTreeTransferHandler(JAMSTree tree, int action) {
        super(tree, action, true);
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.CollectAndShow, (Logger)Logger.getLogger(this.getClass().getName()));
    }

    @Override
    public boolean canPerformAction(JAMSTree target, JAMSNode draggedNode, int action, Point location) {
        JAMSNode targetRoot = (JAMSNode)((Object)target.getModel().getRoot());
        if (targetRoot.getType() == 3) {
            return false;
        }
        if (draggedNode.getType() == 4 || draggedNode.getType() == 3 || draggedNode.getType() == 5) {
            return false;
        }
        TreePath pathTarget = target.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            target.setSelectionPath(null);
            return false;
        }
        if (((JAMSNode)((Object)pathTarget.getLastPathComponent())).getType() == 0) {
            // empty if block
        }
        if (action == 1) {
            target.setSelectionPath(pathTarget);
            return true;
        }
        if (action == 2) {
            JAMSNode parentNode = (JAMSNode)((Object)pathTarget.getLastPathComponent());
            if (draggedNode.isRoot() || parentNode == draggedNode.getParent() || draggedNode.isNodeDescendant((DefaultMutableTreeNode)((Object)parentNode))) {
                target.setSelectionPath(null);
                return false;
            }
            target.setSelectionPath(pathTarget);
            return true;
        }
        target.setSelectionPath(null);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean executeDrop(JAMSTree target, JAMSNode draggedNode, JAMSNode newParentNode, Vector expandedStates, int action) {
        int position = 0;
        if (newParentNode.getType() == 0) {
            JAMSNode siblingNode = newParentNode;
            newParentNode = (JAMSNode)((Object)newParentNode.getParent());
            position = newParentNode.getIndex((TreeNode)((Object)siblingNode));
            if (draggedNode.getParent().getIndex((TreeNode)((Object)draggedNode)) > position) {
                ++position;
            }
            if (draggedNode.getParent() == newParentNode) {
                // empty if block
            }
        } else {
            position = newParentNode.getChildCount();
        }
        if (action == 1) {
            JAMSNode newNode = (JAMSNode)((Object)JAMSTree.makeDeepCopy(draggedNode, target));
            newNode.setType(draggedNode.getType());
            if (target instanceof ModelTree && !this.fixPendingContexts(newNode, newParentNode)) {
                return false;
            }
            target.expandPath(new TreePath(newParentNode.getPath()));
            ((DefaultTreeModel)target.getModel()).insertNodeInto((MutableTreeNode)((Object)newNode), (MutableTreeNode)((Object)newParentNode), position);
            TreePath treePath = new TreePath(newNode.getPath());
            int i = 0;
            Enumeration enumeration = newNode.depthFirstEnumeration();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    target.scrollPathToVisible(treePath);
                    target.setSelectionPath(treePath);
                    return true;
                }
                JAMSNode element = (JAMSNode)((Object)enumeration.nextElement());
                TreePath path = new TreePath(element.getPath());
                if (((Boolean)expandedStates.get(i)).booleanValue()) {
                    target.expandPath(path);
                }
                ++i;
            }
        }
        if (action != 2) {
            return false;
        }
        if (target instanceof ModelTree && !this.fixPendingContexts(draggedNode, newParentNode)) {
            return false;
        }
        target.saveExpandedState(new TreePath(target.getModel().getRoot()));
        draggedNode.removeFromParent();
        target.expandPath(new TreePath(newParentNode.getPath()));
        ((DefaultTreeModel)target.getModel()).insertNodeInto((MutableTreeNode)((Object)draggedNode), (MutableTreeNode)((Object)newParentNode), position);
        TreePath treePath = new TreePath(draggedNode.getPath());
        int i = 0;
        Enumeration enumeration = draggedNode.depthFirstEnumeration();
        while (true) {
            if (!enumeration.hasMoreElements()) {
                target.scrollPathToVisible(treePath);
                target.setSelectionPath(treePath);
                TreePath newtreePath = new TreePath(draggedNode.getPath());
                target.scrollPathToVisible(newtreePath);
                target.setSelectionPath(newtreePath);
                return true;
            }
            JAMSNode element = (JAMSNode)((Object)enumeration.nextElement());
            TreePath path = new TreePath(element.getPath());
            if (((Boolean)expandedStates.get(i)).booleanValue()) {
                target.expandPath(path);
            }
            ++i;
        }
    }

    private boolean fixPendingContexts(JAMSNode rootNode, JAMSNode parentNode) {
        ComponentDescriptor cd;
        HashSet<String> contexts = new HashSet<String>();
        HashMap<String, HashSet<ComponentDescriptor>> pendingContexts = new HashMap<String, HashSet<ComponentDescriptor>>();
        Enumeration nodeEnum = rootNode.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            JAMSNode node = (JAMSNode)((Object)nodeEnum.nextElement());
            cd = (ComponentDescriptor)node.getUserObject();
            if (JAMSContext.class.isAssignableFrom(cd.getClazz())) {
                contexts.add(cd.getInstanceName());
            }
            HashSet<String> ancestors = new HashSet<String>();
            ancestors.add(parentNode.getUserObject().toString());
            for (JAMSNode ancestor = (JAMSNode)((Object)parentNode.getParent()); ancestor != null; ancestor = (JAMSNode)((Object)ancestor.getParent())) {
                ancestors.add(ancestor.getUserObject().toString());
            }
            for (ComponentField var : cd.getComponentFields().values()) {
                String contextName;
                if (var.getContext() == null || ancestors.contains(contextName = var.getContext().getInstanceName()) || contexts.contains(contextName)) continue;
                HashSet<ComponentDescriptor> components = (HashSet<ComponentDescriptor>)pendingContexts.get(contextName);
                if (components == null) {
                    components = new HashSet<ComponentDescriptor>();
                    pendingContexts.put(contextName, components);
                }
                components.add(cd);
            }
        }
        Vector<String> ancestorNames = new Vector<String>();
        HashMap<String, ComponentDescriptor> ancestors = new HashMap<String, ComponentDescriptor>();
        cd = (ComponentDescriptor)parentNode.getUserObject();
        ancestorNames.add(cd.toString());
        ancestors.put(cd.toString(), cd);
        for (JAMSNode ancestor = (JAMSNode)((Object)parentNode.getParent()); ancestor != null; ancestor = (JAMSNode)((Object)ancestor.getParent())) {
            cd = (ComponentDescriptor)ancestor.getUserObject();
            ancestorNames.add(cd.toString());
            ancestors.put(cd.toString(), cd);
        }
        cd = (ComponentDescriptor)rootNode.getUserObject();
        ancestorNames.add(cd.toString());
        ancestors.put(cd.toString(), cd);
        String[] ancestorNameArray = ancestorNames.toArray(new String[ancestorNames.size()]);
        ArrayList pendingContextList = new ArrayList(pendingContexts.keySet());
        Collections.sort(pendingContextList);
        for (String oldContextName : pendingContextList) {
            HashSet components;
            if (this.dlg.show(oldContextName, ancestorNameArray, components = (HashSet)pendingContexts.get(oldContextName)) == 0) {
                return false;
            }
            ContextDescriptor newContext = (ContextDescriptor)ancestors.get(this.dlg.getContext());
            for (ComponentDescriptor component : components) {
                for (ComponentField var : component.getComponentFields().values()) {
                    if (var.getContext() == null || !var.getContext().getInstanceName().equals(oldContextName)) continue;
                    try {
                        var.linkToAttribute(newContext, var.getAttribute());
                    }
                    catch (JAMSException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return true;
    }
}

