/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.gui.input.ListInput;
import jams.gui.input.TableInput;
import jams.gui.tools.GUIHelper;
import jams.meta.ComponentDescriptor;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.ModelDescriptor;
import jams.meta.OutputDSDescriptor;
import jams.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class OutputDSDlg
extends JDialog {
    static final int BUTTON_SIZE = 20;
    private static ImageIcon UP_ICON = new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/arrowup.png")).getImage().getScaledInstance(10, 5, 4));
    private static ImageIcon DOWN_ICON = new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/arrowdown.png")).getImage().getScaledInstance(10, 5, 4));
    private static final Dimension BUTTON_DIMENSION = new Dimension(20, 20);
    private JButton okButton;
    private ModelDescriptor md;
    private DSTableInput dslist;
    private FilterListInput filterList;
    private AttributeListInput attributeList;

    public OutputDSDlg(Frame owner, ModelDescriptor md) {
        super(owner);
        this.setTitle(JAMS.i18n((String)"Datastore_editor"));
        this.setLocationRelativeTo(owner);
        this.setModal(false);
        this.setResizable(false);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Datastore_details")));
        GridBagLayout mainLayout = new GridBagLayout();
        contentPanel.setLayout(mainLayout);
        JPanel storesPanel = new JPanel();
        storesPanel.setBorder(BorderFactory.createTitledBorder(JAMS.i18n((String)"Datastores")));
        this.getContentPane().add((Component)storesPanel, "West");
        this.dslist = new DSTableInput();
        this.dslist.setPreferredSize(new Dimension(200, 200));
        storesPanel.add((Component)((Object)this.dslist));
        this.dslist.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OutputDSDlg.this.updateContextAttributes(OutputDSDlg.this.dslist);
                }
            }
        });
        this.filterList = new FilterListInput();
        this.filterList.setPreferredSize(new Dimension(200, 100));
        this.filterList.setEnabled(false);
        this.attributeList = new AttributeListInput();
        this.attributeList.setPreferredSize(new Dimension(200, 300));
        this.attributeList.setEnabled(false);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)new JLabel(JAMS.i18n((String)"Attributes")), (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)((Object)this.attributeList), (int)1, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)new JLabel(JAMS.i18n((String)"Filters")), (int)1, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)((Object)this.filterList), (int)1, (int)30, (int)1, (int)1, (double)0.0, (double)0.0);
        this.okButton = new JButton(JAMS.i18n((String)"OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputDSDlg.this.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.md = md;
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        this.dslist.setValue(this.md);
        super.setVisible(b);
    }

    private void updateContextAttributes(DSTableInput value) {
        int selection = value.getTable().getSelectedRow();
        if (selection == -1) {
            return;
        }
        OutputDSDescriptor ods = (OutputDSDescriptor)((Object[])value.getTableData().get(selection))[1];
        if (ods != null) {
            this.filterList.setValue(ods);
            this.attributeList.setValue(ods);
            this.filterList.setEnabled(true);
            this.attributeList.setEnabled(true);
        } else {
            this.filterList.setValue(null);
            this.attributeList.setValue(null);
            this.filterList.setEnabled(false);
            this.attributeList.setEnabled(false);
        }
    }

    class DSDlg
    extends JDialog {
        private JTextField nameText;
        private JList objectList;
        public static final int RESULT_OK = 1;
        public static final int RESULT_CANCEL = 0;
        private int result;
        private JCheckBox enableBox;

        public DSDlg(Dialog owner, String title, boolean showTextField, boolean showEnabledBox) {
            this(owner, title, showTextField, showEnabledBox, true);
        }

        public DSDlg(Dialog owner, String title, boolean showTextField, boolean showEnabledBox, boolean showList) {
            String listLabel;
            super(owner);
            this.objectList = new JList();
            this.result = 0;
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            this.setTitle(title);
            this.setResizable(false);
            this.setDefaultCloseOperation(1);
            this.setLayout(new BorderLayout());
            JPanel contentPanel = new JPanel();
            this.getContentPane().add((Component)contentPanel, "Center");
            GridBagLayout mainLayout = new GridBagLayout();
            contentPanel.setLayout(mainLayout);
            this.enableBox = new JCheckBox(JAMS.i18n((String)"Enabled"));
            if (showEnabledBox) {
                GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.enableBox, (int)1, (int)40, (int)1, (int)1, (double)0.0, (double)0.0);
            }
            this.enableBox.setSelected(true);
            this.nameText = new JTextField();
            this.nameText.setPreferredSize(new Dimension(200, 20));
            if (showTextField) {
                GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)new JLabel(JAMS.i18n((String)"Name")), (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
                GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)this.nameText, (int)1, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
                this.objectList.setSelectionMode(0);
                listLabel = JAMS.i18n((String)"Context");
            } else {
                this.objectList.setSelectionMode(2);
                listLabel = JAMS.i18n((String)"Attribute");
            }
            if (showList) {
                JScrollPane listScroll = new JScrollPane(this.objectList);
                if (showTextField) {
                    listScroll.setPreferredSize(new Dimension(200, 200));
                } else {
                    listScroll.setPreferredSize(new Dimension(200, 400));
                }
                GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)new JLabel(listLabel), (int)1, (int)20, (int)1, (int)1, (double)0.0, (double)0.0);
                GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)mainLayout, (Component)listScroll, (int)1, (int)30, (int)1, (int)1, (double)0.0, (double)0.0);
            }
            JButton okButton = new JButton(JAMS.i18n((String)"OK"));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DSDlg.this.result = 1;
                    DSDlg.this.setVisible(false);
                }
            });
            JButton cancelButton = new JButton(JAMS.i18n((String)"Cancel"));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DSDlg.this.result = 0;
                    DSDlg.this.setVisible(false);
                }
            });
            this.objectList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Object o;
                    if (!e.getValueIsAdjusting() && (o = DSDlg.this.objectList.getSelectedValue()) != null) {
                        DSDlg.this.nameText.setText(o.toString());
                    }
                }
            });
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(okButton);
            buttonPanel.add(cancelButton);
            this.getContentPane().add((Component)buttonPanel, "South");
            this.pack();
        }

        public void update(OutputDSDescriptor ods) {
            this.nameText.setText(ods.getName());
            this.nameText.requestFocus();
            this.enableBox.setSelected(ods.isEnabled());
        }

        public void update(ArrayList<Object> values) {
            this.nameText.setText("");
            this.nameText.requestFocus();
            this.enableBox.setSelected(false);
            Collections.sort(values, new Comparator<Object>(){

                @Override
                public int compare(Object a1, Object a2) {
                    return a1.toString().compareTo(a2.toString());
                }
            });
            this.objectList.setModel(new DefaultComboBoxModel<Object>(values.toArray(new Object[values.size()])));
            this.pack();
        }

        public int getResult() {
            return this.result;
        }

        public String getDsName() {
            return this.nameText.getText();
        }

        public boolean isDsEnabled() {
            return this.enableBox.isSelected();
        }

        public Object[] getValue() {
            return this.objectList.getSelectedValues();
        }
    }

    class DSTableInput
    extends TableInput {
        private ModelDescriptor md;
        private DSDlg newDSDlg;
        private DSDlg editDSDlg;

        public DSTableInput() {
            super(new String[]{JAMS.i18n((String)"Enabled"), "Store [Context]"}, new Class[]{Boolean.class, String.class}, new boolean[]{true, false}, false);
            this.getTable().setAutoResizeMode(3);
            int vColIndex = 0;
            TableColumn col = this.getTable().getColumnModel().getColumn(vColIndex);
            int width = 20;
            col.setPreferredWidth(width);
            ((AbstractTableModel)this.getTable().getModel()).addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    for (Object[] row : DSTableInput.this.tableData.getValue()) {
                        if (!(row[0] instanceof Boolean)) continue;
                        if (((Boolean)row[0]).booleanValue()) {
                            ((OutputDSDescriptor)row[1]).setEnabled(true);
                            continue;
                        }
                        ((OutputDSDescriptor)row[1]).setEnabled(false);
                    }
                }
            });
        }

        public void setValue(ModelDescriptor md) {
            this.md = md;
            HashMap stores = md.getDatastores();
            ArrayList<OutputDSDescriptor> storesList = new ArrayList<OutputDSDescriptor>();
            for (OutputDSDescriptor store : stores.values()) {
                storesList.add(store);
            }
            Collections.sort(storesList, new Comparator<OutputDSDescriptor>(){

                @Override
                public int compare(OutputDSDescriptor a1, OutputDSDescriptor a2) {
                    return a1.getName().compareTo(a2.getName());
                }
            });
            ArrayList<Object[]> storesVector = new ArrayList<Object[]>();
            for (OutputDSDescriptor ods : storesList) {
                Object[] row = new Object[]{ods.isEnabled(), ods};
                storesVector.add(row);
            }
            this.setTableData(storesVector);
        }

        protected void addItem() {
            if (this.newDSDlg == null) {
                this.newDSDlg = new DSDlg(OutputDSDlg.this, JAMS.i18n((String)"Add_datastore"), true, true);
            }
            HashMap cdMap = this.md.getComponentDescriptors();
            ArrayList<Object> contextList = new ArrayList<Object>();
            for (ComponentDescriptor cd : cdMap.values()) {
                if (!(cd instanceof ContextDescriptor)) continue;
                contextList.add(cd);
            }
            this.newDSDlg.update(contextList);
            this.newDSDlg.setVisible(true);
            if (this.newDSDlg.getResult() == 1) {
                if (StringTools.isEmptyString((String)this.newDSDlg.getDsName())) {
                    GUIHelper.showErrorDlg((Component)((Object)this), (String)JAMS.i18n((String)"Datastore_name_must_not_be_empty!"), (String)JAMS.i18n((String)"Error_creating_new_datastore"));
                    this.addItem();
                    return;
                }
                if (this.newDSDlg.getValue().length < 1) {
                    GUIHelper.showErrorDlg((Component)((Object)this), (String)JAMS.i18n((String)"You_must_choose_a_context!"), (String)JAMS.i18n((String)"Error_creating_new_datastore"));
                    this.addItem();
                    return;
                }
                ContextDescriptor context = (ContextDescriptor)this.newDSDlg.getValue()[0];
                OutputDSDescriptor ods = new OutputDSDescriptor(context);
                ods.setName(this.newDSDlg.getDsName());
                ods.setEnabled(this.newDSDlg.isDsEnabled());
                this.md.addOutputDataStore(ods);
                this.setValue(this.md);
            }
        }

        protected void editItem() {
            int selection = this.getTable().getSelectedRow();
            if (selection < 0) {
                return;
            }
            OutputDSDescriptor ods = (OutputDSDescriptor)this.tableData.getElementAt(selection)[1];
            if (this.editDSDlg == null) {
                this.editDSDlg = new DSDlg(OutputDSDlg.this, JAMS.i18n((String)"Edit_datastore"), true, true, false);
            }
            this.editDSDlg.update(ods);
            this.editDSDlg.setVisible(true);
            if (this.editDSDlg.getResult() == 1) {
                if (StringTools.isEmptyString((String)this.editDSDlg.getDsName())) {
                    GUIHelper.showErrorDlg((Component)((Object)this), (String)JAMS.i18n((String)"Datastore_name_must_not_be_empty!"), (String)JAMS.i18n((String)"Error_creating_new_datastore"));
                    this.editItem();
                    return;
                }
                ods.setName(this.editDSDlg.getDsName());
                ods.setEnabled(this.editDSDlg.isDsEnabled());
                this.scrollPane.revalidate();
                this.scrollPane.repaint();
            }
            this.setValue(this.md);
        }

        protected void removeItem() {
            int selection = this.getTable().getSelectedRow();
            if (selection < 0) {
                return;
            }
            OutputDSDescriptor value = (OutputDSDescriptor)((Object[])this.tableData.getValue().get(selection))[1];
            if (value != null) {
                this.md.removeOutputDataStore(value);
                this.setValue(this.md);
                if (selection >= this.tableData.getValue().size()) {
                    selection = this.tableData.getValue().size() - 1;
                    this.getTable().setRowSelectionInterval(selection, selection);
                }
            }
        }
    }

    class AttributeListInput
    extends ListInput {
        private OutputDSDescriptor ods;
        private DSDlg newDSDlg;

        public AttributeListInput() {
            super(true, false);
            this.getListbox().removeMouseListener(this.editListener);
            this.getListbox().setSelectionMode(2);
        }

        public void setValue(OutputDSDescriptor ods) {
            this.ods = ods;
            Vector<ContextAttribute> aVector = new Vector<ContextAttribute>();
            if (ods == null) {
                this.setListData(aVector);
                return;
            }
            for (ContextAttribute ca : ods.getContextAttributes()) {
                aVector.add(ca);
            }
            this.setListData(aVector);
        }

        protected void addItem() {
            if (this.newDSDlg == null) {
                this.newDSDlg = new DSDlg(OutputDSDlg.this, JAMS.i18n((String)"Add_attributes"), false, false);
            }
            HashMap caMap = this.ods.getContext().getDynamicAttributes();
            ArrayList<Object> caList = new ArrayList<Object>();
            Vector ld = this.getListData();
            for (ContextAttribute ca : caMap.values()) {
                if (ld.contains(ca)) continue;
                caList.add(ca);
            }
            this.newDSDlg.update(caList);
            this.newDSDlg.setVisible(true);
            if (this.newDSDlg.getResult() == 1) {
                Object[] attributes;
                for (Object attribute : attributes = this.newDSDlg.getValue()) {
                    ContextAttribute ca = (ContextAttribute)attribute;
                    if (ca == null) {
                        GUIHelper.showErrorDlg((Component)((Object)this), (String)JAMS.i18n((String)"Could_not_add_attribute"), (String)JAMS.i18n((String)"ERROR"));
                        return;
                    }
                    if (this.ods.getContextAttributes().contains(ca)) continue;
                    this.ods.getContextAttributes().add(ca);
                }
                this.setValue(this.ods);
            }
        }

        protected void removeItem() {
            int selection = this.getListbox().getSelectedIndex();
            Object[] values = this.getListbox().getSelectedValues();
            if (values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    this.ods.getContextAttributes().remove((ContextAttribute)values[i]);
                }
                this.setValue(this.ods);
                if (selection >= this.listData.getValue().size()) {
                    selection = this.listData.getValue().size() - 1;
                }
                this.getListbox().setSelectedIndex(selection);
            }
        }

        protected void moveUp() {
            int[] indices = this.getListbox().getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                int index = indices[i];
                if (index <= 0) continue;
                ArrayList al = this.ods.getContextAttributes();
                ContextAttribute tmp = (ContextAttribute)al.get(index - 1);
                al.set(index - 1, al.get(index));
                al.set(index, tmp);
                int n = i;
                indices[n] = indices[n] - 1;
            }
            this.setValue(this.ods);
            this.getListbox().setSelectedIndices(indices);
        }

        protected void moveDown() {
            int[] indices = this.getListbox().getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                int index = indices[i];
                if (index >= this.listData.getValue().size() - 1) continue;
                ArrayList al = this.ods.getContextAttributes();
                ContextAttribute tmp = (ContextAttribute)al.get(index + 1);
                al.set(index + 1, al.get(index));
                al.set(index, tmp);
                int n = i;
                indices[n] = indices[n] + 1;
            }
            this.setValue(this.ods);
            this.getListbox().setSelectedIndices(indices);
        }
    }

    class FilterListInput
    extends ListInput {
        private OutputDSDescriptor ods;
        private DSDlg newDSDlg;

        public FilterListInput() {
            super(false, true, "FilterDialog");
        }

        public void setValue(OutputDSDescriptor ods) {
            this.ods = ods;
            Vector<OutputDSDescriptor.FilterDescriptor> fVector = new Vector<OutputDSDescriptor.FilterDescriptor>();
            if (ods == null) {
                this.setListData(fVector);
                return;
            }
            for (OutputDSDescriptor.FilterDescriptor f : ods.getFilters()) {
                fVector.add(f);
            }
            this.setListData(fVector);
        }

        protected void addItem() {
            if (this.newDSDlg == null) {
                this.newDSDlg = new DSDlg(OutputDSDlg.this, JAMS.i18n((String)"Add_filter"), true, false);
            }
            HashMap cdMap = OutputDSDlg.this.md.getComponentDescriptors();
            ArrayList<Object> contextList = new ArrayList<Object>();
            for (ComponentDescriptor cd : cdMap.values()) {
                if (!(cd instanceof ContextDescriptor)) continue;
                contextList.add(cd);
            }
            this.newDSDlg.update(contextList);
            this.newDSDlg.setVisible(true);
            if (this.newDSDlg.getResult() == 1) {
                if (StringTools.isEmptyString((String)this.newDSDlg.getDsName())) {
                    GUIHelper.showErrorDlg((Component)((Object)this), (String)JAMS.i18n((String)"Filter_expression_must_not_be_empty!"), (String)JAMS.i18n((String)"Error_creating_new_filter"));
                    this.addItem();
                    return;
                }
                if (this.newDSDlg.getValue().length < 1) {
                    GUIHelper.showErrorDlg((Component)((Object)this), (String)JAMS.i18n((String)"You_must_choose_a_context!"), (String)JAMS.i18n((String)"Error_creating_new_filter"));
                    this.addItem();
                    return;
                }
                ContextDescriptor context = (ContextDescriptor)this.newDSDlg.getValue()[0];
                OutputDSDescriptor.FilterDescriptor f = this.ods.addFilter(context, this.newDSDlg.getDsName());
                this.setValue(this.ods);
            }
        }

        protected void editItem() {
            int selection = this.getListbox().getSelectedIndex();
            if (selection >= 0) {
                OutputDSDescriptor.FilterDescriptor f = (OutputDSDescriptor.FilterDescriptor)this.getListbox().getSelectedValue();
                String value = GUIHelper.showInputDlg((Component)((Object)this), null, (String)JAMS.i18n((String)"New_value"), (String)f.expression);
                if (value != null) {
                    if (StringTools.isEmptyString((String)value)) {
                        GUIHelper.showErrorDlg((Component)((Object)this), (String)JAMS.i18n((String)"Filter_expression_must_not_be_empty!"), (String)JAMS.i18n((String)"Error_creating_new_filter"));
                        this.editItem();
                        return;
                    }
                    f.expression = value;
                    this.scrollPane.revalidate();
                    this.scrollPane.repaint();
                }
            }
        }

        protected void removeItem() {
            int selection = this.getListbox().getSelectedIndex();
            OutputDSDescriptor.FilterDescriptor value = (OutputDSDescriptor.FilterDescriptor)this.getListbox().getSelectedValue();
            if (value != null) {
                this.ods.removeFilter(value);
                this.setValue(this.ods);
                if (selection >= this.listData.getValue().size()) {
                    selection = this.listData.getValue().size() - 1;
                }
                this.getListbox().setSelectedIndex(selection);
            }
        }
    }
}

