/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.gui.tools.GUIHelper;
import jams.meta.ModelProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ModelSubgroupDlg
extends JDialog {
    public static final int OK_RESULT = 0;
    public static final int CANCEL_RESULT = -1;
    private JComboBox groupCombo;
    private JTextField nameField;
    private JTextField helpURLField;
    private JTextArea helpTextField;
    private int result = -1;

    public ModelSubgroupDlg(Frame owner) {
        super(owner);
        this.setLocationRelativeTo(owner);
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.setTitle(JAMS.i18n((String)"Subgroup_editor"));
        this.setLayout(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(gbl);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JPanel(), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Group:")), (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Name:")), (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Help_URL:")), (int)0, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Help_Text:")), (int)0, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
        this.groupCombo = new JComboBox();
        this.nameField = new JTextField();
        this.helpURLField = new JTextField();
        this.helpTextField = new JTextArea();
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.groupCombo, (int)1, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.nameField, (int)1, (int)2, (int)1, (int)1, (double)30.0, (double)0.0);
        this.helpURLField.setPreferredSize(new Dimension(200, 20));
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.helpURLField, (int)1, (int)3, (int)2, (int)1, (double)0.0, (double)0.0);
        this.helpTextField.setColumns(30);
        this.helpTextField.setRows(5);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.helpTextField, (int)1, (int)4, (int)2, (int)1, (double)0.0, (double)0.0);
        JButton okButton = new JButton(JAMS.i18n((String)"OK"));
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelSubgroupDlg.this.setVisible(false);
                ModelSubgroupDlg.this.result = 0;
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(JAMS.i18n((String)"Cancel"));
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelSubgroupDlg.this.setVisible(false);
                ModelSubgroupDlg.this.result = -1;
            }
        };
        cancelButton.addActionListener(cancelListener);
        cancelButton.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
    }

    public void update(String[] groupNames, ModelProperties.Group subgroup, String currentGroup) {
        this.groupCombo.setModel(new DefaultComboBoxModel<String>(groupNames));
        this.groupCombo.setSelectedItem(currentGroup);
        if (subgroup != null) {
            this.nameField.setText(subgroup.name);
            this.helpURLField.setText(subgroup.getHelpComponent().getHelpURL());
            this.helpTextField.setText(subgroup.getHelpComponent().getHelpText());
        } else {
            this.nameField.setText("");
            this.helpURLField.setText("");
            this.helpTextField.setText("");
        }
        this.pack();
    }

    public String getGroup() {
        return (String)this.groupCombo.getSelectedItem();
    }

    public int getResult() {
        return this.result;
    }

    @Override
    public String getName() {
        return this.nameField.getText();
    }

    public String getHelpURL() {
        return this.helpURLField.getText();
    }

    public String getHelpText() {
        return this.helpTextField.getText();
    }
}

