/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.gui.input.FloatInput;
import jams.gui.input.IntegerInput;
import jams.gui.tools.GUIHelper;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.ModelProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ModelPropertyDlg
extends JDialog {
    private static final Dimension TEXT_FIELD_DIM = new Dimension(200, 20);
    private static final Dimension TEXT_AREA_DIM = new Dimension(300, 100);
    public static final int OK_RESULT = 0;
    public static final int CANCEL_RESULT = -1;
    private JComboBox groupCombo;
    private JComboBox componentCombo;
    private JComboBox varCombo;
    private HashMap<String, ComponentDescriptor> componentDescriptors;
    private JTextField nameField;
    private JTextField descriptionField;
    private JTextField helpURLField;
    private JTextArea helpTextField;
    private FloatInput lowField;
    private FloatInput upField;
    private IntegerInput lengthField;
    private int result = -1;

    public ModelPropertyDlg(Frame owner) {
        super(owner);
        this.setLocationRelativeTo(owner);
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.setTitle(JAMS.i18n((String)"Model_property_editor"));
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(gbl);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JPanel(), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Group:")), (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Component:")), (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Variable/Attribute:")), (int)0, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Name:")), (int)0, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Description:")), (int)0, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Lower_Boundary:")), (int)0, (int)6, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Upper_Boundary:")), (int)0, (int)7, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Length:")), (int)0, (int)8, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Help_URL:")), (int)0, (int)9, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)new JLabel(JAMS.i18n((String)"Help_Text:")), (int)0, (int)10, (int)1, (int)1, (double)0.0, (double)0.0);
        this.groupCombo = new JComboBox();
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.groupCombo, (int)1, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        this.componentCombo = new JComboBox();
        this.componentCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ModelPropertyDlg.this.updateComponentVars(e.getItem());
                }
            }
        });
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.componentCombo, (int)1, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        this.varCombo = new JComboBox();
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.varCombo, (int)1, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
        this.nameField = new JTextField();
        this.nameField.setPreferredSize(TEXT_FIELD_DIM);
        this.descriptionField = new JTextField();
        this.descriptionField.setPreferredSize(TEXT_FIELD_DIM);
        this.lowField = new FloatInput();
        this.upField = new FloatInput();
        this.lengthField = new IntegerInput();
        this.helpURLField = new JTextField();
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.nameField, (int)1, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.descriptionField, (int)1, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.lowField.getComponent(), (int)1, (int)6, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.upField.getComponent(), (int)1, (int)7, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.lengthField.getComponent(), (int)1, (int)8, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)this.helpURLField, (int)1, (int)9, (int)2, (int)1, (double)0.0, (double)0.0);
        this.helpTextField = new JTextArea();
        JScrollPane textScroll = new JScrollPane(this.helpTextField);
        textScroll.setPreferredSize(TEXT_AREA_DIM);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)textScroll, (int)1, (int)10, (int)2, (int)1, (double)0.0, (double)0.0);
        JButton okButton = new JButton(JAMS.i18n((String)"OK"));
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelPropertyDlg.this.setVisible(false);
                ModelPropertyDlg.this.result = 0;
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(JAMS.i18n((String)"Cancel"));
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelPropertyDlg.this.setVisible(false);
                ModelPropertyDlg.this.result = -1;
            }
        };
        cancelButton.addActionListener(cancelListener);
        cancelButton.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.setResizable(false);
    }

    private void updateComponentVars(Object item) {
        ComponentDescriptor cd = this.componentDescriptors.get((String)item);
        HashMap vars = cd.getComponentFields();
        ArrayList<String> varNames = new ArrayList<String>();
        for (String name : vars.keySet()) {
            ComponentField var = (ComponentField)vars.get(name);
            if (var.getContext() != null) continue;
            varNames.add(name);
        }
        if (cd instanceof ContextDescriptor) {
            HashMap attrs = ((ContextDescriptor)cd).getStaticAttributes();
            for (String name : attrs.keySet()) {
                varNames.add(name);
            }
        }
        Collections.sort(varNames);
        varNames.add(0, JAMS.i18n((String)"[enable_component]"));
        String[] varNameArray = varNames.toArray(new String[varNames.size()]);
        this.varCombo.setModel(new DefaultComboBoxModel<String>(varNameArray));
    }

    public void update(String[] groupNames, HashMap<String, ComponentDescriptor> componentDescriptors, ModelProperties.ModelProperty property, String currentGroup) {
        this.groupCombo.setModel(new DefaultComboBoxModel<String>(groupNames));
        this.groupCombo.setSelectedItem(currentGroup);
        this.componentDescriptors = componentDescriptors;
        ArrayList<String> componentNames = new ArrayList<String>();
        for (String name : componentDescriptors.keySet()) {
            componentNames.add(name);
        }
        Collections.sort(componentNames);
        String[] compNameArray = componentNames.toArray(new String[componentNames.size()]);
        this.componentCombo.setModel(new DefaultComboBoxModel<String>(compNameArray));
        if (property != null) {
            this.componentCombo.setSelectedItem(property.component.getInstanceName());
            if (property.var != null) {
                this.varCombo.setSelectedItem(property.var.getName());
            } else if (property.attribute != null) {
                this.varCombo.setSelectedItem(property.attribute.getName());
            }
            this.nameField.setText(property.name);
            this.nameField.setCaretPosition(0);
            this.descriptionField.setText(property.description);
            this.descriptionField.setCaretPosition(0);
            this.lowField.setValue("" + property.lowerBound);
            this.upField.setValue("" + property.upperBound);
            this.lengthField.setValue("" + property.length);
            this.helpURLField.setText(property.getHelpComponent().getHelpURL());
            this.helpURLField.setCaretPosition(0);
            this.helpTextField.setText(property.getHelpComponent().getHelpText());
            this.helpTextField.setCaretPosition(0);
        } else {
            this.nameField.setText("");
            this.descriptionField.setText("");
            this.lowField.setValue("");
            this.upField.setValue("");
            this.lengthField.setValue("");
            this.helpURLField.setText("");
            this.helpTextField.setText("");
            this.updateComponentVars(this.componentCombo.getSelectedItem());
        }
        this.pack();
    }

    public String getGroup() {
        return (String)this.groupCombo.getSelectedItem();
    }

    public int getResult() {
        return this.result;
    }

    @Override
    public String getName() {
        return this.nameField.getText();
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public double getLowerBound() {
        double lowBound = 0.0;
        try {
            lowBound = Double.parseDouble(this.lowField.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return lowBound;
    }

    public double getUpperBound() {
        double upBound = 0.0;
        try {
            upBound = Double.parseDouble(this.upField.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return upBound;
    }

    public int getLength() {
        int length = 0;
        try {
            length = Integer.parseInt(this.lengthField.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return length;
    }

    public String getHelpURL() {
        return this.helpURLField.getText();
    }

    public String getHelpText() {
        return this.helpTextField.getText();
    }

    public ComponentDescriptor getComponent() {
        return this.componentDescriptors.get(this.componentCombo.getSelectedItem());
    }

    public ComponentField getVar() {
        return (ComponentField)this.getComponent().getComponentFields().get(this.varCombo.getSelectedItem());
    }

    public ContextAttribute getAttribute() {
        ComponentDescriptor cd = this.getComponent();
        if (cd instanceof ContextDescriptor) {
            return (ContextAttribute)((ContextDescriptor)cd).getStaticAttributes().get(this.varCombo.getSelectedItem());
        }
        return null;
    }
}

