/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.gui.input.InputComponent;
import jams.gui.input.InputComponentFactory;
import jams.gui.tools.GUIHelper;
import jams.meta.ModelDescriptor;
import jams.meta.ModelProperties;
import jamsui.juice.JUICE;
import jamsui.juice.gui.ModelPropertyDlg;
import jamsui.juice.gui.ModelSubgroupDlg;
import jamsui.juice.gui.ModelView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class ModelGUIPanel
extends JPanel {
    private static ImageIcon UP_ICON = new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/arrowup.png")).getImage().getScaledInstance(9, 5, 4));
    private static ImageIcon DOWN_ICON = new ImageIcon(new ImageIcon(ClassLoader.getSystemResource("resources/images/arrowdown.png")).getImage().getScaledInstance(9, 5, 4));
    private static final Dimension BUTTON_DIMENSION = new Dimension(150, 20);
    private static final Dimension PANEL_DIMENSION = new Dimension(300, 0);
    private JTabbedPane tabbedPane = new JTabbedPane();
    private HashMap<ModelProperties.ModelProperty, InputComponent> inputMap = new HashMap();
    private ModelPropertyDlg propertyDlg = new ModelPropertyDlg(JUICE.getJuiceFrame());
    private ModelSubgroupDlg subgroupDlg = new ModelSubgroupDlg(JUICE.getJuiceFrame());
    private HashMap<ModelProperties.Group, JPanel> groupPanels;
    private HashMap<ModelProperties.Group, JScrollPane> groupPanes;
    private JPanel mainButtonPanel = new JPanel();
    private ModelView view;
    private Font titledBorderFont;

    public ModelGUIPanel(ModelView view) {
        this.view = view;
        this.tabbedPane.setTabPlacement(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)this.mainButtonPanel, "North");
        this.titledBorderFont = (Font)UIManager.getDefaults().get("TitledBorder.font");
        int fontSize = this.titledBorderFont.getSize();
        if (this.titledBorderFont.getStyle() == 1) {
            fontSize += 2;
        }
        this.titledBorderFont = new Font(this.titledBorderFont.getName(), 1, fontSize);
        JButton addPropertyButton = new JButton(JAMS.i18n((String)"Add_Property"));
        addPropertyButton.setPreferredSize(BUTTON_DIMENSION);
        addPropertyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelGUIPanel.this.addProperty();
            }
        });
        JButton addSubgroupButton = new JButton(JAMS.i18n((String)"Add_Subgroup"));
        addSubgroupButton.setPreferredSize(BUTTON_DIMENSION);
        addSubgroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelGUIPanel.this.addSubgroup();
            }
        });
        JButton addGroupButton = new JButton(JAMS.i18n((String)"Add_Group"));
        addGroupButton.setPreferredSize(BUTTON_DIMENSION);
        addGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelGUIPanel.this.addGroup();
            }
        });
        JButton moveupGroupButton = new JButton(JAMS.i18n((String)"Group_up"));
        moveupGroupButton.setPreferredSize(BUTTON_DIMENSION);
        moveupGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelGUIPanel.this.moveupGroup();
            }
        });
        JButton movedownGroupButton = new JButton(JAMS.i18n((String)"Group_down"));
        movedownGroupButton.setPreferredSize(BUTTON_DIMENSION);
        movedownGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelGUIPanel.this.movedownGroup();
            }
        });
        JButton editGroupButton = new JButton(JAMS.i18n((String)"Edit_Group"));
        editGroupButton.setPreferredSize(BUTTON_DIMENSION);
        editGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelGUIPanel.this.editGroup();
            }
        });
        JButton delGroupButton = new JButton(JAMS.i18n((String)"Remove_Group"));
        delGroupButton.setPreferredSize(BUTTON_DIMENSION);
        delGroupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelGUIPanel.this.deleteGroup();
            }
        });
        GridBagLayout gblButton = new GridBagLayout();
        JPanel innerButtonPanel = new JPanel();
        innerButtonPanel.setLayout(gblButton);
        GUIHelper.addGBComponent((Container)innerButtonPanel, (GridBagLayout)gblButton, (Component)addPropertyButton, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)innerButtonPanel, (GridBagLayout)gblButton, (Component)addSubgroupButton, (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)innerButtonPanel, (GridBagLayout)gblButton, (Component)addGroupButton, (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)innerButtonPanel, (GridBagLayout)gblButton, (Component)editGroupButton, (int)1, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)innerButtonPanel, (GridBagLayout)gblButton, (Component)moveupGroupButton, (int)2, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)innerButtonPanel, (GridBagLayout)gblButton, (Component)movedownGroupButton, (int)2, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)innerButtonPanel, (GridBagLayout)gblButton, (Component)delGroupButton, (int)3, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        this.mainButtonPanel.add(innerButtonPanel);
        this.setPreferredSize(PANEL_DIMENSION);
    }

    private void moveupGroup() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index > 0) {
            ModelDescriptor md = this.view.getModelDescriptor();
            ModelProperties.Group group = md.getModelProperties().getGroup(index);
            md.getModelProperties().removeGroup(group);
            Component comp = this.tabbedPane.getComponentAt(index);
            this.tabbedPane.removeTabAt(index);
            md.getModelProperties().insertGroup(group, --index);
            this.tabbedPane.add(comp, index);
            this.tabbedPane.setTitleAt(index, group.getName());
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    private void movedownGroup() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index < this.tabbedPane.getTabCount() - 1) {
            ModelDescriptor md = this.view.getModelDescriptor();
            ModelProperties.Group group = md.getModelProperties().getGroup(index);
            md.getModelProperties().removeGroup(group);
            Component comp = this.tabbedPane.getComponentAt(index);
            this.tabbedPane.removeTabAt(index);
            md.getModelProperties().insertGroup(group, ++index);
            this.tabbedPane.add(comp, index);
            this.tabbedPane.setTitleAt(index, group.getName());
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    private void editGroup() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index < 0) {
            return;
        }
        ModelProperties mp = this.view.getModelDescriptor().getModelProperties();
        ModelProperties.Group group = mp.getGroup(index);
        String groupName = group.getName();
        String newGroupName = JOptionPane.showInputDialog(this, JAMS.i18n((String)"Group_name:"), groupName);
        if (newGroupName == null || newGroupName.equals("") || newGroupName.equals(groupName)) {
            return;
        }
        if (!mp.setGroupName(group, newGroupName)) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Group_name_already_in_use!"), (String)JAMS.i18n((String)"Error"));
            return;
        }
        this.tabbedPane.setTitleAt(index, newGroupName);
    }

    private void addGroup() {
        String groupName = JOptionPane.showInputDialog(this, (Object)JAMS.i18n((String)"Group_name:"));
        if (groupName == null || groupName.equals("")) {
            return;
        }
        ModelProperties mp = this.view.getModelDescriptor().getModelProperties();
        if (!mp.addGroup(groupName)) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Group_name_already_in_use!"), (String)JAMS.i18n((String)"Error"));
            return;
        }
        ModelProperties.Group group = mp.getGroup(groupName);
        JPanel contentPanel = new JPanel();
        JPanel scrollPanel = new JPanel();
        scrollPanel.add(contentPanel);
        JScrollPane scrollPane = new JScrollPane(scrollPanel);
        this.tabbedPane.addTab(groupName, scrollPane);
        this.tabbedPane.setSelectedComponent(scrollPane);
        this.groupPanels.put(group, contentPanel);
        this.groupPanes.put(group, scrollPane);
    }

    private void deleteGroup() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index < 0) {
            return;
        }
        if (GUIHelper.showYesNoDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Really_delete_this_Group_and_all_of_its_properties?"), (String)JAMS.i18n((String)"Delete_Group")) != 0) {
            return;
        }
        ModelProperties mp = this.view.getModelDescriptor().getModelProperties();
        ModelProperties.Group group = mp.getGroup(index);
        mp.removeGroup(group);
        this.tabbedPane.removeTabAt(index);
        this.groupPanels.remove(group);
    }

    public void updateGroup(ModelProperties.Group group) {
        if (group.isSubGroup()) {
            this.updateGroup(group.getGroup());
            return;
        }
        GridBagLayout gbl = new GridBagLayout();
        JPanel contentPanel = this.groupPanels.get(group);
        contentPanel.removeAll();
        contentPanel.setLayout(gbl);
        int y = 1;
        ArrayList properties = group.getProperties();
        for (int j = 0; j < properties.size(); ++j) {
            Object modelElement = properties.get(j);
            if (modelElement instanceof ModelProperties.ModelProperty) {
                ModelProperties.ModelProperty property = (ModelProperties.ModelProperty)modelElement;
                JPanel buttonPanel = this.createPropertyButtonPanel(contentPanel, gbl, property, y);
                GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)buttonPanel, (int)3, (int)y, (int)1, (int)1, (double)1.0, (double)1.0);
            }
            if (modelElement instanceof ModelProperties.Group) {
                ModelProperties.Group subgroup = (ModelProperties.Group)modelElement;
                ArrayList subgroupProperties = subgroup.getProperties();
                int height = subgroupProperties.size() + 3;
                JPanel subgroupPanel = new JPanel(gbl);
                subgroupPanel.setBorder(BorderFactory.createTitledBorder(null, subgroup.getCanonicalName(), 0, 0, this.titledBorderFont));
                GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)subgroupPanel, (int)0, (int)y, (int)3, (int)height, (int)6, (int)2, (int)6, (int)2, (double)1.0, (double)1.0);
                JPanel sgButtonPanel = this.createSubgroupButtonPanel(subgroup);
                GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)sgButtonPanel, (int)3, (int)y, (int)3, (int)1, (double)1.0, (double)1.0);
                int row = y + 1;
                for (int k = 0; k < subgroupProperties.size(); ++k) {
                    Object subgroupElement = subgroupProperties.get(k);
                    if (!(subgroupElement instanceof ModelProperties.ModelProperty)) continue;
                    ModelProperties.ModelProperty subgroupProperty = (ModelProperties.ModelProperty)subgroupElement;
                    JPanel buttonPanel = this.createPropertyButtonPanel(subgroupPanel, gbl, subgroupProperty, ++row);
                    GUIHelper.addGBComponent((Container)subgroupPanel, (GridBagLayout)gbl, (Component)buttonPanel, (int)3, (int)row, (int)3, (int)1, (double)1.0, (double)1.0);
                }
                y = row += 2;
            }
            ++y;
        }
        contentPanel.updateUI();
    }

    public void updatePanel() {
        ArrayList groups = this.view.getModelDescriptor().getModelProperties().getGroupList();
        this.groupPanels = new HashMap();
        this.groupPanes = new HashMap();
        this.tabbedPane.removeAll();
        for (ModelProperties.Group group : groups) {
            JPanel contentPanel = new JPanel();
            JPanel scrollPanel = new JPanel();
            scrollPanel.add(contentPanel);
            JScrollPane scrollPane = new JScrollPane(scrollPanel);
            this.groupPanels.put(group, contentPanel);
            this.groupPanes.put(group, scrollPane);
            this.updateGroup(group);
            this.tabbedPane.addTab(group.getName(), scrollPane);
        }
    }

    private JPanel createPropertyButtonPanel(JPanel contentPanel, GridBagLayout gbl, ModelProperties.ModelProperty property, int row) {
        JPanel buttonPanel = new JPanel();
        JLabel nameLabel = new JLabel(property.name);
        nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)nameLabel, (int)0, (int)row, (int)1, (int)1, (double)0.0, (double)0.0);
        InputComponent ic = property.var != null ? InputComponentFactory.createInputComponent((Class)property.var.getType(), (boolean)true) : (property.attribute != null ? InputComponentFactory.createInputComponent((Class)property.attribute.getType(), (boolean)true) : InputComponentFactory.createInputComponent((Class)JUICE.JAMS_DATA_TYPES[0], (boolean)true));
        ic.setRange(property.lowerBound, property.upperBound);
        ic.setLength(property.length);
        ic.setHelpText(property.description);
        ic.getComponent().setEnabled(false);
        GUIHelper.addGBComponent((Container)contentPanel, (GridBagLayout)gbl, (Component)((Component)ic), (int)1, (int)row, (int)2, (int)1, (double)1.0, (double)1.0);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder());
        ElementButton downButton = new ElementButton((ModelProperties.ModelElement)property);
        downButton.setToolTipText(JAMS.i18n((String)"Move_down"));
        downButton.setIcon(DOWN_ICON);
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementButton button = (ElementButton)e.getSource();
                ModelGUIPanel.this.moveDownElement(button.element);
            }
        });
        buttonPanel.add(downButton);
        ElementButton upButton = new ElementButton((ModelProperties.ModelElement)property);
        upButton.setToolTipText(JAMS.i18n((String)"Move_up"));
        upButton.setIcon(UP_ICON);
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementButton button = (ElementButton)e.getSource();
                ModelGUIPanel.this.moveUpElement(button.element);
            }
        });
        buttonPanel.add(upButton);
        ElementButton delButton = new ElementButton((ModelProperties.ModelElement)property);
        delButton.setToolTipText(JAMS.i18n((String)"Delete"));
        delButton.setText("-");
        delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementButton button = (ElementButton)e.getSource();
                ModelGUIPanel.this.deleteElement(button.element);
            }
        });
        buttonPanel.add(delButton);
        ElementButton editButton = new ElementButton((ModelProperties.ModelElement)property);
        editButton.setToolTipText(JAMS.i18n((String)"Edit"));
        editButton.setText("...");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementButton button = (ElementButton)e.getSource();
                ModelGUIPanel.this.editProperty((ModelProperties.ModelProperty)button.element);
            }
        });
        buttonPanel.add(editButton);
        return buttonPanel;
    }

    private JPanel createSubgroupButtonPanel(ModelProperties.Group subgroup) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder());
        ElementButton downButton = new ElementButton((ModelProperties.ModelElement)subgroup);
        downButton.setToolTipText(JAMS.i18n((String)"Move_down"));
        downButton.setIcon(DOWN_ICON);
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementButton button = (ElementButton)e.getSource();
                ModelGUIPanel.this.moveDownElement(button.element);
            }
        });
        buttonPanel.add(downButton);
        ElementButton upButton = new ElementButton((ModelProperties.ModelElement)subgroup);
        upButton.setToolTipText(JAMS.i18n((String)"Move_up"));
        upButton.setIcon(UP_ICON);
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementButton button = (ElementButton)e.getSource();
                ModelGUIPanel.this.moveUpElement(button.element);
            }
        });
        buttonPanel.add(upButton);
        ElementButton delButton = new ElementButton((ModelProperties.ModelElement)subgroup);
        delButton.setToolTipText(JAMS.i18n((String)"Delete"));
        delButton.setText("-");
        delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementButton button = (ElementButton)e.getSource();
                ModelGUIPanel.this.deleteElement(button.element);
            }
        });
        buttonPanel.add(delButton);
        ElementButton editButton = new ElementButton((ModelProperties.ModelElement)subgroup);
        editButton.setToolTipText(JAMS.i18n((String)"Edit"));
        editButton.setText("...");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElementButton button = (ElementButton)e.getSource();
                ModelGUIPanel.this.editSubgroup((ModelProperties.Group)button.element);
            }
        });
        buttonPanel.add(editButton);
        return buttonPanel;
    }

    private void moveDownElement(ModelProperties.ModelElement element) {
        ArrayList list = element.getGroup().getProperties();
        int index = list.indexOf(element);
        if (index < list.size() - 1) {
            list.remove(index);
            list.add(index + 1, element);
        }
        ModelProperties.Group mainGroup = element.getMainGroup();
        this.updateGroup(mainGroup);
        JPanel contentPanel = this.groupPanels.get(mainGroup);
        contentPanel.updateUI();
    }

    private void moveUpElement(ModelProperties.ModelElement element) {
        ArrayList list = element.getGroup().getProperties();
        int index = list.indexOf(element);
        if (index > 0) {
            list.remove(index);
            list.add(index - 1, element);
        }
        ModelProperties.Group mainGroup = element.getMainGroup();
        this.updateGroup(mainGroup);
        JPanel contentPanel = this.groupPanels.get(mainGroup);
        contentPanel.updateUI();
    }

    private void deleteElement(ModelProperties.ModelElement element) {
        ArrayList test;
        ArrayList list = element.getGroup().getProperties();
        if (element instanceof ModelProperties.Group && (test = ((ModelProperties.Group)element).getProperties()).size() > 0) {
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Subgroup_needs_to_be_empty."), (String)JAMS.i18n((String)"Deletion_not_possible"));
            return;
        }
        int result = GUIHelper.showYesNoDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Really_delete_this_property?"), (String)JAMS.i18n((String)"Delete_property"));
        if (result != 0) {
            return;
        }
        list.remove(element);
        ModelProperties.Group mainGroup = element.getMainGroup();
        JPanel contentPanel = this.groupPanels.get(mainGroup);
        this.updateGroup(mainGroup);
        contentPanel.updateUI();
    }

    private void addProperty() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String groupName = this.tabbedPane.getTitleAt(index);
        ModelProperties mp = this.view.getModelDescriptor().getModelProperties();
        this.propertyDlg.update(mp.getAllGroupNames(), this.view.getModelDescriptor().getComponentDescriptors(), null, groupName);
        this.propertyDlg.setVisible(true);
        if (this.propertyDlg.getResult() == 0) {
            ModelProperties.ModelProperty property = mp.createProperty();
            String newGroupName = this.propertyDlg.getGroup();
            property.name = this.propertyDlg.getName();
            property.description = this.propertyDlg.getDescription();
            property.lowerBound = this.propertyDlg.getLowerBound();
            property.upperBound = this.propertyDlg.getUpperBound();
            property.length = this.propertyDlg.getLength();
            property.getHelpComponent().setHelpURL(this.propertyDlg.getHelpURL());
            property.getHelpComponent().setHelpText(this.propertyDlg.getHelpText());
            property.component = this.propertyDlg.getComponent();
            property.attribute = this.propertyDlg.getAttribute();
            property.var = this.propertyDlg.getVar();
            ModelProperties.Group group = mp.getGroup(newGroupName);
            mp.addProperty(group, property);
            if (group.isSubGroup()) {
                group = group.getGroup();
            }
            this.updateGroup(group);
            this.groupPanels.get(group).updateUI();
        }
    }

    private void addSubgroup() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String groupName = this.tabbedPane.getTitleAt(index);
        ModelProperties mp = this.view.getModelDescriptor().getModelProperties();
        this.subgroupDlg.update(mp.getGroupNames(), null, groupName);
        this.subgroupDlg.setVisible(true);
        if (this.subgroupDlg.getResult() == 0) {
            groupName = this.subgroupDlg.getGroup();
            ModelProperties.Group group = mp.getGroup(groupName);
            String subgroubName = this.subgroupDlg.getName();
            ModelProperties.Group subgroup = mp.createSubgroup(group, subgroubName);
            subgroup.getHelpComponent().setHelpURL(this.subgroupDlg.getHelpURL());
            subgroup.getHelpComponent().setHelpText(this.subgroupDlg.getHelpText());
            this.updateGroup(group);
            this.groupPanels.get(group).updateUI();
        }
    }

    private void editProperty(ModelProperties.ModelProperty property) {
        ModelProperties.Group group = property.getGroup();
        ModelProperties mp = this.view.getModelDescriptor().getModelProperties();
        this.propertyDlg.update(mp.getAllGroupNames(), this.view.getModelDescriptor().getComponentDescriptors(), property, group.getName());
        this.propertyDlg.setVisible(true);
        if (this.propertyDlg.getResult() == 0) {
            String newGroupName = this.propertyDlg.getGroup();
            property.name = this.propertyDlg.getName();
            property.description = this.propertyDlg.getDescription();
            property.lowerBound = this.propertyDlg.getLowerBound();
            property.upperBound = this.propertyDlg.getUpperBound();
            property.length = this.propertyDlg.getLength();
            property.getHelpComponent().setHelpURL(this.propertyDlg.getHelpURL());
            property.getHelpComponent().setHelpText(this.propertyDlg.getHelpText());
            property.component = this.propertyDlg.getComponent();
            property.attribute = this.propertyDlg.getAttribute();
            property.var = this.propertyDlg.getVar();
            ModelProperties.Group newGroup = mp.getGroup(newGroupName);
            if (!newGroup.equals(group)) {
                mp.removePropertyFromGroup(group, (ModelProperties.ModelElement)property);
                mp.addPropertyToGroup(newGroup, (ModelProperties.ModelElement)property);
                this.updateGroup(newGroup);
            }
            this.updateGroup(group);
        }
    }

    private void editSubgroup(ModelProperties.Group subgroup) {
        ModelProperties.Group group = subgroup.getGroup();
        ModelProperties mp = this.view.getModelDescriptor().getModelProperties();
        this.subgroupDlg.update(mp.getGroupNames(), subgroup, group.getName());
        this.subgroupDlg.setVisible(true);
        if (this.subgroupDlg.getResult() == 0) {
            String newGroupName = this.subgroupDlg.getGroup();
            subgroup.name = this.subgroupDlg.getName();
            subgroup.getHelpComponent().setHelpURL(this.subgroupDlg.getHelpURL());
            subgroup.getHelpComponent().setHelpText(this.subgroupDlg.getHelpText());
            ModelProperties.Group newGroup = mp.getGroup(newGroupName);
            if (!newGroup.equals(group)) {
                mp.removePropertyFromGroup(group, (ModelProperties.ModelElement)subgroup);
                mp.addPropertyToGroup(newGroup, (ModelProperties.ModelElement)subgroup);
                this.updateGroup(newGroup);
            }
            this.updateGroup(group);
        }
    }

    class ElementButton
    extends JButton {
        ModelProperties.ModelElement element;

        public ElementButton(ModelProperties.ModelElement element) {
            this.setBorder(null);
            this.setPreferredSize(new Dimension(20, 14));
            this.element = element;
        }
    }
}

