/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.JAMSFileFilter;
import jams.JAMSLogging;
import jams.SystemProperties;
import jams.gui.AboutDlg;
import jams.gui.LogViewDlg;
import jams.gui.PropertyDlg;
import jams.gui.RuntimeManagerPanel;
import jams.gui.WorkerDlg;
import jams.gui.WorkspaceDlg;
import jams.gui.tools.GUIHelper;
import jams.gui.tools.GUIState;
import jams.meta.ModelDescriptor;
import jams.server.client.gui.BrowseJAMSCloudDlg;
import jams.tools.JAMSTools;
import jams.workspace.InvalidWorkspaceException;
import jams.workspace.JAMSWorkspace;
import jamsui.juice.JUICE;
import jamsui.juice.documentation.DocumentationWizard;
import jamsui.juice.gui.JAMSCloudToolbar;
import jamsui.juice.gui.ModelView;
import jamsui.juice.gui.SearchDlg;
import jamsui.juice.gui.TreePanel;
import jamsui.juice.gui.tree.LibTree;
import jamsui.juice.gui.tree.ModelTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import optas.gui.wizard.ObjectiveConfiguration;
import optas.gui.wizard.OptimizerConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JUICEFrame
extends JFrame {
    static final Logger log = Logger.getLogger(JUICEFrame.class.getName());
    private static final int TREE_PANE_WIDTH = 300;
    private static final int RT_MANAGER_HEIGHT = 600;
    private static final int DIVIDER_WIDTH = 8;
    private PropertyDlg propertyDlg;
    private BrowseJAMSCloudDlg jamsCloudBrowser = null;
    private JFileChooser jfcProps;
    private JFileChooser jfcParams;
    private JFileChooser jfcModels;
    private TreePanel libTreePanel;
    private JDesktopPane modelPanel = new JDesktopPane();
    private JMenu windowMenu;
    private JMenu modelMenu;
    private JMenu recentMenu;
    private JMenuItem OptimizationWizardItem;
    private JMenuItem ObjectiveWizardItem;
    private JLabel statusLabel;
    private JAMSCloudToolbar jamsServerToolbar = null;
    private final LogViewDlg infoDlg = new LogViewDlg((Frame)this, 400, 400, JAMS.i18n((String)"Info_Log"));
    private final LogViewDlg errorDlg = new LogViewDlg((Frame)this, 400, 400, JAMS.i18n((String)"Error_Log"));
    private Node modelProperties;
    WorkerDlg loadModelDlg;
    private SearchDlg searchDlg;
    private String modelPath;
    private Action editPrefsAction;
    private Action remoteControlAction;
    private Action reloadLibsAction;
    private Action newModelAction;
    private Action loadPrefsAction;
    private Action savePrefsAction;
    private Action loadModelAction;
    private Action saveModelAction;
    private Action saveAsModelAction;
    private Action exitAction;
    private Action aboutAction;
    private Action searchAction;
    private Action copyModelGUIAction;
    private Action pasteModelGUIAction;
    private Action OptimizationWizardAction;
    private Action ObjectiveWizardAction;
    private Action GenerateDocumentationGUIAction;
    private Action loadModelParamAction;
    private Action saveModelParamAction;
    private Action runModelAction;
    private Action runModelFromLauncherAction;
    private Action jadeAction;
    private Action wsBrowseAction;
    private Action infoLogAction;
    private Action errorLogAction;
    private Action onlineAction;
    private Action outputDSAction;
    private Action wsPrefsAction;
    private Action wsCreateAction;

    public JUICEFrame() {
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)log);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(0);
        GUIState.setMainWindow((Window)this);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                JUICEFrame.this.exit();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.remoteControlAction = new AbstractAction(JAMS.i18n((String)"Start_Remote_Control")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JUICEFrame.this.jamsCloudBrowser == null) {
                    JUICEFrame.this.jamsCloudBrowser = new BrowseJAMSCloudDlg((Window)JUICEFrame.this, JUICE.getJamsProperties());
                    JUICEFrame.this.jamsCloudBrowser.init();
                    JUICEFrame.this.jamsCloudBrowser.setDefaultCloseOperation(2);
                }
                GUIHelper.centerOnParent((Window)JUICEFrame.this.jamsCloudBrowser, (boolean)true);
                JUICEFrame.this.jamsCloudBrowser.setVisible(true);
            }
        };
        this.editPrefsAction = new AbstractAction(JAMS.i18n((String)"Edit_Preferences...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.propertyDlg.setProperties(JUICE.getJamsProperties());
                JUICEFrame.this.propertyDlg.setVisible(true);
                if (JUICEFrame.this.propertyDlg.getResult() == 1) {
                    JUICEFrame.this.propertyDlg.validateProperties();
                }
            }
        };
        this.reloadLibsAction = new AbstractAction(JAMS.i18n((String)"Reload")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICE.updateLibs();
            }
        };
        this.newModelAction = new AbstractAction(JAMS.i18n((String)"New_Model")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.newModel();
            }
        };
        this.loadPrefsAction = new AbstractAction(JAMS.i18n((String)"Load_Preferences...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.jfcProps.setSelectedFile(new File(""));
                int result = JUICEFrame.this.jfcProps.showOpenDialog(JUICEFrame.this);
                if (result == 0) {
                    String stringValue = JUICEFrame.this.jfcProps.getSelectedFile().getAbsolutePath();
                    try {
                        SystemProperties properties = JUICE.getJamsProperties();
                        properties.load(stringValue);
                    }
                    catch (IOException ioe) {
                        JAMSTools.handle((Throwable)ioe);
                    }
                }
            }
        };
        this.savePrefsAction = new AbstractAction(JAMS.i18n((String)"Save_Preferences...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.jfcProps.setSelectedFile(new File(""));
                int result = JUICEFrame.this.jfcProps.showSaveDialog(JUICEFrame.this);
                if (result == 0) {
                    String stringValue = JUICEFrame.this.jfcProps.getSelectedFile().getAbsolutePath();
                    try {
                        SystemProperties properties = JUICE.getJamsProperties();
                        properties.save(stringValue);
                    }
                    catch (IOException ioe) {
                        JAMSTools.handle((Throwable)ioe);
                    }
                }
            }
        };
        this.loadModelAction = new AbstractAction(JAMS.i18n((String)"Open_Model...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.loadModel(JUICEFrame.this.getCurrentView());
            }
        };
        this.saveModelAction = new AbstractAction(JAMS.i18n((String)"Save_Model")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.saveModel(JUICEFrame.this.getCurrentView());
            }
        };
        this.saveModelAction.setEnabled(false);
        this.saveAsModelAction = new AbstractAction(JAMS.i18n((String)"Save_Model_As...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.saveModelAs(JUICEFrame.this.getCurrentView());
            }
        };
        this.saveAsModelAction.setEnabled(false);
        this.exitAction = new AbstractAction(JAMS.i18n((String)"Exit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.exit();
            }
        };
        this.aboutAction = new AbstractAction(JAMS.i18n((String)"About")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDlg((Frame)JUICEFrame.this).setVisible(true);
            }
        };
        this.searchAction = new AbstractAction(JAMS.i18n((String)"Find...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JUICEFrame.this.searchDlg == null) {
                    JUICEFrame.this.searchDlg = new SearchDlg(JUICEFrame.this);
                }
                JUICEFrame.this.searchDlg.setVisible(true);
            }
        };
        this.copyModelGUIAction = new AbstractAction(JAMS.i18n((String)"Copy_Model_GUI")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.pasteModelGUIAction.setEnabled(true);
                ModelView view = JUICEFrame.this.getCurrentView();
                JUICEFrame.this.modelProperties = view.getModelDoc().getElementsByTagName("launcher").item(0).cloneNode(true);
            }
        };
        this.pasteModelGUIAction = new AbstractAction(JAMS.i18n((String)"Paste_Model_GUI")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelView view = JUICEFrame.this.getCurrentView();
                view.getModelDescriptor().setModelParameters((Element)JUICEFrame.this.modelProperties);
            }
        };
        this.OptimizationWizardAction = new AbstractAction(JAMS.i18n((String)"Configure_Optimizer")){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ModelView view = JUICEFrame.this.getCurrentView();
                try {
                    OptimizerConfiguration conf = new OptimizerConfiguration(view.getModelDescriptor(), Logger.getLogger(JUICE.class.getName()));
                    conf.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            OptimizerConfiguration wizard = (OptimizerConfiguration)e.getSource();
                            if (wizard.getSuccessState()) {
                                ModelDescriptor newModelDoc = wizard.getModelDescriptor();
                                view.setModelDescriptor(newModelDoc);
                                view.loadModel(view.getModelDoc());
                            }
                        }
                    });
                    conf.showDialog((JFrame)JUICEFrame.this);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(JUICEFrame.this, "Unable to run optimization wizard!\n" + ex.toString());
                }
            }
        };
        this.ObjectiveWizardAction = new AbstractAction(JAMS.i18n((String)"Configure_Efficiencies")){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ModelView view = JUICEFrame.this.getCurrentView();
                try {
                    ObjectiveConfiguration conf = new ObjectiveConfiguration(view.getModelDescriptor(), view.getSavePath(), Logger.getLogger(JUICE.class.getName()));
                    conf.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ObjectiveConfiguration wizard = (ObjectiveConfiguration)e.getSource();
                            ModelDescriptor newModelDoc = wizard.getModelDescriptor();
                            view.setModelDescriptor(newModelDoc);
                            view.loadModel(view.getModelDoc());
                        }
                    });
                    conf.showDialog((JFrame)JUICEFrame.this);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(JUICEFrame.this, "Unable to run objective wizard!\n" + ex.toString());
                }
            }
        };
        this.GenerateDocumentationGUIAction = new AbstractAction(JAMS.i18n((String)"Generate_Docu")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelView view = JUICEFrame.this.getCurrentView();
                DocumentationWizard docuWiz = new DocumentationWizard();
                docuWiz.createDocumentation(JUICEFrame.this, view.getModelDoc(), JUICE.getJamsProperties(), view.getSavePath());
            }
        };
        this.loadModelParamAction = new AbstractAction(JAMS.i18n((String)"Load_Model_Parameter...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.jfcParams.setSelectedFile(new File(JUICEFrame.this.getCurrentView().getWorkspace().getDirectory(), "."));
                int result = JUICEFrame.this.jfcParams.showOpenDialog(JUICEFrame.this);
                if (result == 0) {
                    String path = JUICEFrame.this.jfcParams.getSelectedFile().getAbsolutePath();
                    File file = new File(path);
                    JUICEFrame.this.getCurrentView().loadParams(file);
                }
            }
        };
        this.saveModelParamAction = new AbstractAction(JAMS.i18n((String)"Save_Model_Parameter...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.jfcParams.setSelectedFile(new File(""));
                int result = JUICEFrame.this.jfcParams.showSaveDialog(JUICEFrame.this);
                if (result == 0) {
                    String path = JUICEFrame.this.jfcParams.getSelectedFile().getAbsolutePath();
                    File file = new File(path);
                    JUICEFrame.this.getCurrentView().saveParams(file);
                }
            }
        };
        this.runModelAction = new AbstractAction(JAMS.i18n((String)"Run_Model")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelView view = JUICEFrame.this.getCurrentView();
                view.runModel();
            }
        };
        this.runModelFromLauncherAction = new AbstractAction(JAMS.i18n((String)"Run_model_from_JAMS_Launcher")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelView view = JUICEFrame.this.getCurrentView();
                view.runModelFromLauncher();
            }
        };
        this.infoLogAction = new AbstractAction(JAMS.i18n((String)"Info_Log...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.infoDlg.setVisible(true);
            }
        };
        this.errorLogAction = new AbstractAction(JAMS.i18n((String)"Error_Log...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.errorDlg.setVisible(true);
            }
        };
        this.onlineAction = new AbstractAction(JAMS.i18n((String)"JAMS_online...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.openURL((String)JAMS.i18n((String)"JAMS_URL"));
            }
        };
        this.outputDSAction = new AbstractAction(JAMS.i18n((String)"Model_output")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUICEFrame.this.getCurrentView().getOutputDSDlg().setVisible(true);
            }
        };
        this.jadeAction = new AbstractAction(JAMS.i18n((String)"DATA_EXPLORER")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelView view = JUICEFrame.this.getCurrentView();
                view.openExplorer();
            }
        };
        this.wsBrowseAction = new AbstractAction(JAMS.i18n((String)"Browse_WS_Dir")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelView view = JUICEFrame.this.getCurrentView();
                view.openWSBrowser();
            }
        };
        this.wsCreateAction = new AbstractAction(JAMS.i18n((String)"Create_WS_Dir")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelView view = JUICEFrame.this.getCurrentView();
                view.createWS();
            }
        };
        this.wsPrefsAction = new AbstractAction(JAMS.i18n((String)"EDIT_WORKSPACE...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceDlg wsDlg = new WorkspaceDlg((Frame)JUICEFrame.this);
                ModelView view = JUICEFrame.this.getCurrentView();
                JAMSWorkspace ws = view.getWorkspace();
                if (ws == null) {
                    GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Invalid_Workspace"), (String)JAMS.i18n((String)"Error"));
                    return;
                }
                try {
                    ws.init();
                    wsDlg.setVisible(ws);
                }
                catch (InvalidWorkspaceException ex) {
                    GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)JAMS.i18n((String)"Invalid_Workspace"), (String)JAMS.i18n((String)"Error"));
                }
            }
        };
        this.setIconImages(JAMSTools.getJAMSIcons());
        this.setTitle("JAMS Builder");
        this.loadModelDlg = new WorkerDlg((Window)this, JAMS.i18n((String)"Loading_Model"));
        this.propertyDlg = new PropertyDlg((Frame)this, JUICE.getJamsProperties());
        this.jfcModels = GUIHelper.getJFileChooser((FileFilter)JAMSFileFilter.getModelFilter());
        this.jfcModels.setFileSelectionMode(0);
        this.jfcModels.setCurrentDirectory(JAMS.getBaseDir());
        this.jfcParams = GUIHelper.getJFileChooser((FileFilter)JAMSFileFilter.getParameterFilter());
        this.jfcParams.setFileSelectionMode(0);
        this.jfcParams.setCurrentDirectory(JAMS.getBaseDir());
        this.jfcProps = GUIHelper.getJFileChooser((FileFilter)JAMSFileFilter.getPropertyFilter());
        this.jfcProps.setFileSelectionMode(0);
        this.jfcProps.setCurrentDirectory(JAMS.getBaseDir());
        if (System.getProperty("os.name").contains("Windows")) {
            this.modelPanel.setDragMode(0);
        } else {
            this.modelPanel.setDragMode(1);
        }
        JButton reloadLibsButton = new JButton(this.reloadLibsAction);
        this.libTreePanel = new TreePanel();
        this.libTreePanel.addCustomButton(reloadLibsButton);
        JPanel rtManagerPanel = new JPanel();
        rtManagerPanel.setLayout(new BorderLayout());
        rtManagerPanel.add((Component)new JLabel(" " + JAMS.i18n((String)"Runtime_Manager") + ":"), "North");
        rtManagerPanel.add((Component)new RuntimeManagerPanel(), "Center");
        JSplitPane leftSplitPane = new JSplitPane();
        leftSplitPane.setAutoscrolls(true);
        leftSplitPane.setContinuousLayout(true);
        leftSplitPane.setOrientation(0);
        leftSplitPane.setTopComponent(this.libTreePanel);
        leftSplitPane.setBottomComponent(rtManagerPanel);
        JSplitPane mainSplitPane = new JSplitPane();
        mainSplitPane.setAutoscrolls(true);
        mainSplitPane.setContinuousLayout(true);
        mainSplitPane.setLeftComponent(leftSplitPane);
        mainSplitPane.setRightComponent(this.modelPanel);
        mainSplitPane.setDividerLocation(300);
        mainSplitPane.setOneTouchExpandable(true);
        mainSplitPane.setDividerSize(8);
        this.getContentPane().add((Component)mainSplitPane, "Center");
        JToolBar toolBar = new JToolBar();
        JButton modelNewButton = new JButton(this.newModelAction);
        modelNewButton.setText("");
        modelNewButton.setToolTipText(JAMS.i18n((String)"New_Model"));
        modelNewButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelNew.png")));
        toolBar.add(modelNewButton);
        JButton modelOpenButton = new JButton(this.loadModelAction);
        modelOpenButton.setText("");
        modelOpenButton.setToolTipText(JAMS.i18n((String)"Open_Model..."));
        modelOpenButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelOpen.png")));
        toolBar.add(modelOpenButton);
        JButton modelSaveButton = new JButton(this.saveModelAction);
        modelSaveButton.setText("");
        modelSaveButton.setToolTipText(JAMS.i18n((String)"Save_Model"));
        modelSaveButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelSave.png")));
        toolBar.add(modelSaveButton);
        toolBar.addSeparator();
        JButton searchButton = new JButton(this.searchAction);
        searchButton.setText("");
        searchButton.setToolTipText(JAMS.i18n((String)"Find..."));
        searchButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Search.png")));
        toolBar.add(searchButton);
        JButton prefsButton = new JButton(this.editPrefsAction);
        prefsButton.setText("");
        prefsButton.setToolTipText(JAMS.i18n((String)"Edit_Preferences..."));
        prefsButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/Preferences.png")));
        toolBar.add(prefsButton);
        JButton infoLogButton = new JButton(this.infoLogAction);
        infoLogButton.setText("");
        infoLogButton.setToolTipText(JAMS.i18n((String)"Show_Info_Log..."));
        infoLogButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/InfoLog.png")));
        toolBar.add(infoLogButton);
        JButton errorLogButton = new JButton(this.errorLogAction);
        errorLogButton.setText("");
        errorLogButton.setToolTipText(JAMS.i18n((String)"Show_Error_Log..."));
        errorLogButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ErrorLog.png")));
        toolBar.add(errorLogButton);
        toolBar.addSeparator();
        JButton modelRunButton = new JButton(this.runModelAction);
        modelRunButton.setText("");
        modelRunButton.setToolTipText(JAMS.i18n((String)"Run_Model"));
        modelRunButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelRun.png")));
        toolBar.add(modelRunButton);
        JButton modelGUIRunButton = new JButton(this.runModelFromLauncherAction);
        modelGUIRunButton.setText("");
        modelGUIRunButton.setToolTipText(JAMS.i18n((String)"Run_model_from_JAMS_Launcher"));
        modelGUIRunButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelRunLauncher.png")));
        toolBar.add(modelGUIRunButton);
        toolBar.addSeparator();
        JButton outputDSButton = new JButton(this.outputDSAction);
        outputDSButton.setText("");
        outputDSButton.setToolTipText(JAMS.i18n((String)"Model_output"));
        outputDSButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/DataOutput2.png")));
        toolBar.add(outputDSButton);
        JButton wsBrowseButton = new JButton(this.wsBrowseAction);
        wsBrowseButton.setText("");
        wsBrowseButton.setToolTipText(JAMS.i18n((String)"Browse_WS_Dir"));
        wsBrowseButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ws_browse.png")));
        toolBar.add(wsBrowseButton);
        JButton wsPrefsButton = new JButton(this.wsPrefsAction);
        wsPrefsButton.setText("");
        wsPrefsButton.setToolTipText(JAMS.i18n((String)"EDIT_WORKSPACE..."));
        wsPrefsButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ws_prefs.png")));
        toolBar.add(wsPrefsButton);
        JButton jadeButton = new JButton(this.jadeAction);
        jadeButton.setText("");
        jadeButton.setToolTipText(JAMS.i18n((String)"JADE"));
        jadeButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ws_jade.png")));
        toolBar.add(jadeButton);
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new BoxLayout(toolbarPanel, 0));
        this.jamsServerToolbar = new JAMSCloudToolbar(this, JUICE.getJamsProperties());
        toolbarPanel.add(toolBar);
        toolbarPanel.add(this.jamsServerToolbar);
        this.getContentPane().add((Component)toolbarPanel, "First");
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.setBorder(BorderFactory.createEtchedBorder());
        statusPanel.setPreferredSize(new Dimension(14, 20));
        this.statusLabel = new JLabel();
        this.statusLabel.setText(JAMS.i18n((String)"JAMS_Status"));
        statusPanel.add((Component)this.statusLabel, "Center");
        this.getContentPane().add((Component)statusPanel, "South");
        JMenuBar mainMenu = new JMenuBar();
        JMenu fileMenu = new JMenu(JAMS.i18n((String)"File"));
        mainMenu.add(fileMenu);
        JMenuItem newModelItem = new JMenuItem(this.newModelAction);
        newModelItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        fileMenu.add(newModelItem);
        JMenuItem loadModelItem = new JMenuItem(this.loadModelAction);
        loadModelItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        fileMenu.add(loadModelItem);
        this.recentMenu = new JMenu(JAMS.i18n((String)"Recent_Files"));
        this.updateRecentMenu();
        fileMenu.add(this.recentMenu);
        JMenuItem saveModelItem = new JMenuItem(this.saveModelAction);
        saveModelItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        fileMenu.add(saveModelItem);
        JMenuItem saveAsModelItem = new JMenuItem(this.saveAsModelAction);
        saveAsModelItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        fileMenu.add(saveAsModelItem);
        fileMenu.add(new JSeparator());
        JMenuItem remoteControlItem = new JMenuItem(this.remoteControlAction);
        remoteControlItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        fileMenu.add(remoteControlItem);
        JMenuItem exitItem = new JMenuItem(this.exitAction);
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        fileMenu.add(exitItem);
        JMenu extrasMenu = new JMenu(JAMS.i18n((String)"Edit"));
        mainMenu.add(extrasMenu);
        JMenuItem editPrefsItem = new JMenuItem(this.editPrefsAction);
        editPrefsItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        extrasMenu.add(editPrefsItem);
        JMenuItem loadPrefsItem = new JMenuItem(this.loadPrefsAction);
        extrasMenu.add(loadPrefsItem);
        JMenuItem savePrefsItem = new JMenuItem(this.savePrefsAction);
        extrasMenu.add(savePrefsItem);
        extrasMenu.add(new JSeparator());
        JMenuItem searchItem = new JMenuItem(this.searchAction);
        searchItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        extrasMenu.add(searchItem);
        this.modelMenu = new JMenu(JAMS.i18n((String)"Model"));
        this.modelMenu.setEnabled(false);
        mainMenu.add(this.modelMenu);
        JMenuItem runModelItem = new JMenuItem(this.runModelAction);
        this.runModelAction.setEnabled(false);
        runModelItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.modelMenu.add(runModelItem);
        JMenuItem runModelInLauncherItem = new JMenuItem(this.runModelFromLauncherAction);
        this.runModelFromLauncherAction.setEnabled(false);
        this.modelMenu.add(runModelInLauncherItem);
        this.modelMenu.add(new JSeparator());
        JMenuItem dsItem = new JMenuItem(this.outputDSAction);
        this.outputDSAction.setEnabled(false);
        dsItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.modelMenu.add(dsItem);
        JMenuItem jadeItem = new JMenuItem(this.jadeAction);
        this.jadeAction.setEnabled(false);
        jadeItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.modelMenu.add(jadeItem);
        JMenuItem browserItem = new JMenuItem(this.wsBrowseAction);
        this.wsBrowseAction.setEnabled(false);
        browserItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.modelMenu.add(browserItem);
        JMenuItem workspaceDlgItem = new JMenuItem(this.wsPrefsAction);
        this.wsPrefsAction.setEnabled(false);
        workspaceDlgItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.modelMenu.add(workspaceDlgItem);
        JMenuItem workspaceNewItem = new JMenuItem(this.wsCreateAction);
        this.wsCreateAction.setEnabled(false);
        this.modelMenu.add(workspaceNewItem);
        this.modelMenu.add(new JSeparator());
        JMenuItem loadModelParamItem = new JMenuItem(this.loadModelParamAction);
        this.modelMenu.add(loadModelParamItem);
        JMenuItem saveModelParamItem = new JMenuItem(this.saveModelParamAction);
        this.modelMenu.add(saveModelParamItem);
        this.modelMenu.add(new JSeparator());
        JMenuItem copyModelParameterItem = new JMenuItem(this.copyModelGUIAction);
        this.copyModelGUIAction.setEnabled(false);
        this.modelMenu.add(copyModelParameterItem);
        JMenuItem pasteModelParameterItem = new JMenuItem(this.pasteModelGUIAction);
        this.pasteModelGUIAction.setEnabled(false);
        this.modelMenu.add(pasteModelParameterItem);
        this.modelMenu.add(new JSeparator());
        this.OptimizationWizardItem = new JMenuItem(this.OptimizationWizardAction);
        this.OptimizationWizardAction.setEnabled(false);
        this.modelMenu.add(this.OptimizationWizardItem);
        this.ObjectiveWizardItem = new JMenuItem(this.ObjectiveWizardAction);
        this.ObjectiveWizardAction.setEnabled(false);
        this.modelMenu.add(this.ObjectiveWizardItem);
        this.modelMenu.add(new JSeparator());
        JMenuItem GenerateDocumentationItem = new JMenuItem(this.GenerateDocumentationGUIAction);
        this.GenerateDocumentationGUIAction.setEnabled(true);
        this.modelMenu.add(GenerateDocumentationItem);
        JMenu logsMenu = new JMenu(JAMS.i18n((String)"Logs"));
        mainMenu.add(logsMenu);
        JMenuItem infoLogItem = new JMenuItem(this.infoLogAction);
        logsMenu.add(infoLogItem);
        JMenuItem errorLogItem = new JMenuItem(this.errorLogAction);
        logsMenu.add(errorLogItem);
        this.windowMenu = new JMenu(JAMS.i18n((String)"Windows"));
        this.windowMenu.setEnabled(false);
        ModelView.viewList.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                JUICEFrame.this.windowMenu.removeAll();
                ArrayList<ModelView> mViews = ModelView.viewList.getViewList();
                for (int i = 0; i < mViews.size(); ++i) {
                    JInternalFrame frame = mViews.get(i).getFrame();
                    WindowItem windowItem = new WindowItem(frame.getTitle(), frame);
                    windowItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WindowItem item = (WindowItem)e.getSource();
                            try {
                                item.frame.setSelected(true);
                            }
                            catch (PropertyVetoException pve) {
                                JAMSTools.handle((Throwable)pve);
                            }
                        }
                    });
                    JUICEFrame.this.windowMenu.add(windowItem);
                }
                if (mViews.size() == 0) {
                    JUICEFrame.this.windowMenu.setEnabled(false);
                    return;
                }
                JUICEFrame.this.windowMenu.setEnabled(true);
            }
        });
        mainMenu.add(this.windowMenu);
        JMenu helpMenu = new JMenu(JAMS.i18n((String)"Help"));
        mainMenu.add(helpMenu);
        JMenuItem onlineItem = new JMenuItem(this.onlineAction);
        helpMenu.add(onlineItem);
        JMenuItem aboutItem = new JMenuItem(this.aboutAction);
        helpMenu.add(aboutItem);
        ModelView.viewList.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (ModelView.viewList.getViewList().size() > 0) {
                    JUICEFrame.this.modelMenu.setEnabled(true);
                    JUICEFrame.this.saveModelAction.setEnabled(true);
                    JUICEFrame.this.outputDSAction.setEnabled(true);
                    JUICEFrame.this.runModelAction.setEnabled(true);
                    JUICEFrame.this.runModelFromLauncherAction.setEnabled(true);
                    JUICEFrame.this.jadeAction.setEnabled(true);
                    JUICEFrame.this.wsBrowseAction.setEnabled(true);
                    JUICEFrame.this.wsPrefsAction.setEnabled(true);
                    JUICEFrame.this.wsCreateAction.setEnabled(true);
                    JUICEFrame.this.copyModelGUIAction.setEnabled(true);
                    JUICEFrame.this.saveAsModelAction.setEnabled(true);
                    JUICEFrame.this.OptimizationWizardAction.setEnabled(true);
                    JUICEFrame.this.ObjectiveWizardAction.setEnabled(true);
                } else {
                    JUICEFrame.this.modelMenu.setEnabled(false);
                    JUICEFrame.this.outputDSAction.setEnabled(false);
                    JUICEFrame.this.runModelAction.setEnabled(false);
                    JUICEFrame.this.runModelFromLauncherAction.setEnabled(false);
                    JUICEFrame.this.jadeAction.setEnabled(false);
                    JUICEFrame.this.wsBrowseAction.setEnabled(false);
                    JUICEFrame.this.wsPrefsAction.setEnabled(false);
                    JUICEFrame.this.wsCreateAction.setEnabled(false);
                    JUICEFrame.this.copyModelGUIAction.setEnabled(false);
                    JUICEFrame.this.pasteModelGUIAction.setEnabled(false);
                    JUICEFrame.this.saveModelAction.setEnabled(false);
                    JUICEFrame.this.saveAsModelAction.setEnabled(false);
                }
            }
        });
        this.setJMenuBar(mainMenu);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int height = Math.min((int)((double)d.height * 0.95), 1000);
        int width = Math.min((int)((double)d.width * 0.95), 1400);
        this.setSize(width, height);
        leftSplitPane.setDividerLocation((int)((double)height * 0.7));
        this.libTreePanel.requestFocus();
    }

    public void setLibTree(LibTree tree) {
        this.libTreePanel.setTree(tree);
    }

    public void newModel() {
        SwingWorker w = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ModelView mView = new ModelView(JUICEFrame.this.modelPanel);
                mView.setTree(new ModelTree(mView, null));
                mView.setInitialState();
                mView.getFrame().setVisible(true);
                mView.getFrame().requestFocus();
                return mView;
            }
        };
        w.execute();
    }

    public void newModel(final Document doc) {
        SwingWorker w = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ModelView mView = new ModelView(JUICEFrame.this.modelPanel);
                mView.setTree(new ModelTree(mView, null));
                mView.setInitialState();
                mView.getFrame().setVisible(true);
                mView.getFrame().requestFocus();
                mView.setTree(new ModelTree(mView, doc));
                return mView;
            }
        };
        w.execute();
    }

    public void loadModel(String path) {
        File f = new File(path);
        if (f.exists()) {
            try {
                this.modelPath = f.getCanonicalPath();
            }
            catch (IOException ex) {
                GUIHelper.showErrorDlg((Component)this, (String)ex.toString(), (String)JAMS.i18n((String)"File_Open_Error"));
            }
            this.loadModel();
        } else {
            GUIHelper.showErrorDlg((Component)this, (String)(JAMS.i18n((String)"File_") + path + JAMS.i18n((String)"_does_not_exist")), (String)JAMS.i18n((String)"File_Open_Error"));
        }
    }

    private void loadModel() {
        this.loadModelDlg.setTask(new Runnable(){

            @Override
            public void run() {
                boolean isCurrentFrameMaximized = true;
                if (JUICEFrame.this.modelPanel.getSelectedFrame() != null) {
                    isCurrentFrameMaximized = JUICEFrame.this.modelPanel.getSelectedFrame().isMaximum();
                }
                String path = JUICEFrame.this.modelPath;
                ModelView mView = new ModelView(path, JUICEFrame.this.modelPanel);
                mView.loadModel(path);
                mView.getFrame().setVisible(true);
                mView.getFrame().requestFocus();
                if (isCurrentFrameMaximized) {
                    try {
                        mView.getFrame().setMaximum(true);
                    }
                    catch (PropertyVetoException ex) {
                        Logger.getLogger(JUICE.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                JAMSTools.addToRecentFiles((SystemProperties)JUICE.getJamsProperties(), (String)"recentfiles", (String)path);
                JUICEFrame.this.updateRecentMenu();
            }
        });
        this.loadModelDlg.execute();
    }

    private void saveModelAs(ModelView view) {
        if (view.getSavePath() != null) {
            this.jfcModels.setSelectedFile(view.getSavePath());
        } else {
            this.jfcModels.setSelectedFile(new File(""));
        }
        int result = this.jfcModels.showSaveDialog(this);
        if (result == 0) {
            String path = this.jfcModels.getSelectedFile().getAbsolutePath();
            File savePath = new File(path);
            view.setSavePath(savePath);
            this.saveModel(view);
            JAMSTools.addToRecentFiles((SystemProperties)JUICE.getJamsProperties(), (String)"recentfiles", (String)path);
        }
    }

    public void saveModel(ModelView view) {
        if (view.getSavePath() != null) {
            if (!view.save()) {
                GUIHelper.showErrorDlg((Component)this, (String)(JAMS.i18n((String)"Error_saving_model_to_") + view.getSavePath() + "\""), (String)JAMS.i18n((String)"Error"));
                view.setSavePath(null);
            } else {
                view.setInitialState();
            }
        } else {
            this.saveModelAs(view);
        }
    }

    public void loadModel(ModelView view) {
        if (view != null && view.getSavePath() != null) {
            this.jfcModels.setSelectedFile(this.getCurrentView().getSavePath());
        } else {
            this.jfcModels.setSelectedFile(new File(""));
        }
        int result = this.jfcModels.showOpenDialog(this);
        if (result == 0) {
            this.loadModel(this.jfcModels.getSelectedFile().getAbsolutePath());
        }
    }

    public ModelView getCurrentView() {
        if (this.modelPanel.getAllFrames().length == 0) {
            return null;
        }
        JInternalFrame frame = this.modelPanel.getSelectedFrame();
        ModelView view = ModelView.viewList.getMViews().get(frame);
        return view;
    }

    public TreePanel getLibTreePanel() {
        return this.libTreePanel;
    }

    public Action getJADEAction() {
        return this.jadeAction;
    }

    public JLabel getStatusLabel() {
        return this.statusLabel;
    }

    public void setStatusLabel(JLabel statusLabel) {
        this.statusLabel = statusLabel;
    }

    public LogViewDlg getInfoDlg() {
        return this.infoDlg;
    }

    public LogViewDlg getErrorDlg() {
        return this.errorDlg;
    }

    private void exit() {
        ModelView[] views;
        for (ModelView view : views = ModelView.viewList.getViewList().toArray(new ModelView[ModelView.viewList.getViewList().size()])) {
            if (view.exit()) continue;
            return;
        }
        if (ModelView.viewList.getViewList().isEmpty()) {
            try {
                JUICE.getJamsProperties().save();
            }
            catch (IOException ioe) {
                JAMSTools.handle((Throwable)ioe);
            }
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        }
    }

    private void updateRecentMenu() {
        String[] recentFiles;
        this.recentMenu.removeAll();
        for (String fileName : recentFiles = JAMSTools.getRecentFiles((SystemProperties)JUICE.getJamsProperties(), (String)"recentfiles")) {
            AbstractAction openAction = new AbstractAction(fileName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JUICEFrame.this.loadModel(this.getValue("Name").toString());
                }
            };
            JMenuItem recentItem = new JMenuItem(openAction);
            this.recentMenu.add(recentItem);
        }
    }

    private class WindowItem
    extends JMenuItem {
        JInternalFrame frame;

        public WindowItem(String title, JInternalFrame frame) {
            super(title);
            this.frame = frame;
        }
    }
}

