/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.JAMSLogging;
import jams.SystemProperties;
import jams.gui.tools.GUIHelper;
import jams.server.client.Controller;
import jams.server.client.gui.BrowseJAMSCloudDlg;
import jams.server.client.gui.JAMSCloudGraphicalController;
import jams.server.client.gui.SynchronizeDlg;
import jams.server.entities.Job;
import jams.server.entities.WorkspaceFileAssociation;
import jams.tools.XMLTools;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import jamsui.juice.JUICE;
import jamsui.juice.gui.JUICEFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import org.w3c.dom.Document;

public class JAMSCloudToolbar
extends JToolBar {
    private Logger log = Logger.getLogger(JAMSCloudToolbar.class.getName());
    private JUICEFrame juiceFrame;
    private SystemProperties properties = null;
    private JButton connectButton;
    private JButton wsCloudButton;
    private JButton runCloudButton;
    private JButton wsSyncButton;
    private JProgressBar serverLoad = new JProgressBar();
    private ImageIcon connect1 = new ImageIcon(this.getClass().getResource("/resources/images/connect1_b.png"));
    private ImageIcon connect2 = new ImageIcon(this.getClass().getResource("/resources/images/connect2_b.png"));
    private ImageIcon connect3 = new ImageIcon(this.getClass().getResource("/resources/images/connect3_b.png"));
    private JAMSCloudGraphicalController connector = null;
    private static BrowseJAMSCloudDlg jamsCloudBrowser = null;
    private Action wsCloudAction = new AbstractAction(JAMS.i18n((String)"Browse_WS_Cloud")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAMSCloudToolbar.this.openWSCloud();
        }
    };
    private Action runCloudAction = new AbstractAction(JAMS.i18n((String)"Run_Model_Remote")){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JAMSCloudToolbar.this.runModelInCloud();
            }
            catch (IOException ioe) {
                JAMSCloudToolbar.this.log.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
    };
    private Action wsSyncAction = new AbstractAction(JAMS.i18n((String)"Sync_WS_Cloud")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAMSCloudToolbar.this.syncWorkspace();
        }
    };

    public JAMSCloudToolbar(JUICEFrame jf, SystemProperties p) {
        JAMSLogging.registerLogger((JAMSLogging.LogOption)JAMSLogging.LogOption.Show, (Logger)this.log);
        this.juiceFrame = jf;
        this.properties = p;
        this.wsCloudButton = new JButton(this.wsCloudAction);
        this.wsCloudButton.setText("");
        this.wsCloudButton.setToolTipText(JAMS.i18n((String)"Browse_WS_Cloud"));
        this.wsCloudButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ws_cloud2.png")));
        this.runCloudButton = new JButton(this.runCloudAction);
        this.runCloudButton.setText("");
        this.runCloudButton.setToolTipText(JAMS.i18n((String)"Run_Model_Remote"));
        this.runCloudButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelRunCloud.png")));
        this.wsSyncButton = new JButton(this.wsSyncAction);
        this.wsSyncButton.setText("");
        this.wsSyncButton.setToolTipText(JAMS.i18n((String)"Sync_WS_Cloud"));
        this.wsSyncButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ws_sync.png")));
        this.connectButton = new JButton();
        this.connectButton.setText("");
        this.connectButton.setToolTipText(JAMS.i18n((String)"Connect_to_Cloud"));
        this.serverLoad.setMaximumSize(new Dimension(200, 21));
        this.serverLoad.setPreferredSize(new Dimension(200, 21));
        this.add(this.connectButton);
        this.add(this.serverLoad);
        this.add(this.runCloudButton);
        this.add(this.wsCloudButton);
        this.add(this.wsSyncButton);
        this.serverLoad.setIndeterminate(false);
        this.connector = JAMSCloudGraphicalController.createInstance((Window)jf, (SystemProperties)this.properties);
        this.connector.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                JAMSCloudToolbar.this.setConnectionState((JAMSCloudGraphicalController.JAMSCloudEvents)arg);
            }
        });
        if (this.connector.isConnected()) {
            this.setConnectionState(JAMSCloudGraphicalController.JAMSCloudEvents.CONNECT);
        } else {
            this.setConnectionState(JAMSCloudGraphicalController.JAMSCloudEvents.DISCONNECT);
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (JAMSCloudToolbar.this.connector != null && JAMSCloudToolbar.this.connector.isConnected()) {
                        double load = JAMSCloudToolbar.this.connector.getClient().getLoad();
                        JAMSCloudToolbar.this.setLoad(load);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 5000L, 5000L);
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JAMSCloudToolbar.this.connector.isConnected()) {
                    JAMSCloudToolbar.this.connector.disconnect();
                } else {
                    try {
                        JAMSCloudToolbar.this.connector.reconnect();
                    }
                    catch (IOException ioe) {
                        JAMSCloudToolbar.this.log.log(Level.SEVERE, ioe.toString(), ioe);
                    }
                }
            }
        });
    }

    protected void setConnectionState(JAMSCloudGraphicalController.JAMSCloudEvents event) {
        switch (event) {
            case CONNECT: {
                if (!this.connector.isConnected()) break;
                this.serverLoad.setEnabled(true);
                this.wsCloudAction.setEnabled(true);
                this.runCloudAction.setEnabled(true);
                this.wsSyncAction.setEnabled(true);
                this.setServerUrl(this.connector.getServerUrl());
                this.connectButton.setIcon(this.connect3);
                break;
            }
            case CONNECTING: {
                this.setServerUrl("");
                this.setLoad(0.0);
                this.serverLoad.setEnabled(false);
                this.wsCloudAction.setEnabled(false);
                this.runCloudAction.setEnabled(false);
                this.wsSyncAction.setEnabled(false);
                this.connectButton.setIcon(this.connect2);
                break;
            }
            case DISCONNECT: {
                this.setServerUrl("");
                this.setLoad(0.0);
                this.serverLoad.setEnabled(false);
                this.wsCloudAction.setEnabled(false);
                this.runCloudAction.setEnabled(false);
                this.wsSyncAction.setEnabled(false);
                this.connectButton.setIcon(this.connect1);
                break;
            }
        }
    }

    protected void setLoad(double load) {
        this.serverLoad.setToolTipText("Server Load: " + String.format("%.2f", load));
        load = Math.min(load, 1.0);
        Color c = new Color((float)load, 1.0f - (float)load, 0.0f);
        this.serverLoad.setBackground(c);
        this.serverLoad.setForeground(c);
        this.serverLoad.getModel().setValue((int)(load * 100.0));
    }

    protected void setServerUrl(String url) {
        if (url.length() > 30) {
            url = url.substring(url.indexOf("://") + 3);
            if ((url = url.substring(0, url.indexOf("/"))).length() > 30) {
                url = url.substring(0, 30) + "...";
            }
        }
        this.serverLoad.setString(url);
        this.serverLoad.setStringPainted(true);
    }

    protected void syncWorkspace() {
        try {
            if (this.juiceFrame.getCurrentView() == null) {
                return;
            }
            JAMSWorkspace wslocal = this.juiceFrame.getCurrentView().getWorkspace();
            wslocal.loadConfig();
            SynchronizeDlg dlg = new SynchronizeDlg((Window)this.juiceFrame, (Workspace)wslocal, this.properties);
            dlg.setPreferredSize(new Dimension(640, 480));
            GUIHelper.centerOnParent((Window)dlg, (boolean)true);
            dlg.setVisible(true);
        }
        catch (IOException ioe) {
            this.log.log(Level.SEVERE, ioe.toString(), ioe);
        }
    }

    public void openWSCloud() {
        if (jamsCloudBrowser == null) {
            jamsCloudBrowser = new BrowseJAMSCloudDlg((Window)this.juiceFrame, this.properties);
            jamsCloudBrowser.init();
            jamsCloudBrowser.setDefaultCloseOperation(2);
        }
        GUIHelper.centerOnParent((Window)jamsCloudBrowser, (boolean)true);
        jamsCloudBrowser.setVisible(true);
    }

    public Job runModelInCloud() throws IOException {
        Controller client = this.connector.getClient();
        if (this.juiceFrame.getCurrentView() == null) {
            return null;
        }
        JAMSWorkspace jamsWorkspace = this.juiceFrame.getCurrentView().getWorkspace();
        String libs = this.properties.getProperty("libs");
        String newLibs = "";
        String[] compLibArray = libs.split(";");
        File[] compLibFile = new File[compLibArray.length];
        for (int i = 0; i < compLibArray.length; ++i) {
            compLibFile[i] = new File(compLibArray[i]);
            newLibs = newLibs + "components/" + i + "/" + compLibFile[i].getName() + ";";
        }
        newLibs = newLibs.substring(0, newLibs.length() - 1);
        File libDir = JAMS.getLibDir();
        String uploadFileFilter = this.properties.getProperty("uploadFileFilter");
        if (uploadFileFilter == null) {
            uploadFileFilter = "(.*\\.cache)|(.*\\.ser)|(.*\\.svn)|(.*/output/.*)|(.*/documentation/.*)|(.*\\.cdat)|(.*\\.log)";
        }
        jamsWorkspace.loadConfig();
        String title = jamsWorkspace.getTitle();
        jams.server.entities.Workspace ws = null;
        if (title == null || title.isEmpty()) {
            title = JOptionPane.showInputDialog(this.juiceFrame, JAMS.i18n((String)"The_workspace_you_are_going_to_upload_has_no_name"), JAMS.i18n((String)"Name_of_workspace"), 3);
            if (title == null) {
                title = "unnamed";
            } else {
                jamsWorkspace.setTitle(title);
            }
        }
        if ((ws = this.connector.uploadWorkspace((Workspace)jamsWorkspace, compLibFile, libDir, uploadFileFilter)) == null) {
            return null;
        }
        jamsWorkspace.setID(ws.getId().intValue());
        InputStream inputStream = XMLTools.writeXmlToStream((Document)this.juiceFrame.getCurrentView().getModelDoc());
        jams.server.entities.File f = client.files().uploadFile(inputStream);
        ws = client.workspaces().attachFile(ws, new WorkspaceFileAssociation(ws, f, 2, this.juiceFrame.getCurrentView().getSavePath().getName()));
        Properties props = (Properties)JUICE.getJamsProperties().getProperties().clone();
        props.setProperty("libs", newLibs);
        props.setProperty("progressperiod", "1000");
        props.setProperty("progressfilename", "progress.log");
        inputStream = XMLTools.propertiesToStream((Properties)props);
        f = client.files().uploadFile(inputStream);
        ws = client.workspaces().attachFile(ws, new WorkspaceFileAssociation(ws, f, 8, "cloud.jap"));
        return this.connector.startJob(ws, new File(this.juiceFrame.getCurrentView().getSavePath().getName()));
    }
}

