/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.data.JAMSString;
import jams.gui.input.InputComponent;
import jams.gui.input.InputComponentFactory;
import jams.gui.tools.GUIHelper;
import jamsui.juice.JUICE;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ContextAttributeDlg
extends JDialog {
    public static final int APPROVE_OPTION = 1;
    public static final int CANCEL_OPTION = 0;
    private int result = 0;
    private JTextField nameText;
    private JComboBox typeCombo;
    private InputComponent valueInput;
    private JPanel mainPanel;
    private GridBagLayout mainLayout;
    private HashMap<String, Class> classMap = new HashMap();

    public ContextAttributeDlg(Frame owner) {
        super(owner);
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(owner);
        this.setDefaultCloseOperation(1);
        this.setModal(true);
        this.mainLayout = new GridBagLayout();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(this.mainLayout);
        GUIHelper.addGBComponent((Container)this.mainPanel, (GridBagLayout)this.mainLayout, (Component)new JPanel(), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.mainPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Name:")), (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.mainPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Type:")), (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.mainPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Value:")), (int)0, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
        this.nameText = new JTextField();
        this.nameText.setColumns(40);
        this.valueInput = InputComponentFactory.createInputComponent(JAMSString.class, (boolean)true);
        this.typeCombo = new JComboBox();
        String[] typeNames = new String[JUICE.JAMS_DATA_TYPES.length];
        for (int i = 0; i < JUICE.JAMS_DATA_TYPES.length; ++i) {
            typeNames[i] = JUICE.JAMS_DATA_TYPES[i].getSimpleName();
            this.classMap.put(typeNames[i], JUICE.JAMS_DATA_TYPES[i]);
        }
        this.typeCombo.setModel(new DefaultComboBoxModel<String>(typeNames));
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ContextAttributeDlg.this.updateInputComponent((Class)ContextAttributeDlg.this.classMap.get((String)e.getItem()), true);
                }
            }
        });
        GUIHelper.addGBComponent((Container)this.mainPanel, (GridBagLayout)this.mainLayout, (Component)this.nameText, (int)1, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.mainPanel, (GridBagLayout)this.mainLayout, (Component)this.typeCombo, (int)1, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.mainPanel, (GridBagLayout)this.mainLayout, (Component)this.valueInput.getComponent(), (int)1, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.mainPanel, (GridBagLayout)this.mainLayout, (Component)new JPanel(), (int)0, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
        this.getContentPane().add((Component)new JScrollPane(this.mainPanel), "Center");
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton(JAMS.i18n((String)"OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ContextAttributeDlg.this.valueInput.verify()) {
                    ContextAttributeDlg.this.valueInput.setMarked(true);
                    GUIHelper.showErrorDlg((Component)ContextAttributeDlg.this, (String)JAMS.i18n((String)"Invalid_value!"), (String)JAMS.i18n((String)"Format_error"));
                    ContextAttributeDlg.this.valueInput.setMarked(false);
                    return;
                }
                ContextAttributeDlg.this.setVisible(false);
                ContextAttributeDlg.this.result = 1;
            }
        });
        buttonPanel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(JAMS.i18n((String)"Cancel"));
        ActionListener cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContextAttributeDlg.this.setVisible(false);
                ContextAttributeDlg.this.result = 0;
            }
        };
        cancelButton.addActionListener(cancelActionListener);
        cancelButton.registerKeyboardAction(cancelActionListener, KeyStroke.getKeyStroke(27, 0), 2);
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private void updateInputComponent(Class type, boolean doUpdate) {
        String oldValue = "";
        if (this.valueInput != null) {
            GUIHelper.removeGBComponent((Container)this.mainPanel, (Component)this.valueInput.getComponent());
            oldValue = this.valueInput.getValue();
        }
        this.valueInput = InputComponentFactory.createInputComponent((Class)type, (boolean)true);
        if (doUpdate) {
            this.valueInput.setValue(oldValue);
        }
        GUIHelper.addGBComponent((Container)this.mainPanel, (GridBagLayout)this.mainLayout, (Component)this.valueInput.getComponent(), (int)1, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
        this.pack();
    }

    public void show(String name, Class type, String value) {
        this.setTitle(JAMS.i18n((String)"Attribute:_") + name);
        this.updateInputComponent(type, false);
        this.valueInput.setValue(value);
        this.typeCombo.setSelectedItem(type.getSimpleName());
        this.nameText.setText(name);
        this.pack();
        this.setVisible(true);
    }

    public String getAttributeName() {
        return this.nameText.getText();
    }

    public String getValue() {
        return this.valueInput.getValue();
    }

    public Class getAttributeType() {
        return this.classMap.get((String)this.typeCombo.getSelectedItem());
    }

    public int getResult() {
        return this.result;
    }
}

