/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice.gui;

import jams.JAMS;
import jams.gui.tools.GUIHelper;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.text.SimpleAttributeSet;

public class ComponentInfoDlg
extends JDialog {
    private static final String DEFAULT_STRING = JAMS.i18n((String)"[none]");
    private static final int TEXTAREA_WIDTH = 295;
    private static final int GRIDBAG_MAX_Y = 3;
    private HashMap<String, JTextField> textFields = new HashMap();
    private HashMap<String, JTextPane> textAreas = new HashMap();
    private SimpleAttributeSet descriptionText;
    private JPanel contentPanel;
    private GridBagLayout mainLayout;
    private ArrayList<JPanel> varPanels = new ArrayList();
    private JLabel varLabel = new JLabel(JAMS.i18n((String)"Variables:"));
    private static HashMap<Class, JDialog> compViewDlgs = new HashMap();

    public ComponentInfoDlg(Frame owner, Class clazz) {
        super(owner);
        this.setLocationByPlatform(true);
        this.setTitle(clazz.getCanonicalName());
        this.setDefaultCloseOperation(2);
        this.contentPanel = new JPanel();
        this.mainLayout = new GridBagLayout();
        this.contentPanel.setLayout(this.mainLayout);
        GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Type:")), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Author:")), (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Date:")), (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)new JLabel(JAMS.i18n((String)"Description:")), (int)0, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)this.getTextField("type", ""), (int)1, (int)0, (int)1, (int)1, (double)1.0, (double)1.0);
        GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)this.getTextField("author", ""), (int)1, (int)1, (int)1, (int)1, (double)1.0, (double)1.0);
        GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)this.getTextField("date", ""), (int)1, (int)2, (int)1, (int)1, (double)1.0, (double)1.0);
        GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)this.getTextPane("description", "", 140), (int)1, (int)3, (int)1, (int)1, (double)1.0, (double)1.0);
        this.reset(DEFAULT_STRING);
        this.add(new JScrollPane(this.contentPanel));
        JAMSComponentDescription jcd = clazz.getAnnotation(JAMSComponentDescription.class);
        if (jcd != null) {
            this.update(clazz.getCanonicalName(), jcd);
        } else {
            this.reset(clazz.getCanonicalName());
        }
        this.update(clazz.getFields());
        this.setPreferredSize(new Dimension(450, 600));
        this.pack();
    }

    public JScrollPane getTextPane(String key, String value, int height) {
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/plain");
        textPane.setEditable(false);
        textPane.setText(value);
        JScrollPane scroll = new JScrollPane(textPane);
        scroll.setPreferredSize(new Dimension(295, height));
        this.textAreas.put(key, textPane);
        return scroll;
    }

    public JTextField getTextField(String key, String value) {
        JTextField text = new JTextField();
        text.setEditable(false);
        text.setText(value);
        this.textFields.put(key, text);
        return text;
    }

    private void update(String clazz, JAMSComponentDescription jcd) {
        this.textFields.get("type").setText(clazz);
        this.textFields.get("author").setText(jcd.author());
        this.textFields.get("date").setText(jcd.date());
        this.textAreas.get("description").setText(jcd.description());
    }

    private void update(Field[] compFields) {
        int pos = 4;
        for (JPanel p : this.varPanels) {
            this.contentPanel.remove(p);
        }
        this.contentPanel.remove(this.varLabel);
        if (compFields.length > 0) {
            GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)this.varLabel, (int)0, (int)pos++, (int)1, (int)1, (double)0.0, (double)0.0);
        }
        for (Field field : compFields) {
            JAMSVarDescription jvd = field.getAnnotation(JAMSVarDescription.class);
            if (jvd == null) continue;
            JPanel fieldPanel = new JPanel();
            this.varPanels.add(fieldPanel);
            TitledBorder border = BorderFactory.createTitledBorder(field.getName());
            border.setTitleFont(border.getTitleFont().deriveFont(1));
            fieldPanel.setBorder(border);
            GUIHelper.addGBComponent((Container)this.contentPanel, (GridBagLayout)this.mainLayout, (Component)fieldPanel, (int)0, (int)pos++, (int)2, (int)1, (double)0.0, (double)0.0);
            GridBagLayout fieldLayout = new GridBagLayout();
            fieldPanel.setLayout(fieldLayout);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)new JLabel(JAMS.i18n((String)"Type:")), (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)new JLabel(JAMS.i18n((String)"Access:")), (int)0, (int)1, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)new JLabel(JAMS.i18n((String)"Description:")), (int)0, (int)3, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)new JLabel(JAMS.i18n((String)"Unit:")), (int)0, (int)4, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)new JLabel(JAMS.i18n((String)"Default:")), (int)0, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)this.getTextField("", field.getType().getName()), (int)1, (int)0, (int)1, (int)1, (double)1.0, (double)1.0);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)this.getTextField("", jvd.access().toString()), (int)1, (int)1, (int)1, (int)1, (double)1.0, (double)1.0);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)this.getTextPane("", jvd.description(), 70), (int)1, (int)3, (int)1, (int)1, (double)1.0, (double)1.0);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)this.getTextField("", jvd.unit()), (int)1, (int)4, (int)1, (int)1, (double)1.0, (double)1.0);
            GUIHelper.addGBComponent((Container)fieldPanel, (GridBagLayout)fieldLayout, (Component)this.getTextField("", jvd.defaultValue().equals("%NULL%") ? "" : jvd.defaultValue()), (int)1, (int)5, (int)1, (int)1, (double)1.0, (double)1.0);
        }
    }

    public void reset(String clazz) {
        for (JTextField jTextField : this.textFields.values()) {
            jTextField.setText(DEFAULT_STRING);
        }
        for (JEditorPane jEditorPane : this.textAreas.values()) {
            jEditorPane.setText(DEFAULT_STRING);
        }
        this.textFields.get("type").setText(clazz);
    }

    public static void displayMetadataDlg(Frame owner, Class clazz) {
        if (clazz != null) {
            if (compViewDlgs.containsKey(clazz)) {
                compViewDlgs.get(clazz).setVisible(true);
                return;
            }
            ComponentInfoDlg compViewDlg = new ComponentInfoDlg(owner, clazz);
            compViewDlgs.put(clazz, compViewDlg);
            compViewDlg.setVisible(true);
        }
    }
}

