/*
 * Decompiled with CFR 0.152.
 */
package jamsui.juice;

import jams.JAMS;
import jams.JAMSLogging;
import jams.JAMSProperties;
import jams.SystemProperties;
import jams.data.Attribute;
import jams.gui.WorkerDlg;
import jams.gui.tools.GUIHelper;
import jams.meta.ComponentCollection;
import jams.runtime.JAMSClassLoader;
import jams.runtime.RuntimeLogger;
import jams.tools.JAMSTools;
import jams.tools.StringTools;
import jamsui.cmdline.JAMSCmdLine;
import jamsui.juice.gui.JUICEFrame;
import jamsui.juice.gui.ModelView;
import jamsui.juice.gui.tree.LibTree;
import jamsui.launcher.JAMSui;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JUICE {
    public static final String APP_TITLE = "JAMS Builder";
    public static final Class[] JAMS_DATA_TYPES = JUICE.getJAMSDataClasses();
    public static final int SCREEN_WIDTH = 1400;
    public static final int SCREEN_HEIGHT = 1000;
    private static JUICEFrame juiceFrame;
    private static SystemProperties jamsProperties;
    private static ArrayList<ModelView> modelViews;
    private static ClassLoader loader;
    private static JAMSCmdLine cmdLine;
    private static LibTree libTree;
    private static WorkerDlg loadLibsDlg;

    public static void main(String[] args) {
        File file;
        String vmArch;
        String osArch;
        int result;
        boolean vm64;
        boolean os64 = JAMSTools.is64Bit();
        if (os64 != (vm64 = System.getProperty("os.arch").endsWith("64")) && (result = GUIHelper.showYesNoDlg(null, (String)String.format("Architectures of OS (%s) and Java VM (%s) used with JAMS seem to differ.\nYou should update your Java VM to a matching version to avoid strange model behaviour.\nContinue anyway?", osArch = os64 ? "64 bit" : "32 bit", vmArch = vm64 ? "64 bit" : "32 bit"), (String)"Warning")) == 1) {
            System.exit(0);
        }
        JAMSLogging.getInstance().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                List loggers = JAMSLogging.getLoggers();
                Logger logger = (Logger)arg;
                JAMSLogging.LogOption option = JAMSLogging.getLogOption((Logger)logger);
                if (loggers.contains(logger)) {
                    JAMSui.registerLogger(option, logger);
                } else {
                    JAMSui.unregisterLogger(option, logger);
                }
            }
        });
        cmdLine = new JAMSCmdLine(args, APP_TITLE);
        jamsProperties = JAMSProperties.createProperties();
        String fileName = null;
        try {
            if (cmdLine.getConfigFileName() != null) {
                fileName = cmdLine.getConfigFileName();
                JAMS.initBaseDir((String)fileName);
                jamsProperties.load(fileName);
            } else {
                JAMS.initBaseDir();
                file = new File(JAMS.getBaseDir(), "default.jap");
                if (file.exists()) {
                    fileName = file.getAbsolutePath();
                    jamsProperties.load(fileName);
                }
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(JUICE.class.getName()).log(Level.SEVERE, JAMS.i18n((String)"Error_while_loading_config_from") + fileName, ioe);
        }
        try {
            if (cmdLine.getConfigFileName() != null) {
                JUICE.getJamsProperties().load(cmdLine.getConfigFileName());
            } else {
                file = new File(JAMS.getBaseDir(), "default.jap");
                if (file.exists()) {
                    JUICE.getJamsProperties().load(file.getAbsolutePath());
                }
            }
            JAMSTools.configureLocaleEncoding((SystemProperties)JUICE.getJamsProperties());
            String floatFormat = JUICE.getJamsProperties().getProperty("floatformat", "%f");
            JAMS.setFloatFormat((String)floatFormat);
            JUICE.createJUICEFrame(null);
            if (cmdLine.getModelFileName() != null) {
                juiceFrame.loadModel(cmdLine.getModelFileName());
            }
        }
        catch (Throwable t) {
            StackTraceElement[] st;
            String s = "";
            for (StackTraceElement ste : st = t.getStackTrace()) {
                s = s + "        at " + ste.toString() + "\n";
            }
            System.out.println(JAMS.i18n((String)"JUICE_Error") + "\n" + t.toString() + "\n" + s);
            GUIHelper.showErrorDlg((Component)JUICE.getJuiceFrame(), (String)(JAMS.i18n((String)"An_error_occured_during_JUICE_execution") + t.toString() + "\n" + s), (String)JAMS.i18n((String)"JUICE_Error"));
        }
    }

    public static void createJUICEFrame(SystemProperties p) {
        if (p != null) {
            jamsProperties = p;
        }
        String desiredLookAndFeel = JUICE.getJamsProperties().getProperty("lookandfeel");
        try {
            boolean successful = false;
            if (desiredLookAndFeel != null) {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!desiredLookAndFeel.equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    successful = true;
                    break;
                }
            }
            if (!successful) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception lnfe) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception ex) {
                JAMSTools.handle((Throwable)ex);
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    juiceFrame = new JUICEFrame();
                    juiceFrame.setVisible(true);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException ex) {
            JAMSTools.handle((Throwable)ex);
        }
        int maxLibClasses = Integer.parseInt(JUICE.getJamsProperties().getProperty("maxlibclasses"));
        libTree = new LibTree(new ComponentCollection(), maxLibClasses);
        JUICE.updateLibs();
        juiceFrame.setLibTree(libTree);
        JUICE.getJamsProperties().addObserver("libs", new Observer(){

            @Override
            public void update(Observable obs, Object obj) {
                JUICE.updateLibs();
            }
        });
    }

    public static void updateLibs() {
        if (loadLibsDlg == null) {
            loadLibsDlg = new WorkerDlg((Window)juiceFrame, JAMS.i18n((String)"Loading_Libraries"));
        }
        try {
            loadLibsDlg.setTask(new Runnable(){

                @Override
                public void run() {
                    JUICE.getJuiceFrame().getLibTreePanel().setEnabled(false);
                    JUICE.createClassLoader();
                    JUICE.getLibTree().update(JUICE.getJamsProperties().getProperty("libs"));
                    JUICE.getJuiceFrame().getLibTreePanel().setEnabled(true);
                }
            });
            loadLibsDlg.execute();
        }
        catch (Throwable t) {
            JAMSTools.handle((Throwable)t);
        }
    }

    private static void createClassLoader() {
        String libs = JUICE.getJamsProperties().getProperty("libs");
        String[] libsArray = StringTools.toArray((String)libs, (String)";");
        loader = JAMSClassLoader.createClassLoader((String[])libsArray, (RuntimeLogger)new RuntimeLogger());
    }

    private static Class[] getJAMSDataClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Attribute.Boolean.class);
        classes.add(Attribute.Calendar.class);
        classes.add(Attribute.Double.class);
        classes.add(Attribute.DirName.class);
        classes.add(Attribute.Entity.class);
        classes.add(Attribute.Float.class);
        classes.add(Attribute.FileName.class);
        classes.add(Attribute.Geometry.class);
        classes.add(Attribute.Integer.class);
        classes.add(Attribute.Long.class);
        classes.add(Attribute.String.class);
        classes.add(Attribute.BooleanArray.class);
        classes.add(Attribute.DoubleArray.class);
        classes.add(Attribute.FloatArray.class);
        classes.add(Attribute.IntegerArray.class);
        classes.add(Attribute.LongArray.class);
        classes.add(Attribute.StringArray.class);
        classes.add(Attribute.TimeInterval.class);
        Class[] classesA = new Class[classes.size()];
        classes.toArray(classesA);
        return classesA;
    }

    public static SystemProperties getJamsProperties() {
        return jamsProperties;
    }

    public static ArrayList<ModelView> getModelViews() {
        return modelViews;
    }

    public static JUICEFrame getJuiceFrame() {
        return juiceFrame;
    }

    public static ClassLoader getLoader() {
        return loader;
    }

    public static void setStatusText(String status) {
        JUICE.getJuiceFrame().getStatusLabel().setText(status);
    }

    public static LibTree getLibTree() {
        return libTree;
    }

    static {
        modelViews = new ArrayList();
    }
}

