/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.soilWater;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="InitJ2KProcessLayeredSoilWaterStates", author="Peter Krause", description="Calculates soil water balance for each HRU without vertical layers")
public class InitJ2KProcessLayeredSoilWaterStates
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The hru entities")
    public Attribute.EntityCollection entities;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="field capacity adaptation factor")
    public Attribute.Double FCAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="air capacity adaptation factor")
    public Attribute.Double ACAdaptation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="HRU statevar rooting depth")
    public Attribute.Double rootDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="number of horizons")
    public Attribute.Double horizons;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="soil horizon depths")
    public Attribute.DoubleArray depth_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU attribute maximum MPS")
    public Attribute.DoubleArray maxMPS_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU attribute maximum LPS")
    public Attribute.DoubleArray maxLPS_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var actual MPS")
    public Attribute.DoubleArray actMPS_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var actual LPS")
    public Attribute.DoubleArray actLPS_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var saturation of MPS")
    public Attribute.DoubleArray satMPS_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var saturation of LPS")
    public Attribute.DoubleArray satLPS_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="HRU state var saturation of whole soil")
    public Attribute.Double satSoil_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="RD2 inflow")
    public Attribute.DoubleArray inRD2_h;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="initial saturation for all horizons")
    public Attribute.Double initSat;

    public void init() {
    }

    public void run() {
        double rootDepth;
        Attribute.Entity entity = this.entities.getCurrent();
        int horizons = (int)this.horizons.getValue();
        double remRD = rootDepth = this.rootDepth.getValue() * 10.0;
        double[] mxMPS = new double[horizons];
        double[] mxLPS = new double[horizons];
        double[] acMPS = new double[horizons];
        double[] acLPS = new double[horizons];
        double[] stMPS = new double[horizons];
        double[] stLPS = new double[horizons];
        double[] inRD2 = new double[horizons];
        double[] depth = new double[horizons];
        String aNameFC = "fieldcapacity_h";
        String aNameAC = "aircapacity_h";
        String depthName = "depth_h";
        for (int h = 0; h < horizons; ++h) {
            depth[h] = entity.getDouble(depthName + h);
            acMPS[h] = 0.0;
            mxMPS[h] = entity.getDouble(aNameFC + h) * this.area.getValue() * this.FCAdaptation.getValue();
            mxLPS[h] = entity.getDouble(aNameAC + h) * this.area.getValue() * this.ACAdaptation.getValue();
            acMPS[h] = this.initSat.getValue() * mxMPS[h];
            stMPS[h] = this.initSat.getValue();
            stLPS[h] = 0.0;
            inRD2[h] = 0.0;
        }
        this.maxMPS_h.setValue(mxMPS);
        this.maxLPS_h.setValue(mxLPS);
        this.actMPS_h.setValue(acMPS);
        this.actLPS_h.setValue(acLPS);
        this.satMPS_h.setValue(stMPS);
        this.satLPS_h.setValue(stLPS);
        this.inRD2_h.setValue(inRD2);
        this.depth_h.setValue(depth);
        this.satSoil_h.setValue(0.0);
    }

    public void cleanup() {
    }
}

