/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.snow;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="ABCSnowModule", author="Peter Krause", description="The famous snow-17 snow module. Implementation is based on the original sources of Eric Anderson in a reworked version from Victor Korensome very minor adaptation were necessary to make the routine JAMS compatible")
public class Snow17Module
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time interval")
    public Attribute.TimeInterval timeInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity area")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity elevation")
    public Attribute.Double elevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Entity latitude")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain amount")
    public Attribute.Double rain_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow amount")
    public Attribute.Double snow_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the temperature")
    public Attribute.Double airTemperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the daily minimum temperature")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the daily maximum temperature")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow water equivalent [WE]")
    public Attribute.Double swe_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="negative snow heat [NEGHS]")
    public Attribute.Double negSnowHeat_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="cnhs not clear [CNHS]")
    public Attribute.Double cnhs_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="liquid water in snow pack [LIQW]")
    public Attribute.Double liqWater_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Antecedent temperature index [TINDEX]")
    public Attribute.Double tindex_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Cumulated snow water including liquid [ACCMAX]")
    public Attribute.Double maxAccumulation_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Snow liquid water attenuation storage [STORGE]")
    public Attribute.Double liqWaterAttStorage_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Adjusted areal snow cover fraction [AEADJ]")
    public Attribute.Double aeAdj_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Array of lagged liquid water values [EXLAG]")
    public Attribute.DoubleArray exlag_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Average snow temperature [SNTMP]")
    public Attribute.Double snowTemp_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Average snow depth [SNDPT]")
    public Attribute.Double snowDepth_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Average snow density [DS]")
    public Attribute.Double snowDens_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Areal snow cover [AESC]")
    public Attribute.Double arealSnowCover_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="internal state [SB]")
    public Attribute.Double sb_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="internal state [SBWS]")
    public Attribute.Double sbws_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="internal state [SBAESC]")
    public Attribute.Double sbaesc_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain passed by the snow module [RAIN]")
    public Attribute.Double rainOut_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow pack runoff [PACKRO]")
    public Attribute.Double packRunoff_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="ground melt runoff [GMRO]")
    public Attribute.Double groundMeltRunoff_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="pack melt [MELT]")
    public Attribute.Double packMelt_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="rain on bare ground [ROBG]")
    public Attribute.Double rainOnBareGround_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="refrozen water [SXRFRZ]")
    public Attribute.Double refrozenWater_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="total output [RM]")
    public Attribute.Double totalOutput_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="net surface energy exchange [QNET]")
    public Attribute.Double netSurfaceEnergyExchange_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="snow evaporation")
    public Attribute.Double snowEvap_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="maximum temperature at timeStep-1")
    public Attribute.Double tmaxPre;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow correction factor [SCF]")
    public Attribute.Double snowCorrectionFactor_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minimum melt factor [MFMIN]")
    public Attribute.Double meltFactorMin_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum melt factor [MFMAX]")
    public Attribute.Double meltFactorMax_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="average wind function [UADJ]")
    public Attribute.Double avgWindFunction_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="minimum SWE for 100% cover [SI]")
    public Attribute.Double min100CoverSwe_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="ordinates of the areal depletion curve [ADC]")
    public Attribute.DoubleArray arealDepletionCurve_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum negative melt factor [NMF]")
    public Attribute.Double maxNegativeMeltFactor_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="antecedent temperature index parameter [TIPM]")
    public Attribute.Double tipm_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temperature which delineates rain from snow [PXTEMP]not used in this version, because rain and snow comes as input")
    public Attribute.Double pxtemp_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="percent (decimal) liquid water holding capacity [PLWHC]")
    public Attribute.Double maxWaterCap_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="constant amount of melt at the snow-soil interface [DAYGM]")
    public Attribute.Double groundMelt_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="base temperature for snowmelt computations during non-rain periods [MBASE]")
    public Attribute.Double baseTemp_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="melt factor variation type: [LMFV]0 & latitude < 54 default;0 & latitude > 54 Alaska type;1 user specified ")
    public Attribute.Integer lmfv_1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="module active")
    public Attribute.Boolean active;
    double sfnew;
    double rfmin;
    double sbci;
    int deltaTime;
    int month;
    int date;
    int julDay;
    double packRunoff;
    double groundMeltRunoff;
    double rainOnBareGround;
    double refrozenWater;
    double totalOutput;
    double packMelt;
    double rainMelt;
    double snowEvap;
    double[] exlag;
    double[] arealDepletionCurve = new double[]{0.0, 0.07, 0.21, 0.3, 0.36, 0.41, 0.45, 0.51, 0.6, 0.7, 1.0};
    double[] monthlyMeltFactor = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    double precip;
    double rainOut;
    double rainIn;
    double snowIn;
    double airTemp;
    double snowFall;
    double swe;
    double liqWater;
    double snowTemp;
    double sb;
    double sbws;
    double sbaesc;
    double maxAccumulation;
    double aeAdj;
    double tindex;
    double liqWaterAttStorage;
    double snowDepth;
    double snowDens;
    double groundSnowLoss;
    double groundWaterLoss;
    double arealSnowCover;
    double cnhs;
    double negSnowHeat;
    double netSurfaceEnergyExchange;
    boolean meltComputed;
    double dqnet;
    double totalPackWater;
    int nosnow = 1;
    double snof;
    double cnhspx;
    double groundMelt;
    double avgWindFunction;
    double maxWaterCap;
    final double SNEW = 1.5;
    final double RMIN = 0.25;
    final double SBC = 0.0612;
    double sublimationRate = 0.0;

    public void init() {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        if (this.active == null || this.active.getValue()) {
            int tu;
            if (this.exlag_1.getValue() == null) {
                double[] ex = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                this.exlag_1.setValue(ex);
            }
            if ((tu = this.timeInterval.getTimeUnit()) == 6) {
                this.deltaTime = 24 * this.timeInterval.getTimeUnitCount();
            }
            if (tu == 11) {
                this.deltaTime = this.timeInterval.getTimeUnitCount();
            }
            this.sfnew = 1.5 * (double)this.deltaTime;
            this.rfmin = 0.25 * (double)this.deltaTime;
            this.sbci = 0.0612 * (double)this.deltaTime;
            double airPressure = 1012.4 - 11.34 * this.elevation.getValue() / 100.0 + 0.00745 * Math.pow(this.elevation.getValue() / 100.0, 2.4);
            this.rainOut = 0.0;
            this.packRunoff = 0.0;
            this.groundMeltRunoff = 0.0;
            this.packMelt = 0.0;
            this.rainOnBareGround = 0.0;
            this.refrozenWater = 0.0;
            this.totalOutput = 0.0;
            this.meltComputed = false;
            this.rainMelt = 0.0;
            this.groundSnowLoss = 0.0;
            this.netSurfaceEnergyExchange = 0.0;
            this.month = this.time.get(2);
            this.date = this.time.get(5);
            this.julDay = this.time.get(6);
            this.rainIn = this.rain_1.getValue();
            this.snowIn = this.snow_1.getValue();
            this.precip = this.rainIn + this.snowIn;
            this.airTemp = this.airTemperature.getValue();
            this.swe = this.swe_1.getValue();
            this.liqWater = this.liqWater_1.getValue();
            this.snowTemp = this.snowTemp_1.getValue();
            this.sb = this.sb_1.getValue();
            this.sbws = this.sbws_1.getValue();
            this.sbaesc = this.sbaesc_1.getValue();
            this.maxAccumulation = this.maxAccumulation_1.getValue();
            this.aeAdj = this.aeAdj_1.getValue();
            this.tindex = this.tindex_1.getValue();
            this.exlag = this.exlag_1.getValue();
            this.liqWaterAttStorage = this.liqWaterAttStorage_1.getValue();
            this.snowDepth = this.snowDepth_1.getValue();
            this.snowDens = this.snowDens_1.getValue();
            this.arealSnowCover = this.arealSnowCover_1.getValue();
            this.cnhs = this.cnhs_1.getValue();
            this.negSnowHeat = this.negSnowHeat_1.getValue();
            this.cnhspx = 0.0;
            this.groundMelt = this.groundMelt_1.getValue();
            this.avgWindFunction = this.avgWindFunction_1.getValue();
            this.maxWaterCap = this.maxWaterCap_1.getValue();
            double sfrac = 0.0;
            if (this.precip > 0.0) {
                double rfrac = this.rainIn / this.precip;
                sfrac = this.snowIn / this.precip;
            } else {
                double rfrac = 0.0;
                sfrac = 0.0;
            }
            this.pack19(airPressure, sfrac);
            this.rainOut_1.setValue(this.rainIn);
            this.packRunoff_1.setValue(this.packRunoff);
            this.groundMeltRunoff_1.setValue(this.groundMeltRunoff);
            this.packMelt_1.setValue(this.packMelt);
            this.rainOnBareGround_1.setValue(this.rainOnBareGround);
            this.refrozenWater_1.setValue(this.refrozenWater);
            this.totalOutput_1.setValue(this.totalOutput);
            this.netSurfaceEnergyExchange_1.setValue(this.netSurfaceEnergyExchange);
            this.swe_1.setValue(this.swe);
            this.liqWater_1.setValue(this.liqWater);
            this.snowTemp_1.setValue(this.snowTemp);
            this.sb_1.setValue(this.sb);
            this.sbws_1.setValue(this.sbws);
            this.sbaesc_1.setValue(this.sbaesc);
            this.maxAccumulation_1.setValue(this.maxAccumulation);
            this.aeAdj_1.setValue(this.aeAdj);
            this.tindex_1.setValue(this.tindex);
            this.exlag_1.setValue(this.exlag);
            this.liqWaterAttStorage_1.setValue(this.liqWaterAttStorage);
            this.snowDepth_1.setValue(this.snowDepth);
            this.snowDens_1.setValue(this.snowDens);
            this.arealSnowCover_1.setValue(this.arealSnowCover);
            this.cnhs_1.setValue(this.cnhs);
            this.negSnowHeat_1.setValue(this.negSnowHeat);
        }
    }

    private boolean pack19(double airPressure, double sfrac) {
        if (this.swe != 0.0 || this.precip != 0.0) {
            if (this.precip == 0.0) {
                return this.calcGroundMelt(this.airTemp, airPressure);
            }
            if (sfrac > 0.0) {
                this.snowTemp = this.airTemp;
                if (this.snowTemp > 0.0) {
                    this.snowTemp = 0.0;
                }
                this.snowFall = this.precip * sfrac * this.snowCorrectionFactor_1.getValue();
                double xxs = this.swe + this.liqWater;
                if (xxs < this.sbws) {
                    if (this.snowFall >= this.snof) {
                        this.sbws = this.swe + this.liqWater + 0.75 * this.snowFall;
                    }
                } else {
                    this.sbws += 0.75 * this.snowFall;
                    if (this.snowFall >= this.snof && this.sb > xxs) {
                        this.sb = this.swe + this.liqWater;
                    }
                }
                this.swe += this.snowFall;
                xxs = this.swe + this.liqWater;
                double xcst = 3.0 * this.sb;
                if (xxs >= xcst) {
                    this.maxAccumulation = this.swe + this.liqWater;
                    this.aeAdj = 0.0;
                }
                this.cnhspx = -1.0 * this.snowTemp * this.snowFall / 160.0;
                if (this.snowFall > this.sfnew) {
                    this.tindex = this.snowTemp;
                }
            }
            this.rainIn = this.precip * (1.0 - sfrac);
            if (this.swe == 0.0) {
                return this.finish(this.airTemp);
            }
            double rainTemp = this.airTemp;
            if (rainTemp < 0.0) {
                rainTemp = 0.0;
            }
            this.rainMelt = 0.0125 * this.rainIn * rainTemp;
            return this.calcGroundMelt(this.airTemp, airPressure);
        }
        this.finish(this.airTemp);
        return true;
    }

    public void cleanup() {
    }

    private boolean calcGroundMelt(double airTemp, double airPressure) {
        if (this.swe > this.groundMelt) {
            double gmwlos = this.groundMelt / this.swe * this.liqWater;
            this.groundSnowLoss = this.groundMelt;
            if (!this.meltComputed) {
                this.melt19(airTemp);
                this.meltComputed = true;
            }
            if (this.rainIn > this.rfmin) {
                double ea = 2.7489E8 * Math.exp(-4278.63 / (airTemp + 242.792));
                ea = 0.9 * ea;
                double tak = (airTemp + 273.0) * 0.01;
                double tak4 = Math.pow(tak, 4.0);
                double qn = this.sbci * (tak4 - 55.55);
                double qe = 8.5 * (ea - 6.11) * this.avgWindFunction;
                double qh = 0.0048449999999999995 * airPressure * this.avgWindFunction * airTemp;
                this.packMelt = qn + qe + qh + this.rainMelt;
                if (this.packMelt < 0.0) {
                    this.packMelt = 0.0;
                }
            } else {
                this.packMelt += this.rainMelt;
            }
            this.aesc19();
            if (this.arealSnowCover < 1.0) {
                this.packMelt *= this.arealSnowCover;
                this.cnhs *= this.arealSnowCover;
                gmwlos *= this.arealSnowCover;
                this.groundSnowLoss *= this.arealSnowCover;
                this.rainOnBareGround = (1.0 - this.arealSnowCover) * this.rainIn;
                this.rainIn -= this.rainOnBareGround;
            } else {
                this.rainOnBareGround = 0.0;
            }
            double xxs = this.cnhs + this.negSnowHeat;
            if (xxs < 0.0) {
                this.cnhs = -1.0 * this.negSnowHeat;
            }
            this.swe -= this.groundSnowLoss;
            this.liqWater -= gmwlos;
            this.groundMeltRunoff = this.groundSnowLoss + gmwlos;
            if (this.packMelt > 0.0) {
                if (this.packMelt >= this.swe) {
                    this.netSurfaceEnergyExchange = this.packMelt = this.swe + this.liqWater;
                    return this.setNoSnowConditions(airTemp);
                }
                this.swe -= this.packMelt;
            }
            this.netSurfaceEnergyExchange = this.packMelt - this.cnhs - this.cnhspx;
            double water = this.packMelt + this.rainIn;
            double heat = this.cnhs + this.cnhspx;
            double maxLiqWater = this.maxWaterCap * this.swe;
            this.negSnowHeat += heat;
            if (this.negSnowHeat < 0.0) {
                this.negSnowHeat = 0.0;
            }
            double xcst = 0.33 * this.swe;
            double xxs1 = water + this.liqWater;
            double xxs2 = maxLiqWater + this.negSnowHeat + this.maxWaterCap * this.negSnowHeat;
            double excess = 0.0;
            if (this.negSnowHeat > xcst) {
                this.negSnowHeat = 0.33 * this.swe;
            }
            if (xxs1 < xxs2) {
                xxs = water + this.liqWater;
                if (xxs < this.negSnowHeat) {
                    this.swe = this.swe + water + this.liqWater;
                    this.negSnowHeat = this.negSnowHeat - water - this.liqWater;
                    this.refrozenWater = this.refrozenWater + water + this.liqWater;
                    this.liqWater = 0.0;
                    excess = 0.0;
                } else {
                    this.liqWater = this.liqWater + water - this.negSnowHeat;
                    this.swe += this.negSnowHeat;
                    this.packMelt -= this.negSnowHeat;
                    this.refrozenWater += this.negSnowHeat;
                    this.negSnowHeat = 0.0;
                    excess = 0.0;
                }
            } else {
                excess = water + this.liqWater - maxLiqWater - this.negSnowHeat - this.maxWaterCap * this.negSnowHeat;
                this.liqWater = maxLiqWater + this.maxWaterCap * this.negSnowHeat;
                this.swe += this.negSnowHeat;
                this.negSnowHeat = 0.0;
            }
            if (this.negSnowHeat == 0.0) {
                this.tindex = 0.0;
            }
            this.noRout(excess);
            this.packRunoff += this.groundMeltRunoff;
            return this.finish(airTemp);
        }
        this.groundMeltRunoff = this.swe + this.liqWater;
        this.packMelt = 0.0;
        this.rainOnBareGround = this.rainIn;
        this.rainIn = 0.0;
        return this.setNoSnowConditions(airTemp);
    }

    private boolean melt19(double airTemp) {
        double tsur;
        int[] mmd = new int[]{301, 332, 361, 26, 56, 87, 117, 148, 179, 209, 240, 270};
        this.cnhs = 0.0;
        this.packMelt = 0.0;
        double diff = this.meltFactorMax_1.getValue() - this.meltFactorMin_1.getValue();
        int dayn = this.julDay;
        double meltFactor = 0.0;
        double x = 0.0;
        double adjmf = 0.0;
        if (this.lmfv_1.getValue() == 0) {
            if (this.latitude.getValue() < 54.0) {
                meltFactor = Math.sin((double)(this.julDay * 2) * Math.PI / 366.0) * diff * 0.5 + (this.meltFactorMax_1.getValue() + this.meltFactorMin_1.getValue()) * 0.5;
            } else {
                x = this.julDay >= 275 ? (double)((this.julDay - 275) / 183) : (this.julDay >= 92 ? (double)((275 - this.julDay) / 183) : (double)((91 + this.julDay) / 183));
                double xx = Math.sin((double)(this.julDay * 2) * Math.PI / 366.0) * 0.5 + 0.5;
                adjmf = x <= 0.48 ? 0.0 : (x >= 0.7 ? 1.0 : (x - 0.48) / 0.21999999999999997);
                meltFactor = xx * adjmf * diff + this.meltFactorMin_1.getValue();
            }
        } else {
            int nd;
            int md;
            int ma;
            int mb = this.month;
            if (dayn < mmd[this.month]) {
                --mb;
            }
            if (mb < 0) {
                mb = 11;
            }
            if ((ma = mb + 1) == 12) {
                ma = 1;
            }
            if ((md = mmd[ma] - mmd[mb]) < 0) {
                md += 366;
            }
            if ((nd = dayn - mmd[mb]) < 0) {
                nd += 366;
            }
            adjmf = this.monthlyMeltFactor[mb] + (double)(nd / md) * this.monthlyMeltFactor[ma] - this.monthlyMeltFactor[mb];
            meltFactor = this.meltFactorMin_1.getValue() + adjmf * diff;
        }
        double ratio = meltFactor / this.meltFactorMax_1.getValue();
        double tmx = airTemp - this.baseTemp_1.getValue();
        if (tmx < 0.0) {
            tmx = 0.0;
        }
        if ((tsur = airTemp) > 0.0) {
            tsur = 0.0;
        }
        double tnmx = this.tindex - tsur;
        double nmrate = ratio * this.maxNegativeMeltFactor_1.getValue();
        this.cnhs = nmrate * tnmx;
        this.tindex += this.tipm_1.getValue() * (airTemp - this.tindex);
        if (this.tindex > 0.0) {
            this.tindex = 0.0;
        }
        if (tmx > 0.0) {
            this.packMelt = meltFactor * tmx;
        }
        return true;
    }

    private boolean aesc19() {
        double twe = this.swe + this.liqWater;
        if (twe > this.maxAccumulation) {
            this.maxAccumulation = twe;
        }
        if (twe >= this.aeAdj) {
            this.aeAdj = 0.0;
        }
        double ai = this.maxAccumulation;
        if (this.maxAccumulation > this.min100CoverSwe_1.getValue()) {
            ai = this.min100CoverSwe_1.getValue();
        }
        if (this.aeAdj > 0.0) {
            ai = this.aeAdj;
        }
        if (twe >= ai) {
            this.sb = twe;
            this.sbws = twe;
            this.arealSnowCover = 1.0;
        } else if (twe <= this.sb) {
            int n;
            int r = (int)(twe / ai * 10.0 + 1.0);
            int fn = n = --r;
            this.arealSnowCover = this.arealDepletionCurve[n] + (this.arealDepletionCurve[n + 1] - this.arealDepletionCurve[n]) * (double)(r -= fn);
            if (this.arealSnowCover > 1.0) {
                this.arealSnowCover = 1.0;
            }
            this.sb = twe + this.snof;
            this.sbws = twe;
            this.sbaesc = this.arealSnowCover;
        } else {
            this.arealSnowCover = twe >= this.sbws ? 1.0 : this.sbaesc + (1.0 - this.sbaesc) * ((twe - this.sb) / (this.sbws - this.sb));
        }
        if (this.arealSnowCover < 0.05) {
            this.arealSnowCover = 0.05;
        }
        if (this.arealSnowCover > 1.0) {
            this.arealSnowCover = 1.0;
        }
        return true;
    }

    private boolean snowDepth(double airTemp, double liqW) {
        double dhc = 0.0;
        double sdn = 0.0;
        double tsnew = airTemp;
        if (this.snowFall > 0.0) {
            sdn = this.calcNewSnowDensity(airTemp);
            dhc = this.calcSnowDepth(this.snowFall, sdn);
            tsnew = this.calcSnowTemperature(dhc, sdn, this.snowFall, 0.0, airTemp, 0.0, tsnew, 0.0);
            double[] depthDensity = this.calcSnowCompaction(this.snowFall, this.deltaTime, sdn, 0.0, 0.0, 0.0, tsnew);
            dhc = depthDensity[0];
            sdn = depthDensity[1];
        }
        if (this.snowDepth > 1.0E-4) {
            double shn = dhc + this.snowDepth;
            double dsn = (sdn * dhc + this.snowDens * this.snowDepth) / shn;
            this.snowTemp = this.calcSnowTemperature(shn, dsn, this.swe, liqW, airTemp, 0.0, this.snowTemp, dhc);
            double[] depthDensity = this.calcSnowCompaction(this.swe, this.deltaTime, this.snowDens, liqW, this.snowFall, this.refrozenWater, this.snowTemp);
            this.snowDepth = depthDensity[0];
            this.snowDens = depthDensity[1];
            if (this.groundSnowLoss > 0.0) {
                this.snowDepth -= 0.1 * this.groundSnowLoss / this.snowDens;
            }
            if (this.snowDepth < 0.0) {
                this.snowDepth = 0.0;
            }
            this.snowTemp = (this.snowTemp * this.snowDepth + tsnew * dhc) / (this.snowDepth + dhc);
            this.snowDepth += dhc;
            this.snowDens = 0.1 * this.swe / this.snowDepth;
        } else {
            this.snowDepth = dhc;
            this.snowDens = sdn;
            if (this.groundSnowLoss > 0.0) {
                this.snowDepth -= 0.1 * this.groundSnowLoss / this.snowDens;
            }
            if (this.snowDepth < 0.0) {
                this.snowDepth = 0.0;
            }
            this.snowTemp = tsnew;
        }
        return true;
    }

    private double calcNewSnowDensity(double airTemp) {
        double dens = 0.0;
        dens = airTemp <= -15.0 ? 0.05 : 0.05 + 0.0017 * Math.pow(airTemp + 15.0, 1.5);
        return dens;
    }

    private double calcSnowDepth(double precip, double density) {
        double depth = 0.0;
        double px = 0.1 * precip;
        depth = px / density;
        return depth;
    }

    private double calcSnowTemperature(double depth, double dens, double we, double liqW, double aTemp, double tempChange, double sTemp, double depthChange) {
        double dta = aTemp;
        double newTemp = 0.0;
        double cice = 2100000.0;
        double ch2o = 4200000.0;
        double cair = 1000.0;
        double wavel = 43200.0;
        double shx = 0.01 * depth;
        double dhcx = 0.01 * depthChange;
        double stot = we + liqW;
        double dst = 0.1 * stot / depth;
        double sl = 0.0442 * Math.exp(5.181 * dst);
        double fl = liqW / stot;
        double sc = cice * dens + cair * (1.0 - dens - fl) + ch2o * fl;
        double alp = Math.sqrt(Math.PI * sc / (wavel * sl));
        newTemp = depthChange < 0.0 ? sTemp + dta * ((Math.exp(-alp * dhcx) - Math.exp(-alp * shx)) / (alp * (shx - dhcx))) : sTemp + dta * (Math.exp(-alp * shx) / (alp * shx));
        if (newTemp > 0.0) {
            newTemp = 0.0;
        }
        return newTemp;
    }

    private double[] calcSnowCompaction(double we, int timeStep, double dens, double liqW, double sFall, double refreeze, double sTemp) {
        double dsm;
        double dsx;
        double c1 = 0.01;
        double c2 = 21.0;
        double c3 = 0.01;
        double c4 = 0.04;
        double rds = 0.2;
        double c5 = 2.0;
        double cx = 46.0;
        double[] out = new double[2];
        double wx = we * 0.1;
        double dsc = 1.0;
        if (wx > 0.01) {
            double b = (double)timeStep * c1 * Math.exp(0.08 * sTemp - c2 * dens);
            dsc = (Math.expm1(b * wx) + 1.0) / (b * wx);
        }
        double a = c3;
        if (liqW > 0.0) {
            a *= c5;
        }
        double c = c4 * sTemp;
        if (dens > rds) {
            c -= cx * (dens - rds);
        }
        if ((dsx = dens * dsc * (dsm = Math.exp(a * (double)timeStep * Math.exp(c)))) > 0.45) {
            dsx = 0.45;
        }
        if (dsx < 0.05) {
            dsx = 0.05;
        }
        dens = dsx;
        double dwx = wx - 0.1 * (sFall + refreeze);
        double depth = 0.0;
        depth = dwx > 0.0 ? dwx / dens : (wx > 0.0 ? wx / dsx : 0.0);
        out[0] = depth;
        out[1] = dens;
        return out;
    }

    private boolean rout19(double excessWater) {
        double xxs;
        int i;
        this.packRunoff = 0.0;
        double cl = 0.03 * (double)this.deltaTime / 6.0;
        if (excessWater > 0.0) {
            if (excessWater >= 0.1 || this.swe >= 1.0) {
                double n = Math.pow(excessWater * 4.0, 0.3) + 0.5;
                if (n == 0.0) {
                    n = 1.0;
                }
                i = 0;
                while ((double)i < n) {
                    int fi = i;
                    double term = cl * this.swe * n / (excessWater * ((double)fi - 0.5));
                    if (term > 150.0) {
                        term = 150.0;
                    }
                    double flag = 5.33 * (1.0 - Math.exp(-1.0 * term));
                    int L2 = (int)((flag + (double)this.deltaTime) / (double)this.deltaTime + 1.0);
                    int L1 = L2 - 1;
                    int endL1 = L1 * this.deltaTime;
                    double por2 = (flag + (double)this.deltaTime - (double)endL1) / (double)this.deltaTime;
                    double por1 = 1.0 - por2;
                    if (L2 < 0) {
                        L2 = 0;
                    }
                    if (L1 < 0) {
                        L1 = 0;
                    }
                    if (L2 > this.exlag.length - 1) {
                        L2 = this.exlag.length - 1;
                    }
                    if (L1 > this.exlag.length - 1) {
                        L1 = this.exlag.length - 1;
                    }
                    this.exlag[L2] = this.exlag[L2] + por2 * excessWater / n;
                    this.exlag[L1] = this.exlag[L1] + por1 * excessWater / n;
                    ++i;
                }
            } else {
                this.exlag[0] = this.exlag[0] + excessWater;
            }
        }
        if ((xxs = this.liqWaterAttStorage + this.exlag[0]) > 0.0) {
            if (xxs >= 0.1) {
                double el = this.exlag[0] / (double)this.deltaTime;
                double els = el / (25.4 * this.arealSnowCover);
                double wes = this.swe / (25.4 * this.arealSnowCover);
                double term = 500.0 * els / Math.pow(wes, 1.3);
                if (term > 150.0) {
                    term = 150.0;
                }
                double r1 = 1.0 / (5.0 * Math.exp(-1.0 * term) + 1.0);
                for (int i2 = 0; i2 < this.deltaTime; ++i2) {
                    double os = (this.liqWaterAttStorage + el) * r1;
                    this.packRunoff += os;
                    this.liqWaterAttStorage = this.liqWaterAttStorage + el - os;
                }
                if (this.liqWaterAttStorage <= 0.001) {
                    this.packRunoff += this.liqWaterAttStorage;
                    this.liqWaterAttStorage = 0.0;
                }
            } else {
                this.packRunoff = this.liqWaterAttStorage + this.exlag[0];
                this.liqWaterAttStorage = 0.0;
            }
        }
        for (i = 1; i < this.exlag.length; ++i) {
            this.exlag[i - 1] = this.exlag[i];
        }
        this.exlag[this.exlag.length - 1] = 0.0;
        return true;
    }

    private boolean noRout(double excessWater) {
        this.packRunoff = this.packRunoff + excessWater - this.rainIn;
        excessWater = 0.0;
        return true;
    }

    private boolean setNoSnowConditions(double airTemp) {
        double tex = 0.0;
        for (int i = 0; i < this.exlag.length; ++i) {
            tex += this.exlag[i];
        }
        this.packRunoff = this.groundMeltRunoff + this.packMelt + tex + this.liqWaterAttStorage;
        this.zero19();
        this.arealSnowCover = 0.0;
        return this.finish(airTemp);
    }

    private boolean zero19() {
        this.swe = 0.0;
        this.negSnowHeat = 0.0;
        this.liqWater = 0.0;
        this.tindex = 0.0;
        this.maxAccumulation = 0.0;
        this.sb = 0.0;
        this.sbaesc = 0.0;
        this.sbws = 0.0;
        this.liqWaterAttStorage = 0.0;
        this.aeAdj = 0.0;
        this.snowDepth = 0.0;
        this.snowTemp = 0.0;
        for (int i = 0; i < this.exlag.length; ++i) {
            this.exlag[i] = 0.0;
        }
        return true;
    }

    private boolean finish(double airTemp) {
        this.totalOutput = this.packRunoff + this.rainOnBareGround;
        double tex = 0.0;
        for (int i = 0; i < this.exlag.length; ++i) {
            tex += this.exlag[i];
        }
        if (this.swe > 0.0) {
            double sliq = this.liqWater + tex + this.liqWaterAttStorage;
            this.snowFall -= this.packMelt;
            if (this.snowFall < 0.0) {
                this.snowFall = 0.0;
            }
            this.snowDepth(airTemp, sliq);
        } else {
            this.snowDepth = 0.0;
            this.snowTemp = 0.0;
            this.snowDens = 0.1;
        }
        double totalWE = this.swe + this.liqWater + tex + this.liqWaterAttStorage;
        if (totalWE > 0.0) {
            this.aesc19();
        }
        return true;
    }

    public double calcMeltFactor(int jDay, double lat, double mfMax, double mfMin) {
        double diff = mfMax - mfMin;
        double meltFactor = 0.0;
        double x = 0.0;
        double adjmf = 0.0;
        int dayN = this.julDay > 79 ? this.julDay - 79 : 366 + this.julDay - 79;
        if (lat < 54.0) {
            meltFactor = Math.sin((double)dayN * 2.0 * Math.PI / 366.0) * diff * 0.5 + (mfMax + mfMin) * 0.5;
        } else {
            x = this.julDay >= 275 ? (double)((dayN - 275) / 183) : (this.julDay >= 92 ? (275.0 - (double)dayN) / 183.0 : (double)((91 + dayN) / 183));
            double xx = Math.sin((double)(dayN * 2) * Math.PI / 366.0) * 0.5 + 0.5;
            adjmf = x <= 0.48 ? 0.0 : (x >= 0.7 ? 1.0 : (x - 0.48) / 0.21999999999999997);
            meltFactor = xx * adjmf * diff + mfMin;
        }
        return meltFactor;
    }

    public double callMeltrate(double airTemp, double ratio, double rain, double meltFactor, int subInt, double airPressure) {
        double tsur;
        double meltRate = 0.0;
        double tmx = airTemp - this.baseTemp_1.getValue();
        if (tmx < 0.0) {
            tmx = 0.0;
        }
        if ((tsur = airTemp) > 0.0) {
            tsur = 0.0;
        }
        double nmindex = this.tindex - tsur;
        double nmrate = ratio * this.maxNegativeMeltFactor_1.getValue();
        this.cnhs = nmrate * nmindex;
        this.tindex += this.tipm_1.getValue() * (airTemp - this.tindex);
        if (rain <= this.rfmin) {
            meltRate = meltFactor * tmx + this.rainMelt;
            if (subInt > 0 && subInt < 3) {
                this.snowEvap += this.sublimationRate * 0.5;
            }
        } else {
            double ea = 2.7489E8 * Math.exp(-4278.63 / (airTemp + 242.792));
            double tak4 = Math.pow((airTemp + 273.16) * 0.01, 4.0);
            double qn = this.sbci * (tak4 - 55.55);
            double qe = 8.5 * ((ea *= 0.9) - 6.11) * this.avgWindFunction_1.getValue();
            double qh = 0.0048449999999999995 * airPressure * this.avgWindFunction_1.getValue() * airTemp;
            meltRate = qn + qe + qh + this.rainMelt;
        }
        if (meltRate < 0.0) {
            meltRate = 0.0;
        }
        return meltRate;
    }

    private double callAeSnow() {
        double aesc = 0.0;
        double twe = this.swe + this.liqWater;
        if (twe > this.maxAccumulation) {
            this.maxAccumulation = twe;
        }
        double ai = this.maxAccumulation;
        if (this.maxAccumulation > this.min100CoverSwe_1.getValue()) {
            ai = this.min100CoverSwe_1.getValue();
        }
        if (twe >= ai) {
            this.sb = twe;
            this.sbws = twe;
            aesc = 1.0;
        } else if (twe <= this.sb) {
            double r;
            double fn;
            double n;
            int idx = (int)n;
            if ((aesc = this.arealDepletionCurve[idx] + (this.arealDepletionCurve[idx + 1] - this.arealDepletionCurve[idx]) * (r -= (fn = (n = (r = twe / ai * 10.0))))) > 1.0) {
                aesc = 1.0;
            }
            this.sb = twe + 1.27;
            this.sbaesc = aesc;
        } else if (twe >= this.sbws) {
            aesc = 1.0;
        }
        if (aesc < 0.05) {
            aesc = 0.05;
        }
        if (aesc > 1.0) {
            aesc = 1.0;
        }
        return aesc;
    }

    private double callHeatWater(double rainInTs) {
        double excessWater;
        double water = this.packMelt + rainInTs;
        double heat = this.cnhs + this.cnhspx;
        double liqWMax = this.maxWaterCap_1.getValue() * this.swe;
        this.negSnowHeat += heat;
        if (this.negSnowHeat < 0.0) {
            this.negSnowHeat = 0.0;
        }
        if (this.negSnowHeat > 0.33 * this.swe) {
            this.negSnowHeat = 0.33 * this.swe;
        }
        if (water + this.liqWater < liqWMax + this.negSnowHeat + this.maxWaterCap_1.getValue() * this.negSnowHeat) {
            if (water < this.negSnowHeat) {
                this.swe += water;
                this.negSnowHeat -= water;
                excessWater = 0.0;
            } else {
                this.liqWater = this.liqWater + water - this.negSnowHeat;
                this.swe += this.negSnowHeat;
                this.negSnowHeat = 0.0;
                excessWater = 0.0;
            }
        } else {
            excessWater = water + this.liqWater - liqWMax - this.negSnowHeat - this.maxWaterCap_1.getValue() * this.negSnowHeat;
            this.liqWater = liqWMax + this.maxWaterCap_1.getValue() * this.negSnowHeat;
            this.swe += this.negSnowHeat;
            this.negSnowHeat = 0.0;
        }
        if (this.tindex > 0.0) {
            this.tindex = 0.0;
        }
        if (this.negSnowHeat == 0.0) {
            this.tindex = 0.0;
        }
        return excessWater;
    }

    private double callRoute(int hoursInTimeStep, double excessWater) {
        double packro = 0.0;
        double cl = 0.03 * (double)hoursInTimeStep / 6.0;
        double prior = this.liqWaterAttStorage + this.exlag[0];
        boolean hundredfifty = false;
        boolean hundredsixty = false;
        boolean hundredninety = false;
        if (excessWater == 0.0 && prior == 0.0) {
            hundredninety = true;
        } else if (excessWater == 0.0 && prior >= 0.1) {
            hundredsixty = true;
        } else if (excessWater < 0.1 || this.swe < 1.0) {
            this.exlag[0] = this.exlag[0] + excessWater;
            hundredfifty = true;
        } else {
            double n = Math.pow(excessWater * 4.0, 0.3) + 0.5;
            if (n == 0.0) {
                n = 0.0;
            }
            double fn = n;
            int i = 0;
            while ((double)i < n) {
                double fi = i + 1;
                double term = cl * this.swe * fn / (excessWater * (fi - 0.5));
                if (term > 150.0) {
                    term = 150.0;
                }
                double flag = 5.33 * (1.0 - Math.exp(-term));
                double dl2 = (flag + (double)hoursInTimeStep) / (double)hoursInTimeStep + 1.0;
                double dl1 = dl2 - 1.0;
                double endl1 = dl1 * (double)hoursInTimeStep;
                double por2 = (flag + (double)hoursInTimeStep - endl1) / (double)hoursInTimeStep;
                double por1 = 1.0 - por2;
                int l1 = (int)dl1;
                int l2 = (int)dl2;
                this.exlag[l2] = this.exlag[l2] + por2 * excessWater / fn;
                this.exlag[l1] = this.exlag[l1] + por1 * excessWater / fn;
                ++i;
            }
        }
        if (hundredfifty) {
            if (this.liqWaterAttStorage + this.exlag[0] == 0.0) {
                hundredninety = true;
                hundredsixty = false;
            } else if (this.liqWaterAttStorage + this.exlag[0] >= 0.1) {
                hundredsixty = true;
            } else {
                packro = this.liqWaterAttStorage + this.exlag[0];
                this.liqWaterAttStorage = 0.0;
                hundredninety = true;
            }
        }
        if (hundredsixty) {
            double el = this.exlag[0] / (double)hoursInTimeStep;
            double els = el / (25.4 * this.arealSnowCover);
            double wes = this.swe / (25.4 * this.arealSnowCover);
            double term = 500.0 * els / Math.pow(wes, 1.3);
            if (term > 150.0) {
                term = 150.0;
            }
            double r1 = 1.0 / (5.0 * Math.exp(-term) + 1.0);
            double os = 0.0;
            for (int i = 0; i < this.exlag.length; ++i) {
                os = (this.liqWaterAttStorage + el) * r1;
                packro += os;
                this.liqWaterAttStorage = this.liqWaterAttStorage + el - os;
            }
            if (this.liqWaterAttStorage > 0.001) {
                hundredninety = true;
            } else {
                packro += this.liqWaterAttStorage;
                this.liqWaterAttStorage = 0.0;
            }
        }
        if (hundredninety = true) {
            for (int i = 1; i < this.exlag.length; ++i) {
                this.exlag[i - 1] = this.exlag[i];
            }
            this.exlag[this.exlag.length - 1] = 0.0;
        }
        return packro;
    }
}

