/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.routing;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="Reach2ReachTransfer", author="Sven Kralisch", description="Simulation of artificial transfer of water and substances between reaches.", date="2014-10-23", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class Reach2ReachTransfer
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Reach collection")
    public Attribute.EntityCollection reaches;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Source reach ID")
    public Attribute.Long sourceReachID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Target reach ID")
    public Attribute.Long targetReachID;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Provisioning attributes of the source reach")
    public Attribute.String[] sourceNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Receiving attributes of the target reach")
    public Attribute.String[] targetNames;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Fraction of overall volume to be transferred", defaultValue="1")
    public Attribute.Double fraction;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Lower boundary for transferred volume", defaultValue="-1")
    public Attribute.Double lowerBound;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Upper boundary for transferred volume", defaultValue="-1")
    public Attribute.Double upperBound;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Component volumes that were transferred")
    public Attribute.Double[] volumes;

    public void run() {
        Attribute.Entity source = this.reaches.getEntity(this.sourceReachID.getValue());
        Attribute.Entity target = this.reaches.getEntity(this.targetReachID.getValue());
        if (source == null || target == null || source.isEmpty() || target.isEmpty()) {
            return;
        }
        double sum = 0.0;
        double[] values = new double[this.sourceNames.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = source.getDouble(this.sourceNames[i].getValue());
            sum += values[i];
        }
        if (sum == 0.0) {
            return;
        }
        double targetVolume = sum * this.fraction.getValue();
        if (this.lowerBound.getValue() >= 0.0) {
            targetVolume = Math.max(targetVolume, Math.min(sum, this.lowerBound.getValue()));
        }
        if (this.upperBound.getValue() >= 0.0) {
            targetVolume = Math.min(targetVolume, this.upperBound.getValue());
        }
        double fractionSum = targetVolume / sum;
        for (int i = 0; i < values.length; ++i) {
            double x = values[i] * fractionSum;
            target.setDouble(this.targetNames[i].getValue(), target.getDouble(this.targetNames[i].getValue()) + x);
            source.setDouble(this.sourceNames[i].getValue(), values[i] - x);
            if (this.volumes == null || this.volumes[i] == null) continue;
            this.volumes[i].setValue(x);
        }
    }
}

