/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.HourlySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

@JAMSComponentDescription(title="CalcExtraterrRadiation", author="Peter Krause", description="Calculates the extraterrestial incoming radiation for aa standard year (i.e. 366 days or 8784 hours). The calculation is donefor the geographical location defined by latitude and longitude.The module can be used in hourly, daily and monthly resolution.", version="1.0_0", date="2011-05-30")
public class CalcExtraterrRadiation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity latidute [deg]", unit="degree", lowerBound=0.0, upperBound=90.0)
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="entity longitude [deg]", unit="degree", lowerBound=0.0, upperBound=180.0)
    public Attribute.Double longitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="longitude of time zone [deg]", unit="degree", lowerBound=0.0, upperBound=180.0, defaultValue="-15")
    public Attribute.Double longTZ;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | h | m]", unit="n/a")
    public Attribute.String tempRes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="location from Greenwich [w | e]")
    public Attribute.String locGrw;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="extraterrestric radiation of each time step of the year [MJ/m\u00b2 timeUnit]", unit="MJ / m^2 timeUnit", lowerBound=0.0)
    public Attribute.DoubleArray extRadArray;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void init() {
    }

    public void run() throws Attribute.Entity.NoSuchAttributeException {
        int i;
        double[] extRadiation = null;
        if (this.tempRes.getValue().equals("d")) {
            extRadiation = new double[366];
        } else if (this.tempRes.getValue().equals("h")) {
            extRadiation = new double[8784];
        } else if (this.tempRes.getValue().equals("m")) {
            extRadiation = new double[12];
        }
        double lati = this.latitude.getValue();
        double longi = this.longitude.getValue();
        double longiTZ = this.longTZ.getValue();
        if (this.locGrw.getValue().equals("e")) {
            longi = 360.0 - longi;
            longiTZ = 360.0 - longiTZ;
        }
        double latRad = MathematicalCalculations.deg2rad(lati);
        if (this.tempRes.getValue().equals("m")) {
            for (i = 0; i < 12; ++i) {
                double declination = SolarRadiationCalculationMethods.calc_SunDeclination(this.monthMean[i]);
                double solarConstant = SolarRadiationCalculationMethods.calc_SolarConstant(this.monthMean[i]);
                double invRelDistEarthSun = SolarRadiationCalculationMethods.calc_InverseRelativeDistanceEarthSun(this.monthMean[i]);
                double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
                extRadiation[i] = DailySolarRadiationCalculationMethods.calc_DailyExtraterrestrialRadiation(solarConstant, invRelDistEarthSun, sunsetHourAngle, latRad, declination);
            }
        } else {
            for (i = 0; i < 366; ++i) {
                int julDay = i + 1;
                double declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
                double solarConstant = SolarRadiationCalculationMethods.calc_SolarConstant(julDay);
                double invRelDistEarthSun = SolarRadiationCalculationMethods.calc_InverseRelativeDistanceEarthSun(julDay);
                if (this.tempRes.getValue().equals("d")) {
                    double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
                    extRadiation[i] = DailySolarRadiationCalculationMethods.calc_DailyExtraterrestrialRadiation(solarConstant, invRelDistEarthSun, sunsetHourAngle, latRad, declination);
                    continue;
                }
                if (!this.tempRes.getValue().equals("h")) continue;
                for (int hour = 0; hour < 24; ++hour) {
                    double midTimeHourAngle = HourlySolarRadiationCalculationMethods.calc_midTimeHourAngle(hour, julDay, longi, longiTZ, false);
                    double startTimeHourAngle = HourlySolarRadiationCalculationMethods.calc_startTimeHourAngle(midTimeHourAngle);
                    double endTimeHourAngle = HourlySolarRadiationCalculationMethods.calc_endTimeHourAngle(midTimeHourAngle);
                    int idx = i * 24 + hour;
                    extRadiation[idx] = HourlySolarRadiationCalculationMethods.calc_HourlyExtraterrestrialRadiation(solarConstant, invRelDistEarthSun, startTimeHourAngle, endTimeHourAngle, latRad, declination);
                }
            }
        }
        for (double r : extRadiation) {
            if (!Double.isNaN(r)) continue;
            this.getModel().getRuntime().sendHalt("Found error in calculation of extraterrestric radiation, possibly due to wrong lat/long values.");
            return;
        }
        this.extRadArray.setValue(extRadiation);
    }

    public void cleanup() {
    }
}

