/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.radiation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import org.unijena.j2k.mathematicalCalculations.MathematicalCalculations;
import org.unijena.j2k.physicalCalculations.DailySolarRadiationCalculationMethods;
import org.unijena.j2k.physicalCalculations.SolarRadiationCalculationMethods;

@JAMSComponentDescription(title="Title", author="Peter Krause", description="Calculates the maximum possible sunshine hours per day")
public class CalcDailyMaximumSunshineHours
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Maximum sunshine duration in h", defaultValue="0")
    public Attribute.Double sunhmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute latitude [deg]")
    public Attribute.Double latitude;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temporal resolution [d | m]")
    public Attribute.String tempRes;
    int[] monthMean = new int[]{15, 45, 74, 105, 135, 166, 196, 227, 258, 288, 319, 349};

    public void run() throws Attribute.Entity.NoSuchAttributeException, IOException {
        int julDay = this.time.get(6);
        int month = this.time.get(2);
        double lati = this.latitude.getValue();
        double declination = 0.0;
        if (this.tempRes == null) {
            declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
        } else if (this.tempRes.getValue().equals("d")) {
            declination = SolarRadiationCalculationMethods.calc_SunDeclination(julDay);
        } else if (this.tempRes.getValue().equals("m")) {
            declination = SolarRadiationCalculationMethods.calc_SunDeclination(this.monthMean[month]);
        }
        double latRad = MathematicalCalculations.deg2rad(lati);
        double sunsetHourAngle = DailySolarRadiationCalculationMethods.calc_SunsetHourAngle(latRad, declination);
        double maximumSunshine = DailySolarRadiationCalculationMethods.calc_maximumSunshineHours(sunsetHourAngle);
        this.sunhmax.setValue(maximumSunshine);
    }
}

