/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="WindSpeed10mTo2m", author="Annika K\u00fcnne", description="Approximation of wind speed at 2m above ground from measurements at 10m above ground", date="2023-03-23", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Muliplied rhum value by 100 to get \"%\"")})
public class WindSpeed10mTo2m
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="wind_10m", unit="m/s")
    public Attribute.DoubleArray v10;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="wind_2m", unit="m/s")
    public Attribute.DoubleArray v2;

    public void init() {
        double[] x = new double[this.v10.getValue().length];
        this.v2.setValue(x);
    }

    public void run() {
        int i = 0;
        double[] x = this.v2.getValue();
        for (double v : this.v10.getValue()) {
            double s;
            x[i] = s = WindSpeed10mTo2m.transformWindSpeed(v, 10.0, 2.0);
            ++i;
        }
    }

    public static double transformWindSpeed(double v10, double h10, double h2) {
        double alpha = 0.14285714285714285;
        double v2 = v10 * Math.pow(h2 / h10, alpha);
        return v2;
    }

    public void cleanup() {
    }
}

