/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.JAMS;
import jams.data.ArrayPool;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.statistics.IDW;

@JAMSComponentDescription(title="RainCorrection_Richter", author="Peter Krause", description="Applies correction according to RICHTER 1985 for measured daily precip sums", version="1.0_0", date="2011-05-30")
public class RainCorrectionRichter_China
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="the precip values", unit="mm")
    public Attribute.DoubleArray precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temperature for the correction function", unit="\u00b0C")
    public Attribute.DoubleArray temperature;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="wind for the correction function")
    public Attribute.DoubleArray wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="corrected precip values", unit="mm")
    public Attribute.DoubleArray rcorr;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of temperature station elevations", unit="m")
    public Attribute.DoubleArray tempElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of temperature station's x coordinate")
    public Attribute.DoubleArray tempXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of temperature station's y coordinate")
    public Attribute.DoubleArray tempYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Regression coefficients for temperature")
    public Attribute.DoubleArray tempRegCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Regression coefficients for wind")
    public Attribute.DoubleArray windRegCoeff;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of temperature station elevations", unit="m")
    public Attribute.DoubleArray windElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of wind station's x coordinate")
    public Attribute.DoubleArray windXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array of wind station's y coordinate")
    public Attribute.DoubleArray windYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of precip station elevations", unit="m")
    public Attribute.DoubleArray rainElevation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of precip station's x coordinate")
    public Attribute.DoubleArray rainXCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="array of precip station's y coordinate")
    public Attribute.DoubleArray rainYCoord;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="number of temperature station for IDW")
    public Attribute.Integer tempNIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="number of wind station for IDW")
    public Attribute.Integer windNIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="power for IDW function")
    public Attribute.Double pIDW;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="regression threshold")
    public Attribute.Double regThres;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow_trs", upperBound=5.0, lowerBound=-5.0, unit="\u00b0C")
    public Attribute.Double snow_trs;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow_trans", upperBound=10.0, lowerBound=0.0, unit="K")
    public Attribute.Double snow_trans;
    ArrayPool<double[]> memPool = new ArrayPool(Double.TYPE);
    IDW idwTemp = new IDW();
    IDW idwWind = new IDW();

    public void run() {
        double[] precip = this.precip.getValue();
        double[] temperature = this.temperature.getValue();
        double[] wind = this.wind.getValue();
        int n = precip.length;
        double[] rcorr = this.rcorr.getValue();
        if (rcorr == null || rcorr.length != n) {
            rcorr = (double[])this.memPool.alloc(n);
        }
        double[] rainElev = this.rainElevation.getValue();
        double[] rainX = this.rainXCoord.getValue();
        double[] rainY = this.rainYCoord.getValue();
        double rsqTemp = this.tempRegCoeff.getValue()[2];
        double gradTemp = this.tempRegCoeff.getValue()[1];
        double rsqWind = this.tempRegCoeff.getValue()[2];
        double gradWind = this.tempRegCoeff.getValue()[1];
        this.idwTemp.init(this.tempXCoord.getValue(), this.tempYCoord.getValue(), this.tempElevation.getValue(), (int)this.pIDW.getValue(), IDW.Projection.ANY);
        this.idwWind.init(this.windXCoord.getValue(), this.windYCoord.getValue(), this.windElevation.getValue(), (int)this.pIDW.getValue(), IDW.Projection.ANY);
        for (int r = 0; r < n; ++r) {
            double rainTemp = rsqTemp > this.regThres.getValue() ? this.idwTemp.getElevationCorrectedIDW(rainX[r], rainY[r], rainElev[r], gradTemp, temperature, this.tempNIDW.getValue()) : this.idwTemp.getIDW(rainX[r], rainY[r], temperature, this.tempNIDW.getValue());
            double rainWind = rsqWind > this.regThres.getValue() ? this.idwWind.getElevationCorrectedIDW(rainX[r], rainY[r], rainElev[r], gradWind, wind, this.windNIDW.getValue()) : this.idwWind.getIDW(rainX[r], rainY[r], temperature, this.windNIDW.getValue());
            double pSnow = (this.snow_trs.getValue() + this.snow_trans.getValue() - rainTemp) / (2.0 * this.snow_trans.getValue());
            if (pSnow > 1.0) {
                pSnow = 1.0;
            } else if (pSnow < 0.0) {
                pSnow = 0.0;
            }
            double rain = (1.0 - pSnow) * precip[r];
            double snow = pSnow * precip[r];
            if (snow > 0.0) {
                if (snow <= 0.1) {
                    snow += snow * 0.938;
                } else {
                    double relSnow = 0.5319 * Math.pow(snow, -0.197);
                    snow += snow * relSnow;
                }
            }
            if (rain > 0.0) {
                rain = rain < 0.1 ? (rain += rain * 0.492) : (rain += rain * (0.1349 * Math.pow(rain, -0.494)));
            }
            if (snow > 0.0) {
                double CR_snow;
                if (snow <= 0.1) {
                    snow += snow * 0.938;
                } else if (rainWind < 6.2) {
                    CR_snow = Math.exp(-0.056 * rainWind);
                    snow /= CR_snow;
                } else if (rainWind >= 6.2) {
                    CR_snow = Math.exp(-0.3472);
                    snow /= CR_snow;
                }
            }
            double wetErr = precip[r] < 0.1 ? 0.0 : (this.time.get(2) >= 4 & this.time.get(2) < 10 ? (precip[r] >= 9.0 ? 0.47 : 0.08 * Math.log(precip[r]) + 0.225) : (precip[r] >= 9.0 ? 0.3 : 0.05 * Math.log(precip[r]) + 0.13));
            rcorr[r] = precip[r] == JAMS.getMissingDataValue() ? JAMS.getMissingDataValue() : rain + snow + wetErr;
        }
        this.rcorr.setValue(rcorr);
    }
}

