/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="DewPoint2RelativeHumidity", author="Sven Kralisch", description="Calculation of relative humidity from dew point based on Magnus formula, taken from https://en.wikipedia.org/wiki/Dew_point", date="2025-02-16", version="1.0_2")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Muliplied rhum value by 100 to get \"%\""), @VersionComments.Entry(version="1.0_2", comment="Calcultion slightly adapted and mode switch removed")})
public class DewPoint2RelativeHumidity
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="dew point temperature", unit="\u00b0C")
    public Attribute.Double dewPoint;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="temperature", unit="\u00b0C")
    public Attribute.Double temp;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="relative humidity", unit="%")
    public Attribute.Double rhum;

    public void init() {
    }

    public void run() {
        double b = 17.62;
        double c = 243.12;
        double d = this.dewPoint.getValue();
        double T = this.temp.getValue();
        double h = Math.exp(d * b / (c + d) - b * T / (c + T));
        this.rhum.setValue(h * 100.0);
    }

    public void cleanup() {
    }
}

