/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.inputData;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import org.unijena.j2k.physicalCalculations.ClimatologicalVariables;

@JAMSComponentDescription(title="CalcRelativeHumidity", author="Peter Krause", description="Calculates relative humidity from temperature and absolute humidity", version="1.0_0", date="2011-05-30")
public class CalcRelativeHumidity
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable mean tempeature", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable absolute humidity", unit="g / m\u00b3")
    public Attribute.Double ahum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="state variable relative humidity", unit="%")
    public Attribute.Double rhum;

    public void init() {
    }

    public void run() {
        double maxHum = ClimatologicalVariables.calc_maxHum(this.tmean.getValue());
        double rh = this.ahum.getValue() / maxHum * 100.0;
        if (rh > 100.0) {
            rh = 100.0;
        }
        this.rhum.setValue(rh);
    }

    public void cleanup() {
    }
}

