/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k.efficiencies;

import java.util.Arrays;

public class VolumeError {
    public static double absVolumeError(double[] validation, double[] prediction) {
        double[] weight = new double[prediction.length];
        Arrays.fill(weight, 1.0);
        return VolumeError.absVolumeError(prediction, validation, weight);
    }

    public static double absVolumeError(double[] validation, double[] prediction, double[] weight) {
        double volError = 0.0;
        for (int i = 0; i < prediction.length; ++i) {
            volError += weight[i] * (prediction[i] - validation[i]);
        }
        return Math.abs(volError);
    }

    public static double pbias(double[] validation, double[] prediction) {
        double sumObs = 0.0;
        double sumDif = 0.0;
        for (int i = 0; i < prediction.length; ++i) {
            sumDif += prediction[i] - validation[i];
            sumObs += validation[i];
        }
        double pbias = sumDif / sumObs * 100.0;
        return pbias;
    }

    public static double pbias2(double[] validation, double[] prediction) {
        double sumObs = 0.0;
        double sumDif = 0.0;
        for (int i = 0; i < prediction.length; ++i) {
            sumDif += Math.abs(prediction[i] - validation[i]);
            sumObs += validation[i];
        }
        double pbias = sumDif / sumObs * 100.0;
        return pbias;
    }
}

