/*
 * Decompiled with CFR 0.152.
 */
package org.unijena.j2k;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="DoubleSetter", author="Sven Kralisch", date="2012-09-26", version="1.0_0", description="DoubleSetter can be used to set a number of attributes to one or more values. If \"value\" contains only one element, all \"attributes\" are set to this value. Otherwise \"value\" must contain one element for each attribute, i.e. sizes of \"attributes\" and \"value\" must be equal.")
public class DoubleSetter
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Double attributes to be set")
    public Attribute.Double[] attributes;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Double values")
    public Attribute.Double[] value;

    public void run() {
        block3: {
            block2: {
                if (this.value.length != 1) break block2;
                for (int i = 0; i < this.attributes.length; ++i) {
                    this.attributes[i].setValue(this.value[0].getValue());
                }
                break block3;
            }
            if (this.attributes.length != this.value.length) break block3;
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].setValue(this.value[i].getValue());
            }
        }
    }
}

