/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.sorting;

import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.jgrasstools.gears.libs.monitor.LogProgressMonitor;

public class QuickSortAlgorithmObjects {
    private double[] valuesToSort;
    private int number;
    private Object[] valuesToFollow;
    private IJGTProgressMonitor monitor = new LogProgressMonitor();

    public QuickSortAlgorithmObjects(IJGTProgressMonitor monitor) {
        if (monitor != null) {
            this.monitor = monitor;
        }
    }

    public void sort(double[] values, Object[] valuesToFollow) {
        this.valuesToSort = values;
        this.valuesToFollow = valuesToFollow;
        this.number = values.length;
        this.monitor.beginTask("Sorting...", -1);
        this.monitor.worked(1);
        this.quicksort(0, this.number - 1);
        this.monitor.done();
    }

    private void quicksort(int low, int high) {
        int i = low;
        int j = high;
        double pivot = this.valuesToSort[low + high >>> 1];
        while (i <= j) {
            while (this.valuesToSort[i] < pivot || JGTConstants.isNovalue(this.valuesToSort[i]) && !JGTConstants.isNovalue(pivot)) {
                ++i;
            }
            while (this.valuesToSort[j] > pivot || !JGTConstants.isNovalue(this.valuesToSort[j]) && JGTConstants.isNovalue(pivot)) {
                --j;
            }
            if (i > j) continue;
            this.exchange(i, j);
            ++i;
            --j;
        }
        if (low < j) {
            this.quicksort(low, j);
        }
        if (i < high) {
            this.quicksort(i, high);
        }
    }

    private void exchange(int i, int j) {
        double temp = this.valuesToSort[i];
        this.valuesToSort[i] = this.valuesToSort[j];
        this.valuesToSort[j] = temp;
        if (this.valuesToFollow != null) {
            Object tempFollow = this.valuesToFollow[i];
            this.valuesToFollow[i] = this.valuesToFollow[j];
            this.valuesToFollow[j] = tempFollow;
        }
    }
}

