/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math.functions;

import org.jgrasstools.gears.i18n.GearsMessageHandler;
import org.jgrasstools.gears.utils.math.functions.ISingleArgmentFunction;

public final class R_F
implements ISingleArgmentFunction {
    private double known;
    private double exponent;
    private final GearsMessageHandler msg = GearsMessageHandler.getInstance();

    @Override
    public double getValue(double x) {
        if (x >= 0.0 && this.exponent > 0.0 && this.known > 0.0 && this.known < 1.0) {
            return 1.0 - this.known - x * (1.0 - Math.exp(x) / (Math.exp(this.exponent) + Math.exp(x) - 1.0)) / (this.exponent + x - Math.log(Math.exp(this.exponent) + Math.exp(x) - 1.0));
        }
        throw new ArithmeticException(this.msg.message("rf.error.wrongSign"));
    }

    @Override
    public void setParameters(double ... params) {
        this.known = params[0];
        this.exponent = params[1];
    }
}

