/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.coverage;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.List;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.jgrasstools.gears.utils.math.NumericsUtilities;

public class ProfilePoint
implements Comparable<ProfilePoint> {
    private double progressive = Double.NaN;
    private double elevation = Double.NaN;
    private Coordinate position;

    public ProfilePoint(double progressive, double elevation, Coordinate position) {
        this.progressive = progressive;
        this.elevation = elevation;
        this.position = position;
    }

    public ProfilePoint(double progressive, double elevation, double easting, double northing) {
        this.progressive = progressive;
        this.elevation = elevation;
        this.position = new Coordinate(easting, northing);
    }

    public double getProgressive() {
        return this.progressive;
    }

    public double getElevation() {
        return this.elevation;
    }

    public Coordinate getPosition() {
        return this.position;
    }

    public static double getMeanSlope(List<ProfilePoint> points) {
        double meanSlope = 0.0;
        int num = 0;
        for (int i = 0; i < points.size() - 1; ++i) {
            ProfilePoint p1 = points.get(i);
            ProfilePoint p2 = points.get(i + 1);
            double dx = p2.progressive - p1.progressive;
            double dy = p2.elevation - p1.elevation;
            double tmpSlope = dy / dx;
            meanSlope += tmpSlope;
            ++num;
        }
        return meanSlope /= (double)num;
    }

    public static double[] getLastVisiblePointData(List<ProfilePoint> profile) {
        if (profile.size() < 2) {
            throw new IllegalArgumentException("A profile needs to have at least 2 points.");
        }
        ProfilePoint first = profile.get(0);
        double baseElev = first.getElevation();
        Coordinate baseCoord = new Coordinate(0.0, 0.0);
        double minAzimuthAngle = Double.POSITIVE_INFINITY;
        double maxAzimuthAngle = Double.NEGATIVE_INFINITY;
        ProfilePoint minAzimuthPoint = null;
        ProfilePoint maxAzimuthPoint = null;
        for (int i = 1; i < profile.size(); ++i) {
            ProfilePoint currentPoint = profile.get(i);
            double currentElev = currentPoint.getElevation();
            if (JGTConstants.isNovalue(currentElev)) continue;
            currentElev -= baseElev;
            double currentProg = currentPoint.getProgressive();
            Coordinate currentCoord = new Coordinate(currentProg, currentElev);
            double azimuth = GeometryUtilities.azimuth(baseCoord, currentCoord);
            if (azimuth <= minAzimuthAngle) {
                minAzimuthAngle = azimuth;
                minAzimuthPoint = currentPoint;
            }
            if (!(azimuth >= maxAzimuthAngle)) continue;
            maxAzimuthAngle = azimuth;
            maxAzimuthPoint = currentPoint;
        }
        if (minAzimuthPoint == null || maxAzimuthPoint == null) {
            return null;
        }
        return new double[]{minAzimuthPoint.elevation, minAzimuthPoint.position.x, minAzimuthPoint.position.y, minAzimuthPoint.progressive, minAzimuthAngle, maxAzimuthPoint.elevation, maxAzimuthPoint.position.x, maxAzimuthPoint.position.y, maxAzimuthPoint.progressive, maxAzimuthAngle};
    }

    @Override
    public int compareTo(ProfilePoint o) {
        if (NumericsUtilities.dEq(this.progressive, o.progressive)) {
            return 0;
        }
        if (this.progressive > o.progressive) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return this.progressive + ", " + this.elevation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.elevation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        temp = Double.doubleToLongBits(this.progressive);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfilePoint other = (ProfilePoint)obj;
        Coordinate otherPosition = other.position;
        return NumericsUtilities.dEq(this.elevation, other.elevation) && NumericsUtilities.dEq(this.position.x, otherPosition.x) && NumericsUtilities.dEq(this.position.y, otherPosition.y);
    }
}

