/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.NameImpl;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.SLD;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.filter.FilterFactory;

public class SldUtilities {
    public static StyleFactory sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
    public static FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
    public static StyleBuilder sb = new StyleBuilder(sf, ff);
    public static final String GENERIC_FEATURE_TYPENAME = "Feature";

    public static Style getStyleFromFile(File file) throws IOException {
        SLDParser stylereader = new SLDParser(sf, file);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        Style style = SldUtilities.getDefaultStyle(sld);
        return style;
    }

    public static String styleToString(Style style) throws Exception {
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        UserLayer layer = sf.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[]{null});
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(style);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String xml = aTransformer.transform((Object)sld);
        return xml;
    }

    public static Style getDefaultStyle(StyledLayerDescriptor sld) {
        Style[] styles = SLD.styles((StyledLayerDescriptor)sld);
        for (int i = 0; i < styles.length; ++i) {
            Style style = styles[i];
            List ftStyles = style.featureTypeStyles();
            SldUtilities.genericizeftStyles(ftStyles);
            if (!style.isDefault()) continue;
            return style;
        }
        return styles[0];
    }

    private static void genericizeftStyles(List<FeatureTypeStyle> ftStyles) {
        for (FeatureTypeStyle featureTypeStyle : ftStyles) {
            featureTypeStyle.featureTypeNames().clear();
            featureTypeStyle.featureTypeNames().add(new NameImpl(GENERIC_FEATURE_TYPENAME));
        }
    }

    public static Color colorWithoutAlpha(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color colorWithAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }
}

