/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.modules;

import java.lang.reflect.Field;
import java.util.Collection;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Keywords;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.Unit;

public class ModelsSupporter {
    public static final String GRASSDB = "grassdb";
    public static final String LOCATION = "location";
    public static final String MAPSET = "mapset";
    public static final String STARTDATE = "time_start_up";
    public static final String ENDDATE = "time_ending_up";
    public static final String DELTAT = "time_delta";
    public static final String REMOTEDBURL = "remotedburl";
    public static final String ACTIVEREGIONWINDOW = "active region window";
    public static final String FEATURECOLLECTION = "featurecollection";
    public static final String UNKNOWN = "unknown";
    public static final String UNITID_RASTER = "raster unit id";
    public static final String UNITID_COLORMAP = "colormap unit id";
    public static final String UNITID_TEXTFILE = "text file unit id";
    public static final String UNITID_CATS = "categories unit id";
    public static final String UNITID_SCALAR = "scalar unit id";
    public static final String UNITID_FEATURE = "feature unit id";
    public static final String UNITID_UNKNOWN = "unknown unit id";
    public static final String CONSOLE = "CONSOLE";
    public static final String UITABLE = "UITABLE";
    public static final int[][] DIR = new int[][]{{0, 0}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}, {1, 0}, {1, 1}};
    public static final int[][] DIR_WITHFLOW_ENTERING = new int[][]{{0, 0, 0}, {0, 1, 5}, {-1, 1, 6}, {-1, 0, 7}, {-1, -1, 8}, {0, -1, 1}, {1, -1, 2}, {1, 0, 3}, {1, 1, 4}};
    public static final int[][] DIR_WITHFLOW_EXITING = new int[][]{{0, 0, 0}, {1, 0, 1}, {1, -1, 2}, {0, -1, 3}, {-1, -1, 4}, {-1, 0, 5}, {-1, 1, 6}, {0, 1, 7}, {1, 1, 8}, {0, 0, 9}, {0, 0, 10}};
    public static final int[][] DIR_WITHFLOW_EXITING_INVERTED = new int[][]{{0, 0, 0}, {0, 1, 1}, {-1, 1, 2}, {-1, 0, 3}, {-1, -1, 4}, {0, -1, 5}, {1, -1, 6}, {1, 0, 7}, {1, 1, 8}, {0, 0, 9}, {0, 0, 10}};
    public static final String COLORMAP = "colormap";
    public static final String TEXTFILE = "textfile";
    public static final String CATSMAP = "catsmap";
    public static final String GRASSRASTERMAP = "grassrastermap";
    public static final String DEFAULTKEY = "defaultkey";
    public static final String RESOLUTION = "resolution";

    public static double[] calculateDirectionFactor(double dx, double dy) {
        double[] fact = new double[9];
        for (int k = 1; k <= 8; ++k) {
            fact[k] = 1.0 / Math.sqrt((double)DIR[k][0] * dy * (double)DIR[k][0] * dy + (double)(DIR[k][1] * DIR[k][1]) * dx * dx);
        }
        return fact;
    }

    public static String getStatusString(int statusValue) {
        switch (statusValue) {
            case 40: {
                return "CERTIFIED";
            }
            case 10: {
                return "DRAFT";
            }
            case 5: {
                return "EXPERIMENTAL";
            }
            case 20: {
                return "TESTED";
            }
            case 30: {
                return "VALIDATED";
            }
        }
        return "DRAFT";
    }

    public static void collectParameters(StringBuilder sbTmp, Collection<Access> accessList, String pre) throws Exception {
        for (Access access : accessList) {
            Field field = access.getField();
            String fieldName = field.getName();
            Description descriptionAnnot = field.getAnnotation(Description.class);
            if (fieldName.equals("pm") || fieldName.equals("gf") || fieldName.equals("doProcess") || fieldName.equals("doReset")) continue;
            String fieldDescription = " - ";
            if (descriptionAnnot != null) {
                Unit unitAnn;
                fieldDescription = descriptionAnnot.value();
                if (fieldDescription == null) {
                    fieldDescription = " - ";
                }
                if ((unitAnn = field.getAnnotation(Unit.class)) != null) {
                    fieldDescription = fieldDescription + " [" + unitAnn.value() + "]";
                }
            }
            sbTmp.append(pre).append(fieldName).append(": ");
            sbTmp.append(fieldDescription).append("\n");
        }
    }

    public static String generateHelp(Object parent) throws Exception {
        Keywords keywords;
        License license;
        Author author;
        Name name;
        Class<?> moduleClass = parent.getClass();
        StringBuilder sb = new StringBuilder();
        Description description = moduleClass.getAnnotation(Description.class);
        String descriptionStr = description.value();
        String NEWLINE = "\n";
        if (description != null) {
            sb.append("Description").append(NEWLINE);
            sb.append("-----------").append(NEWLINE);
            sb.append(NEWLINE);
            sb.append(descriptionStr);
            sb.append(NEWLINE);
            sb.append(NEWLINE);
        }
        sb.append("General Information").append(NEWLINE);
        sb.append("-------------------").append(NEWLINE);
        sb.append(NEWLINE);
        Status status = moduleClass.getAnnotation(Status.class);
        if (status != null) {
            sb.append("Module status: " + ModelsSupporter.getStatusString(status.value())).append(NEWLINE);
        }
        if ((name = moduleClass.getAnnotation(Name.class)) != null) {
            String nameStr = name.value();
            sb.append("Name to use in an OMS3 script: " + nameStr + "").append(NEWLINE);
        }
        if ((author = moduleClass.getAnnotation(Author.class)) != null) {
            String authorNameStr = author.name();
            String[] authorNameSplit = authorNameStr.split(",");
            String authorContactStr = author.contact();
            String[] authorContactSplit = authorContactStr.split(",");
            sb.append("Authors").append(NEWLINE);
            for (String authorName : authorNameSplit) {
                sb.append("* ").append(authorName.trim()).append(NEWLINE);
            }
            sb.append(NEWLINE);
            sb.append("Contacts: ").append(NEWLINE);
            for (String authorContact : authorContactSplit) {
                sb.append("* ").append(authorContact.trim()).append(NEWLINE);
            }
            sb.append(NEWLINE);
        }
        if ((license = moduleClass.getAnnotation(License.class)) != null) {
            String licenseStr = license.value();
            sb.append("License: " + licenseStr).append(NEWLINE);
        }
        if ((keywords = moduleClass.getAnnotation(Keywords.class)) != null) {
            String keywordsStr = keywords.value();
            sb.append("Keywords: " + keywordsStr).append(NEWLINE);
        }
        sb.append(NEWLINE);
        Object annotatedObject = moduleClass.newInstance();
        ComponentAccess cA = new ComponentAccess(annotatedObject);
        sb.append("Parameters").append(NEWLINE);
        sb.append("----------").append(NEWLINE);
        sb.append(NEWLINE);
        Collection inputs = cA.inputs();
        StringBuilder sbTmp = new StringBuilder();
        ModelsSupporter.collectParameters(sbTmp, inputs, "\t");
        String params = sbTmp.toString();
        if (params.trim().length() > 0) {
            sb.append("\tInput Parameters").append(NEWLINE);
            sb.append("\t----------------").append(NEWLINE);
            sb.append(params);
            sb.append(NEWLINE);
        }
        Collection outputs = cA.outputs();
        sbTmp = new StringBuilder();
        ModelsSupporter.collectParameters(sbTmp, outputs, "\t");
        params = sbTmp.toString();
        if (params.trim().length() > 0) {
            sb.append("\tOutput Parameters").append(NEWLINE);
            sb.append("\t-----------------").append(NEWLINE);
            sb.append(params);
            sb.append(NEWLINE);
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    public static String generateTemplate(Object parent) {
        Field[] fields;
        Class<?> class1 = parent.getClass();
        String name = class1.getSimpleName();
        StringBuilder sb = new StringBuilder();
        String newName = name;
        String varName = name.toLowerCase();
        sb.append(newName).append(" ").append(varName).append(" = new ");
        sb.append(newName).append("();\n");
        for (Field field : fields = class1.getFields()) {
            String fname = field.getName();
            if (fname.equals("pm") || fname.equals("gf") || fname.equals("doProcess") || fname.equals("doReset")) continue;
            Class<String> cl = field.getType();
            Out out = field.getAnnotation(Out.class);
            if (out != null) continue;
            if (cl.isAssignableFrom(String.class)) {
                sb.append(varName).append(".").append(fname).append(" = \"\";\n");
                continue;
            }
            sb.append(varName).append(".").append(fname).append(" = ?;\n");
        }
        sb.append(varName).append(".process();\n");
        return sb.toString();
    }
}

