/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.vectorreader;

import java.io.File;
import java.io.IOException;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.jgrasstools.gears.io.properties.OmsPropertiesFeatureReader;
import org.jgrasstools.gears.io.shapefile.OmsShapefileFeatureReader;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Vectors features reader module.")
@Documentation(value="OmsVectorReader.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Reading")
@Label(value="Vector Reader")
@Name(value="vectorreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsVectorReader
extends JGTModel {
    @Description(value="The vector type to read (Supported is: shp, properties).")
    @In
    public String pType = null;
    @Description(value="The vector file to read.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The read feature collection.")
    @Out
    public SimpleFeatureCollection outVector = null;

    @Execute
    public void process() throws IOException {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        this.checkNull(this.file);
        File vectorFile = new File(this.file);
        String name = vectorFile.getName();
        if (name.toLowerCase().endsWith("shp")) {
            OmsShapefileFeatureReader reader = new OmsShapefileFeatureReader();
            reader.file = vectorFile.getAbsolutePath();
            reader.pm = this.pm;
            reader.readFeatureCollection();
            this.outVector = reader.geodata;
            if (((SimpleFeatureType)this.outVector.getSchema()).getCoordinateReferenceSystem() == null) {
                this.pm.errorMessage("The coordinate reference system could not be defined for: " + reader.file);
            }
        } else if (name.toLowerCase().endsWith("properties")) {
            this.outVector = OmsPropertiesFeatureReader.readPropertiesfile(vectorFile.getAbsolutePath());
        } else {
            throw new IOException("Format is currently not supported for file: " + name);
        }
    }

    public static SimpleFeatureCollection readVector(String path) throws IOException {
        SimpleFeatureCollection fc = OmsVectorReader.getFC(path);
        return fc;
    }

    private static SimpleFeatureCollection getFC(String path) throws IOException {
        OmsVectorReader reader = new OmsVectorReader();
        reader.file = path;
        reader.process();
        SimpleFeatureCollection fc = reader.outVector;
        return fc;
    }

    public static ReferencedEnvelope readEnvelope(String filePath) throws IOException {
        File shapeFile = new File(filePath);
        FileDataStore store = FileDataStoreFinder.getDataStore((File)shapeFile);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        return featureSource.getBounds();
    }
}

