/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.shapefile;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

@Description(value="Utility class for writing geotools featurecollections to shapefile.")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="IO, Shapefile, Feature, Vector, Writing")
@Label(value="Vector Writer")
@Name(value="shapefilefeaturewriter")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
@UI(value="hide")
public class OmsShapefileFeatureWriter
extends JGTModel {
    @Description(value="The feature collection to write.")
    @In
    public SimpleFeatureCollection geodata = null;
    @Description(value="The shapefile to which to write to.")
    @UI(value="outfile")
    @In
    public String file = null;
    @Description(value="Create also the spatial index for the file.")
    @In
    public boolean doIndex = true;
    @Description(value="The feature type. It's mandatory only if you want to write down an empty FeatureCollection")
    @In
    public SimpleFeatureType pType = null;
    private boolean hasWritten = false;

    @Execute
    public void writeFeatureCollection() throws IOException {
        if (!this.concatOr(!this.hasWritten, this.doReset)) {
            return;
        }
        this.pm.beginTask("Writing features to shapefile...", -1);
        if (!this.file.endsWith(".shp")) {
            this.file = this.file + ".shp";
        }
        if (this.geodata != null && this.geodata.size() != 0) {
            this.pType = (SimpleFeatureType)this.geodata.getSchema();
        }
        File shapeFile = new File(this.file);
        FileDataStoreFactorySpi factory = FileDataStoreFinder.getDataStoreFactory((String)"shp");
        Map<String, URL> map = Collections.singletonMap("url", shapeFile.toURI().toURL());
        DataStore newDataStore = factory.createNewDataStore(map);
        newDataStore.createSchema((FeatureType)this.pType);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        SimpleFeatureStore featureStore = (SimpleFeatureStore)newDataStore.getFeatureSource(typeName);
        featureStore.setTransaction((Transaction)transaction);
        try {
            if (this.geodata == null) {
                featureStore.addFeatures((FeatureCollection)new DefaultFeatureCollection());
            } else {
                featureStore.addFeatures((FeatureCollection)this.geodata);
            }
            transaction.commit();
        }
        catch (Exception problem) {
            transaction.rollback();
            throw new IOException(problem.getLocalizedMessage());
        }
        finally {
            transaction.close();
            this.pm.done();
        }
        this.hasWritten = true;
    }

    public static void writeShapefile(String path, SimpleFeatureCollection featureCollection, IJGTProgressMonitor pm) throws IOException {
        OmsShapefileFeatureWriter writer = new OmsShapefileFeatureWriter();
        if (pm != null) {
            writer.pm = pm;
        }
        writer.file = path;
        writer.geodata = featureCollection;
        writer.writeFeatureCollection();
    }

    public static void writeEmptyShapefile(String path, SimpleFeatureType schema, IJGTProgressMonitor pm) throws IOException {
        OmsShapefileFeatureWriter writer = new OmsShapefileFeatureWriter();
        if (pm != null) {
            writer.pm = pm;
        }
        writer.file = path;
        writer.pType = schema;
        writer.writeFeatureCollection();
    }
}

