/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.geopaparazzi.geopap4;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.TableDescriptions;
import org.jgrasstools.gears.io.geopaparazzi.geopap4.TimeUtilities;

public class DaoMetadata {
    public static final String EMPTY_VALUE = " - ";

    public static void createTables(Connection connection) throws Exception {
        StringBuilder sB = new StringBuilder();
        sB.append("CREATE TABLE ");
        sB.append("metadata");
        sB.append(" (");
        sB.append(TableDescriptions.MetadataTableFields.COLUMN_KEY.getFieldName()).append(" TEXT NOT NULL, ");
        sB.append(TableDescriptions.MetadataTableFields.COLUMN_VALUE.getFieldName()).append(" TEXT NOT NULL ");
        sB.append(");");
        String CREATE_TABLE_PROJECT = sB.toString();
        try (Statement statement = connection.createStatement();){
            statement.setQueryTimeout(30);
            statement.executeUpdate(CREATE_TABLE_PROJECT);
        }
        catch (Exception e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static void fillProjectMetadata(Connection connection, String name, String description, String notes, String creationUser) throws Exception {
        Date creationDate = new Date();
        if (name == null) {
            name = "project-" + TimeUtilities.INSTANCE.TIME_FORMATTER_LOCAL.format(creationDate);
        }
        if (description == null) {
            description = EMPTY_VALUE;
        }
        if (notes == null) {
            notes = EMPTY_VALUE;
        }
        if (creationUser == null) {
            creationUser = "dummy user";
        }
        DaoMetadata.insertPair(connection, TableDescriptions.MetadataTableFields.KEY_NAME.getFieldName(), name);
        DaoMetadata.insertPair(connection, TableDescriptions.MetadataTableFields.KEY_DESCRIPTION.getFieldName(), description);
        DaoMetadata.insertPair(connection, TableDescriptions.MetadataTableFields.KEY_NOTES.getFieldName(), notes);
        DaoMetadata.insertPair(connection, TableDescriptions.MetadataTableFields.KEY_CREATIONTS.getFieldName(), String.valueOf(creationDate.getTime()));
        DaoMetadata.insertPair(connection, TableDescriptions.MetadataTableFields.KEY_LASTTS.getFieldName(), EMPTY_VALUE);
        DaoMetadata.insertPair(connection, TableDescriptions.MetadataTableFields.KEY_CREATIONUSER.getFieldName(), creationUser);
        DaoMetadata.insertPair(connection, TableDescriptions.MetadataTableFields.KEY_LASTUSER.getFieldName(), EMPTY_VALUE);
    }

    private static void insertPair(Connection connection, String key, String value) throws SQLException {
        String insertSQL = "INSERT INTO metadata(" + TableDescriptions.MetadataTableFields.COLUMN_KEY.getFieldName() + ", " + TableDescriptions.MetadataTableFields.COLUMN_VALUE.getFieldName() + ") VALUES" + "(?,?)";
        try (PreparedStatement writeImageDataStatement = connection.prepareStatement(insertSQL);){
            writeImageDataStatement.setString(1, key);
            writeImageDataStatement.setString(2, value);
            writeImageDataStatement.executeUpdate();
        }
    }
}

