/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.exif;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageInputStream;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.jgrasstools.gears.io.exif.ExifTag;
import org.jgrasstools.gears.io.exif.ExifUtil;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.w3c.dom.NodeList;

@Description(value="Utility class for reading exif tags in jpegs.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Jpeg, Exif, Reading")
@Label(value="Generic Reader")
@Name(value="exifreader")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class ExifReader
extends JGTModel {
    @Description(value="The jpeg file.")
    @In
    public String file = null;
    @Description(value="The read exif tags.")
    @Out
    public HashMap<String, ExifTag> outTags = null;

    @Execute
    public void readExif() throws IOException {
        ImageReader reader = ExifUtil.findReader();
        reader.setInput(new FileImageInputStream(new File(this.file)));
        IIOMetadata imageMetadata = reader.getImageMetadata(0);
        this.parseExifMeta(imageMetadata);
    }

    private void parseExifMeta(IIOMetadata exifMeta) {
        this.outTags = new HashMap();
        IIOMetadataNode root = (IIOMetadataNode)exifMeta.getAsTree("com_sun_media_imageio_plugins_tiff_image_1.0");
        NodeList imageDirectories = root.getElementsByTagName("TIFFIFD");
        for (int i = 0; i < imageDirectories.getLength(); ++i) {
            IIOMetadataNode directory = (IIOMetadataNode)imageDirectories.item(i);
            NodeList tiffTags = directory.getElementsByTagName("TIFFField");
            for (int j = 0; j < tiffTags.getLength(); ++j) {
                IIOMetadataNode tag = (IIOMetadataNode)tiffTags.item(j);
                String tagNumber = tag.getAttribute("number");
                String tagName = tag.getAttribute("name");
                StringBuilder tmp = new StringBuilder();
                IIOMetadataNode values = (IIOMetadataNode)tag.getFirstChild();
                if ("TIFFUndefined".equals(values.getNodeName())) {
                    tmp.append(values.getAttribute("value"));
                } else {
                    NodeList tiffNumbers = values.getChildNodes();
                    for (int k = 0; k < tiffNumbers.getLength(); ++k) {
                        tmp.append(((IIOMetadataNode)tiffNumbers.item(k)).getAttribute("value"));
                        tmp.append(",");
                    }
                    tmp.deleteCharAt(tmp.length() - 1);
                }
                String tagValue = tmp.toString();
                ExifTag exifTag = new ExifTag(tagName, tagNumber, tagValue);
                this.outTags.put(tagName, exifTag);
            }
        }
    }
}

