/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.eicalculator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.jgrasstools.gears.io.eicalculator.EIAreas;
import org.jgrasstools.gears.libs.modules.JGTModel;

@Description(value="Utility class for reading area data (for EICalculator) from csv files.")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="IO, Reading")
@Label(value="List Data Reader")
@Name(value="eiareasreader")
@Status(value=40)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsEIAreasReader
extends JGTModel {
    @Description(value="The csv file to read from.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The csv separator.")
    @In
    public String pSeparator = ",";
    @Description(value="The read data.")
    @Out
    public List<EIAreas> outAreas;
    private BufferedReader csvReader;

    private void ensureOpen() throws IOException {
        if (this.csvReader == null) {
            this.csvReader = new BufferedReader(new FileReader(this.file));
        }
    }

    @Finalize
    public void close() throws IOException {
        this.csvReader.close();
    }

    @Execute
    public void read() throws IOException {
        if (!this.concatOr(this.outAreas == null, this.doReset)) {
            return;
        }
        this.ensureOpen();
        this.outAreas = new ArrayList<EIAreas>();
        String line = null;
        while ((line = this.csvReader.readLine()) != null) {
            if (line.trim().length() == 0 || line.trim().startsWith("#")) continue;
            String[] lineSplit = line.split(this.pSeparator);
            if (lineSplit.length > 4) {
                throw new IOException("Area values are defined in 4 columns.");
            }
            EIAreas eiAreas = new EIAreas();
            eiAreas.basinId = Integer.parseInt(lineSplit[0].trim());
            eiAreas.altimetricBandId = Integer.parseInt(lineSplit[1].trim());
            eiAreas.energyBandId = Integer.parseInt(lineSplit[2].trim());
            eiAreas.areaValue = Double.parseDouble(lineSplit[3].trim());
            this.outAreas.add(eiAreas);
        }
    }
}

