/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects;

import java.util.Vector;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.DwgObject;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.DwgUtil;

public class DwgLine
extends DwgObject {
    private double[] p1;
    private double[] p2;
    private double thickness;
    private double[] extrusion;
    private boolean zflag = false;

    public void readDwgLineV15(int[] data, int offset) throws Exception {
        double z;
        double x;
        double y;
        double val;
        double[] p2;
        double[] p1;
        int bitPos = offset;
        bitPos = this.readObjectHeaderV15(data, bitPos);
        Vector v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        this.zflag = (Boolean)v.get(1);
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double x1 = (Double)v.get(1);
        v = DwgUtil.getDefaultDouble(data, bitPos, x1);
        bitPos = (Integer)v.get(0);
        double x2 = (Double)v.get(1);
        v = DwgUtil.getRawDouble(data, bitPos);
        bitPos = (Integer)v.get(0);
        double y1 = (Double)v.get(1);
        v = DwgUtil.getDefaultDouble(data, bitPos, y1);
        bitPos = (Integer)v.get(0);
        double y2 = (Double)v.get(1);
        if (!this.zflag) {
            v = DwgUtil.getRawDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            double z1 = (Double)v.get(1);
            v = DwgUtil.getDefaultDouble(data, bitPos, z1);
            bitPos = (Integer)v.get(0);
            double z2 = (Double)v.get(1);
            p1 = new double[]{x1, y1, z1};
            p2 = new double[]{x2, y2, z2};
        } else {
            p1 = new double[]{x1, y1};
            p2 = new double[]{x2, y2};
        }
        this.p1 = p1;
        this.p2 = p2;
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        boolean flag = (Boolean)v.get(1);
        if (flag) {
            val = 0.0;
        } else {
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            val = (Double)v.get(1);
        }
        this.thickness = val;
        v = DwgUtil.testBit(data, bitPos);
        bitPos = (Integer)v.get(0);
        flag = (Boolean)v.get(1);
        if (flag) {
            y = 0.0;
            x = 0.0;
            z = 1.0;
        } else {
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            x = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            y = (Double)v.get(1);
            v = DwgUtil.getBitDouble(data, bitPos);
            bitPos = (Integer)v.get(0);
            z = (Double)v.get(1);
        }
        double[] coord = new double[]{x, y, z};
        this.extrusion = coord;
        bitPos = this.readObjectTailV15(data, bitPos);
    }

    public double[] getP1() {
        return this.p1;
    }

    public void setP1(double[] p1) {
        this.p1 = p1;
    }

    public double[] getP2() {
        return this.p2;
    }

    public void setP2(double[] p2) {
        this.p2 = p2;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public Object clone() {
        DwgLine dwgLine = new DwgLine();
        dwgLine.setType(this.type);
        dwgLine.setHandle(this.handle);
        dwgLine.setVersion(this.version);
        dwgLine.setMode(this.mode);
        dwgLine.setLayerHandle(this.layerHandle);
        dwgLine.setColor(this.color);
        dwgLine.setNumReactors(this.numReactors);
        dwgLine.setNoLinks(this.noLinks);
        dwgLine.setLinetypeFlags(this.linetypeFlags);
        dwgLine.setPlotstyleFlags(this.plotstyleFlags);
        dwgLine.setSizeInBits(this.sizeInBits);
        dwgLine.setExtendedData(this.extendedData);
        dwgLine.setGraphicData(this.graphicData);
        dwgLine.setP1(this.p1);
        dwgLine.setP2(this.p2);
        dwgLine.setThickness(this.thickness);
        dwgLine.setExtrusion(this.extrusion);
        return dwgLine;
    }

    public boolean isZflag() {
        return this.zflag;
    }

    public void setZflag(boolean zflag) {
        this.zflag = zflag;
    }
}

