/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.disktree;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import org.jgrasstools.gears.io.disktree.IDiskTree;

public class DiskTreeWriter
implements IDiskTree {
    private final String path;

    public DiskTreeWriter(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGeometries(Geometry[] geometries) throws IOException {
        File file = new File(this.path);
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            int major = 1;
            int minor = 13;
            raf.writeChars("jts");
            raf.writeInt(major);
            raf.writeInt(minor);
            long geometriesStart = 30L;
            raf.seek(geometriesStart);
            System.out.println("geometriesStart: " + geometriesStart);
            long fileIndex = geometriesStart;
            STRtree tree = new STRtree(geometries.length);
            for (int i = 0; i < geometries.length; ++i) {
                Geometry geometry = geometries[i];
                if (geometry.isEmpty()) continue;
                Envelope envelope = geometry.getEnvelopeInternal();
                byte[] geomBytes = this.serialize(geometry);
                raf.write(geomBytes);
                tree.insert(envelope, (Object)new long[]{fileIndex, geomBytes.length});
                System.out.println("geom: " + i + " finished at: " + (fileIndex += (long)geomBytes.length));
            }
            raf.seek(14L);
            raf.writeLong(fileIndex);
            System.out.println("INDEX_ADDRESS_POSITION: " + fileIndex);
            byte[] treeBytes = this.serialize(tree);
            long treeSize = treeBytes.length;
            raf.seek(fileIndex);
            raf.write(treeBytes, 0, (int)treeSize);
            System.out.println("treeSize: " + treeSize);
            raf.seek(22L);
            raf.writeLong(treeSize);
            long length = raf.length();
            System.out.println(length);
        }
        finally {
            System.out.println("close");
            if (raf != null) {
                raf.close();
            }
        }
    }

    private byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(obj);
        out.close();
        byte[] treeBytes = bos.toByteArray();
        return treeBytes;
    }
}

