/*
 * Decompiled with CFR 0.152.
 */
package soilWater;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="J2KProcessLumpedSoilWater", author="Peter Krause, DPS modified by Markus Meinhardt", description="Calculates soil water balance for each spatial modelling unit; depression storage on slopes >2\u00b0 is 50% of the normal dep. storage", version="1.0_0", date="2011-05-30")
public class J2KProcessLumpedSoilWater_DPSmod
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The current spatial modelling entity")
    public Attribute.Entity entity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute area", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="attribute slope", unit="deg")
    public Attribute.Double slope;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="sealed grade")
    public Attribute.Double sealedGrade;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state variable net rain", unit="L")
    public Attribute.Double netRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state variable net snow", unit="L")
    public Attribute.Double netSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="state variable potET", unit="L")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state variable actET", unit="L")
    public Attribute.Double actET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="snow depth", unit="mm")
    public Attribute.Double snowDepth;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily snow melt", unit="L")
    public Attribute.Double snowMelt;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum MPS", unit="L")
    public Attribute.Double maxMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum LPS", unit="L")
    public Attribute.Double maxLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state var actual MPS", unit="L")
    public Attribute.Double actMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state var actual LPS", unit="L")
    public Attribute.Double actLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state var actual depression storage", unit="L")
    public Attribute.Double actDPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state var saturation of MPS")
    public Attribute.Double satMPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state var saturation of LPS")
    public Attribute.Double satLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="state var saturation of whole soil")
    public Attribute.Double satSoil;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="statevar infiltration", unit="L")
    public Attribute.Double infiltration;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="statevar interflow", unit="L")
    public Attribute.Double interflow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="statevar percolation", unit="L")
    public Attribute.Double percolation;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="statevar RD1 inflow", unit="L")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="statevar RD1 outflow", unit="L")
    public Attribute.Double outRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="statevar RD1 generation", unit="L")
    public Attribute.Double genRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="statevar RD2 inflow", unit="L")
    public Attribute.Double inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="statevar RD2 outflow", unit="L")
    public Attribute.Double outRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="statevar RD2 generation", unit="L")
    public Attribute.Double genRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum depression storage", unit="L")
    public Attribute.Double soilMaxDPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="poly reduction of ETP", lowerBound=0.0, upperBound=10.0, defaultValue="3.0")
    public Attribute.Double soilPolRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="linear reduction of ETP", lowerBound=0.0, upperBound=1.0, defaultValue="0.6")
    public Attribute.Double soilLinRed;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum infiltration rate in summer for one time step", lowerBound=0.0, upperBound=100.0, defaultValue="50.0", unit="mm")
    public Attribute.Double soilMaxInfSummer;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum infiltration rate in winter for one time step", lowerBound=0.0, upperBound=100.0, defaultValue="50.0", unit="mm")
    public Attribute.Double soilMaxInfWinter;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum infiltration rate on snow for one time step", lowerBound=0.0, upperBound=100.0, defaultValue="50.0", unit="mm")
    public Attribute.Double soilMaxInfSnow;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum infiltration part on sealed areas (gt 80%)", lowerBound=0.0, upperBound=1.0, defaultValue="0.25")
    public Attribute.Double soilImpGT80;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum infiltration part on sealed areas (lt 80%)", lowerBound=0.0, upperBound=1.0, defaultValue="0.75")
    public Attribute.Double soilImpLT80;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="MPS/LPS distribution coefficient for inflow", lowerBound=0.0, upperBound=10.0, defaultValue="1.0")
    public Attribute.Double soilDistMPSLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="MPS/LPS diffusion coefficient", lowerBound=0.0, upperBound=10.0, defaultValue="1.0")
    public Attribute.Double soilDiffMPSLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="LPS outflow coefficient", lowerBound=0.0, upperBound=10.0, defaultValue="1.0")
    public Attribute.Double soilOutLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="LPS lateral-vertical distribution coefficient", lowerBound=0.0, upperBound=10.0, defaultValue="1.0")
    public Attribute.Double soilLatVertLPS;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="maximum percolation rate [mm/d]", lowerBound=0.0, upperBound=20.0, defaultValue="5.0", unit="mm d^-1")
    public Attribute.Double soilMaxPerc;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="concentration coefficient for RD1", lowerBound=0.0, upperBound=10.0, defaultValue="2.0")
    public Attribute.Double soilConcRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="concentration coefficient for RD2", lowerBound=1.0, upperBound=20.0, defaultValue="8.0")
    public Attribute.Double soilConcRD2;
    double run_maxMPS;
    double run_maxLPS;
    double run_actMPS;
    double run_actLPS;
    double run_satMPS;
    double run_actDPS;
    double run_satLPS;
    double run_satSoil;
    double run_inRD1;
    double run_inRD2;
    double run_inRain;
    double run_inSnow;
    double run_snowMelt;
    double run_infiltration;
    double run_interflow;
    double run_percolation;
    double run_overlandflow;
    double run_potETP;
    double run_actETP;
    double run_snowDepth;
    double run_area;
    double run_slope;
    double run_outRD1;
    double run_outRD2;
    double run_genRD1;
    double run_genRD2;

    public void init() {
    }

    public void run() {
        this.run_area = this.area.getValue();
        this.run_slope = this.slope.getValue();
        this.run_maxMPS = this.maxMPS.getValue();
        this.run_maxLPS = this.maxLPS.getValue();
        this.run_actMPS = this.actMPS.getValue();
        this.run_actLPS = this.actLPS.getValue();
        this.run_satMPS = this.satMPS.getValue();
        this.run_satLPS = this.satLPS.getValue();
        this.run_actDPS = this.actDPS.getValue();
        this.run_inRD1 = this.inRD1.getValue();
        this.run_inRD2 = this.inRD2.getValue();
        this.run_inRain = this.netRain.getValue();
        this.run_inSnow = this.netSnow.getValue();
        this.run_potETP = this.potET.getValue();
        this.run_actETP = this.actET.getValue();
        this.run_snowDepth = this.snowDepth.getValue();
        this.run_snowMelt = this.snowMelt.getValue();
        this.run_genRD1 = 0.0;
        this.run_genRD2 = 0.0;
        this.run_outRD1 = 0.0;
        this.run_outRD2 = 0.0;
        this.run_interflow = 0.0;
        this.run_percolation = 0.0;
        this.calcSoilSaturations(false);
        this.redistRD1_RD2_in();
        this.calcPreInfEvaporation();
        this.run_infiltration = this.run_inRain + this.run_inSnow + this.run_snowMelt + this.run_actDPS;
        this.run_actDPS = 0.0;
        this.run_inRain = 0.0;
        this.run_inSnow = 0.0;
        this.run_snowMelt = 0.0;
        this.calcInfImperv(this.sealedGrade.getValue());
        double maxInf = this.calcMaxInfiltration(this.time.get(2) + 1);
        if (maxInf < this.run_infiltration) {
            double deltaInf = this.run_infiltration - maxInf;
            this.run_actDPS += deltaInf;
            this.run_infiltration = maxInf;
        }
        this.run_infiltration = this.calcMPSInflow(this.run_infiltration);
        this.calcMPSTranspiration(false);
        this.run_infiltration = this.calcLPSInflow(this.run_infiltration);
        this.calcSoilSaturations(false);
        double MobileWater = 0.0;
        MobileWater = this.run_actLPS > 0.0 ? this.calcLPSoutflow() : 0.0;
        this.calcIntfPercRates(MobileWater);
        this.run_overlandflow += this.calcDirectRunoff();
        this.calcRD1_RD2_out();
        this.calcDiffusion();
        this.calcSoilSaturations(false);
        this.satSoil.setValue(this.run_satSoil);
        this.satMPS.setValue(this.run_satMPS);
        this.satLPS.setValue(this.run_satLPS);
        this.actMPS.setValue(this.run_actMPS);
        this.actLPS.setValue(this.run_actLPS);
        this.actDPS.setValue(this.run_actDPS);
        this.netRain.setValue(this.run_inRain);
        this.netSnow.setValue(this.run_inSnow);
        this.actET.setValue(this.run_actETP);
        this.inRD1.setValue(this.run_inRD1);
        this.inRD2.setValue(this.run_inRD2);
        this.outRD1.setValue(this.run_outRD1);
        this.outRD2.setValue(this.run_outRD2);
        this.genRD1.setValue(this.run_genRD1);
        this.genRD2.setValue(this.run_genRD2);
        this.percolation.setValue(this.run_percolation);
        this.interflow.setValue(this.run_interflow);
    }

    public void cleanup() {
    }

    private boolean calcSoilSaturations(boolean debug) {
        this.run_satLPS = this.run_actLPS > 0.0 && this.run_maxLPS > 0.0 ? this.run_actLPS / this.run_maxLPS : 0.0;
        this.run_satMPS = this.run_actMPS > 0.0 && this.run_maxMPS > 0.0 ? this.run_actMPS / this.run_maxMPS : 0.0;
        this.run_satSoil = (this.run_maxLPS > 0.0 | this.run_maxMPS > 0.0) & (this.run_actLPS > 0.0 | this.run_actMPS > 0.0) ? (this.run_actLPS + this.run_actMPS) / (this.run_maxLPS + this.run_maxMPS) : 0.0;
        return true;
    }

    private boolean redistRD1_RD2_in() {
        if (this.run_inRD1 > 0.0) {
            this.run_actDPS += this.run_inRD1;
            this.run_inRD1 = 0.0;
        }
        if (this.run_inRD2 > 0.0) {
            this.run_inRD2 = this.calcMPSInflow(this.run_inRD2);
            this.run_inRD2 = this.calcLPSInflow(this.run_inRD2);
            if (this.run_inRD2 > 0.0) {
                this.getModel().getRuntime().println("RD2 is not null");
            }
        }
        return true;
    }

    private boolean calcPreInfEvaporation() {
        double deltaETP = this.run_potETP - this.run_actETP;
        if (this.run_actDPS > 0.0) {
            if (this.run_actDPS >= deltaETP) {
                this.run_actDPS -= deltaETP;
                deltaETP = 0.0;
                this.run_actETP = this.run_potETP;
            } else {
                this.run_actDPS = 0.0;
                this.run_actETP = this.run_potETP - (deltaETP -= this.run_actDPS);
            }
        }
        return true;
    }

    private boolean calcInfImperv(double sealedGrade) {
        if (sealedGrade > 0.8) {
            this.run_overlandflow += (1.0 - this.soilImpGT80.getValue()) * this.run_infiltration;
            this.run_infiltration *= this.soilImpGT80.getValue();
        } else if (sealedGrade > 0.0 && sealedGrade <= 0.8) {
            this.run_overlandflow += (1.0 - this.soilImpLT80.getValue()) * this.run_infiltration;
            this.run_infiltration *= this.soilImpLT80.getValue();
        }
        return true;
    }

    private double calcMaxInfiltration(int nowmonth) {
        double maxInf = 0.0;
        this.calcSoilSaturations(false);
        maxInf = this.run_snowDepth > 0.0 ? this.soilMaxInfSnow.getValue() * this.run_area : (nowmonth >= 5 & nowmonth <= 10 ? (1.0 - this.run_satSoil) * this.soilMaxInfSummer.getValue() * this.run_area : (1.0 - this.run_satSoil) * this.soilMaxInfWinter.getValue() * this.run_area);
        return maxInf;
    }

    private boolean calcMPSTranspiration(boolean debug) {
        double sat_factor;
        double reductionFactor;
        double maxTrans = 0.0;
        this.calcSoilSaturations(debug);
        double deltaETP = this.run_potETP - this.run_actETP;
        if (this.soilLinRed.getValue() > 0.0) {
            if (this.run_satMPS < this.soilLinRed.getValue()) {
                double reductionFactor2 = this.run_satMPS / this.soilLinRed.getValue();
                maxTrans = deltaETP * reductionFactor2;
            } else {
                maxTrans = deltaETP;
            }
        } else if (this.soilPolRed.getValue() > 0.0 && (maxTrans = deltaETP * (reductionFactor = Math.pow(10.0, sat_factor = -10.0 * Math.pow(1.0 - this.run_satMPS, this.soilPolRed.getValue())))) > deltaETP) {
            maxTrans = deltaETP;
        }
        if (deltaETP > 0.0) {
            if (this.run_actMPS > maxTrans) {
                this.run_actMPS -= maxTrans;
                deltaETP -= maxTrans;
            } else {
                deltaETP -= this.run_actMPS;
                this.run_actMPS = 0.0;
            }
        }
        this.run_actETP = this.run_potETP - deltaETP;
        this.calcSoilSaturations(debug);
        return true;
    }

    private double calcMPSInflow(double infiltration) {
        double inflow = infiltration;
        this.calcSoilSaturations(false);
        if (inflow < this.run_maxMPS - this.run_actMPS) {
            if (this.run_actMPS == 0.0) {
                this.run_actMPS += inflow;
                inflow = 0.0;
            } else {
                double alpha = this.soilDistMPSLPS.getValue();
                if (this.run_satMPS == 0.0) {
                    this.run_satMPS = 1.0E-7;
                }
                double inMPS = inflow * (1.0 - Math.exp(-1.0 * alpha / this.run_satMPS));
                this.run_actMPS += inMPS;
                inflow -= inMPS;
            }
        } else {
            double deltaMPS = this.run_maxMPS - this.run_actMPS;
            this.run_actMPS = this.run_maxMPS;
            inflow -= deltaMPS;
        }
        return inflow;
    }

    private double calcLPSInflow(double infiltration) {
        this.run_actLPS += infiltration;
        infiltration = 0.0;
        if (this.run_actLPS > this.run_maxLPS) {
            this.run_actDPS += this.run_actLPS - this.run_maxLPS;
            this.run_actLPS = this.run_maxLPS;
        }
        return infiltration;
    }

    private double calcLPSoutflow() {
        double LPSoutflow;
        double potLPSoutflow;
        double alpha = this.soilOutLPS.getValue();
        if (this.run_satLPS == 1.0) {
            this.run_satLPS = 0.999999;
        }
        if ((potLPSoutflow = Math.pow(this.run_satSoil, alpha) * this.run_actLPS) > this.run_actLPS) {
            potLPSoutflow = this.run_actLPS;
        }
        if ((LPSoutflow = potLPSoutflow) > this.run_actLPS) {
            LPSoutflow = this.run_actLPS;
        }
        this.run_actLPS -= LPSoutflow;
        return LPSoutflow;
    }

    private boolean calcIntfPercRates(double MobileWater) {
        if (MobileWater > 0.0) {
            double slope_weight = Math.tan(this.run_slope * (Math.PI / 180)) * this.soilLatVertLPS.getValue();
            double part_perc = 1.0 - slope_weight;
            if (part_perc > 1.0) {
                part_perc = 1.0;
            } else if (part_perc < 0.0) {
                part_perc = 0.0;
            }
            double part_intf = 1.0 - part_perc;
            this.run_interflow = MobileWater * part_intf;
            this.run_percolation = MobileWater * part_perc;
            double maxPerc = this.soilMaxPerc.getValue() * this.run_area;
            if (this.run_percolation > maxPerc) {
                double rest = this.run_percolation - maxPerc;
                this.run_percolation = maxPerc;
                this.run_interflow += rest;
            }
        } else {
            this.run_interflow = 0.0;
            this.run_percolation = 0.0;
        }
        return true;
    }

    private double calcDirectRunoff() {
        double directRunoff = 0.0;
        if (this.run_actDPS > 0.0) {
            double maxDep = 0.0;
            maxDep = this.run_slope > 2.0 ? this.soilMaxDPS.getValue() * this.run_area / 2.0 : this.soilMaxDPS.getValue() * this.run_area;
            if (this.run_actDPS > maxDep) {
                directRunoff = this.run_actDPS - maxDep;
                this.run_actDPS = maxDep;
            }
        }
        return directRunoff;
    }

    private boolean calcRD1_RD2_out() {
        double RD1_output_factor = 1.0 / this.soilConcRD1.getValue();
        if (RD1_output_factor > 1.0) {
            RD1_output_factor = 1.0;
        } else if (RD1_output_factor < 0.0) {
            RD1_output_factor = 0.0;
        }
        double RD1_output = this.run_overlandflow * RD1_output_factor;
        this.run_actDPS += this.run_overlandflow - RD1_output;
        this.run_outRD1 += RD1_output;
        this.run_genRD1 = this.run_outRD1;
        double RD2_output_factor = 1.0 / this.soilConcRD2.getValue();
        if (RD2_output_factor > 1.0) {
            RD2_output_factor = 1.0;
        } else if (RD2_output_factor < 0.0) {
            RD2_output_factor = 0.0;
        }
        double RD2_output = this.run_interflow * RD2_output_factor;
        this.run_actLPS += this.run_interflow - RD2_output;
        this.run_outRD2 += RD2_output;
        this.run_genRD2 = this.run_outRD2;
        if (this.run_genRD2 < 0.0) {
            this.run_genRD2 = 0.0;
        }
        this.run_overlandflow = 0.0;
        this.run_interflow = 0.0;
        return true;
    }

    private boolean calcDiffusion() {
        double diffusion = 0.0;
        this.calcSoilSaturations(false);
        double deltaMPS = this.run_maxMPS - this.run_actMPS;
        if (this.run_satMPS == 0.0) {
            diffusion = 0.0;
        } else {
            double diff = this.soilDiffMPSLPS.getValue();
            diffusion = this.run_actLPS * (1.0 - Math.exp(-1.0 * diff / this.run_satMPS));
        }
        if (diffusion > this.run_actLPS) {
            diffusion = this.run_actLPS;
        }
        if (diffusion < deltaMPS) {
            this.run_actMPS += diffusion;
            this.run_actLPS -= diffusion;
        } else {
            double rest = this.run_maxMPS - this.run_actMPS;
            this.run_actMPS = this.run_maxMPS;
            this.run_actLPS -= rest;
        }
        return true;
    }
}

