/*
 * Decompiled with CFR 0.152.
 */
package irrigation;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="IrrigationDam_PumpFromReach", author="Sven Kralisch", description="TBD", date="2020-09-07", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class IrrigationDam_PumpFromReach
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current date")
    public Attribute.Calendar date;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Dam capacity", defaultValue="0", unit="m\u00b3", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double damCapacity;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Pumping capactiy from the river", defaultValue="0", unit="m\u00b3", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double riverPump;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian day at which pumping from river starts", defaultValue="1", lowerBound=0.0, upperBound=366.0)
    public Attribute.Double riverStart;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Julian day at which pumping from river ends", defaultValue="1", lowerBound=0.0, upperBound=366.0)
    public Attribute.Double riverEnd;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD1 component in reach", unit="L")
    public Attribute.Double inRD1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RD2 component in reach", unit="L")
    public Attribute.Double inRD2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG1 component in reach", unit="L")
    public Attribute.Double inRG1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="RG2 component in reach", unit="L")
    public Attribute.Double inRG2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Adaptation factor for reducing the water that is allowed to be pumped", defaultValue="1", lowerBound=0.0, upperBound=1.0)
    public Attribute.Double adaptationFactor;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Current dam storage", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double damStorage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Water volume pumped at current time step", defaultValue="0", unit="L", lowerBound=0.0, upperBound=Infinity)
    public Attribute.Double pumpVolume;

    public void run() {
        double availableCapacity = this.damCapacity.getValue() * 1000.0 - this.damStorage.getValue();
        double pumpedWater = 0.0;
        if (availableCapacity <= 0.0) {
            this.pumpVolume.setValue(0.0);
            return;
        }
        int julDay = this.date.getValue().get(6);
        double rStart = this.riverStart.getValue();
        double rEnd = this.riverEnd.getValue();
        double rJD = julDay;
        if (rStart > rEnd) {
            rEnd = 366.0 + rEnd;
            rJD = 366.0 + rJD;
        }
        if (rJD >= rStart && rJD <= rEnd) {
            double totalIn = this.inRD1.getValue() + this.inRD2.getValue() + this.inRG1.getValue() + this.inRG2.getValue();
            pumpedWater = Math.min(totalIn *= this.adaptationFactor.getValue(), this.riverPump.getValue() * 1000.0);
            pumpedWater = Math.min(pumpedWater, availableCapacity);
            double frac = pumpedWater / totalIn;
            this.inRD1.setValue(this.inRD1.getValue() * (1.0 - frac));
            this.inRD2.setValue(this.inRD2.getValue() * (1.0 - frac));
            this.inRG1.setValue(this.inRG1.getValue() * (1.0 - frac));
            this.inRG2.setValue(this.inRG2.getValue() * (1.0 - frac));
            this.damStorage.setValue(this.damStorage.getValue() + pumpedWater);
        }
        this.pumpVolume.setValue(pumpedWater);
    }

    public void cleanup() {
    }
}

